/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.horizontalclassmerging.policies;

import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.horizontalclassmerging.SingleClassPolicy;

public class NoClassInitializerWithObservableSideEffects
extends SingleClassPolicy {
    private boolean isKotlinLambda(DexProgramClass program) {
        return program.getKotlinInfo().isSyntheticClass() && program.getKotlinInfo().asSyntheticClass().isLambda();
    }

    @Override
    public boolean canMerge(DexProgramClass program) {
        if (!program.hasClassInitializer()) {
            return true;
        }
        DexEncodedMethod clinit = program.getClassInitializer();
        return clinit.getOptimizationInfo().classInitializerMayBePostponed() || this.isKotlinLambda(program);
    }

    @Override
    public String getName() {
        return "NoClassInitializerWithObservableSideEffects";
    }
}

