/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.horizontalclassmerging.policies;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.horizontalclassmerging.MergeGroup;
import com.android.tools.r8.horizontalclassmerging.MultiClassPolicy;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.function.Predicate;

public class NoDeadLocks
extends MultiClassPolicy {
    private final AppView<AppInfoWithLiveness> appView;

    public NoDeadLocks(AppView<AppInfoWithLiveness> appView) {
        this.appView = appView;
    }

    private boolean isSynchronizationClass(DexProgramClass clazz) {
        return this.appView.appInfo().isLockCandidate(clazz.type) || clazz.hasStaticSynchronizedMethods();
    }

    @Override
    public Collection<MergeGroup> apply(MergeGroup group) {
        LinkedList<MergeGroup> synchronizedGroups = new LinkedList<MergeGroup>();
        group.removeIf((Predicate<? super DexProgramClass>)((Predicate<DexProgramClass>)clazz -> {
            boolean synchronizationClass = this.isSynchronizationClass((DexProgramClass)clazz);
            if (synchronizationClass) {
                MergeGroup synchronizedGroup = new MergeGroup();
                synchronizedGroup.add((DexProgramClass)clazz);
                synchronizedGroups.add(synchronizedGroup);
            }
            return synchronizationClass;
        }));
        if (synchronizedGroups.isEmpty()) {
            return Collections.singletonList(group);
        }
        Iterator synchronizedGroupIterator = synchronizedGroups.iterator();
        for (DexProgramClass clazz2 : group) {
            if (!synchronizedGroupIterator.hasNext()) {
                synchronizedGroupIterator = synchronizedGroups.iterator();
            }
            ((MergeGroup)synchronizedGroupIterator.next()).add(clazz2);
        }
        this.removeTrivialGroups(synchronizedGroups);
        return synchronizedGroups;
    }

    @Override
    public String getName() {
        return "NoDeadLocks";
    }
}

