/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.horizontalclassmerging.policies;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.BottomUpClassHierarchyTraversal;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodSignature;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.SubtypingInfo;
import com.android.tools.r8.graph.TopDownClassHierarchyTraversal;
import com.android.tools.r8.horizontalclassmerging.HorizontalClassMerger;
import com.android.tools.r8.horizontalclassmerging.MergeGroup;
import com.android.tools.r8.horizontalclassmerging.MultiClassPolicyWithPreprocessing;
import com.android.tools.r8.utils.IterableUtils;
import com.android.tools.r8.utils.ListUtils;
import com.android.tools.r8.utils.MapUtils;
import com.android.tools.r8.utils.SetUtils;
import com.android.tools.r8.utils.collections.DexMethodSignatureSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;

public class NoDefaultInterfaceMethodCollisions
extends MultiClassPolicyWithPreprocessing<Map<DexType, InterfaceInfo>> {
    private final AppView<? extends AppInfoWithClassHierarchy> appView;
    private final HorizontalClassMerger.Mode mode;

    public NoDefaultInterfaceMethodCollisions(AppView<? extends AppInfoWithClassHierarchy> appView, HorizontalClassMerger.Mode mode) {
        this.appView = appView;
        this.mode = mode;
    }

    private Set<DexMethod> computeNewDefaultMethodsAddedToClassByMerge(DexProgramClass clazz, MergeGroup group, Map<DexType, InterfaceInfo> infos) {
        Set<DexMethod> newDefaultMethodsAddedToClassByMerge = Sets.newIdentityHashSet();
        for (DexProgramClass other : group) {
            if (other == clazz) continue;
            Collection<Set<DexMethod>> inheritedDefaultMethodsFromOther = infos.get(other.getType()).getInheritedDefaultMethods().values();
            inheritedDefaultMethodsFromOther.forEach(newDefaultMethodsAddedToClassByMerge::addAll);
        }
        return newDefaultMethodsAddedToClassByMerge;
    }

    private boolean isSafeToAddDefaultMethodsToClass(DexProgramClass clazz, Set<DexMethod> newDefaultMethodsAddedToClassByMerge, Map<DexType, InterfaceInfo> infos) {
        Map<DexMethodSignature, Set<DexMethod>> defaultMethodsInheritedBySubclassesOfClass = infos.get(clazz.getType()).getDefaultMethodsInheritedBySubclasses();
        for (DexMethod newDefaultMethodAddedToClassByMerge : newDefaultMethodsAddedToClassByMerge) {
            Set defaultMethodsInheritedBySubclassesOfClassWithSameSignature = defaultMethodsInheritedBySubclassesOfClass.getOrDefault(newDefaultMethodAddedToClassByMerge.getSignature(), Collections.emptySet());
            for (DexMethod method : defaultMethodsInheritedBySubclassesOfClassWithSameSignature) {
                if (method == newDefaultMethodAddedToClassByMerge) continue;
                return false;
            }
        }
        return true;
    }

    private Collection<DexProgramClass> computeClassesOfInterest(SubtypingInfo subtypingInfo) {
        return this.appView.appInfo().classes();
    }

    private Map<DexType, DexMethodSignatureSet> computeInheritedClassMethodsPerProgramClass(Collection<DexProgramClass> classesOfInterest) {
        IdentityHashMap<DexType, DexMethodSignatureSet> inheritedClassMethodsPerClass = new IdentityHashMap<DexType, DexMethodSignatureSet>();
        ((TopDownClassHierarchyTraversal)TopDownClassHierarchyTraversal.forAllClasses(this.appView).excludeInterfaces()).visit(classesOfInterest, clazz -> {
            DexMethodSignatureSet classMethods = DexMethodSignatureSet.create(inheritedClassMethodsPerClass.getOrDefault(clazz.getSuperType(), DexMethodSignatureSet.empty()));
            for (DexEncodedMethod method : clazz.virtualMethods()) {
                classMethods.add(method.getSignature());
            }
            inheritedClassMethodsPerClass.put(clazz.getType(), classMethods);
        });
        inheritedClassMethodsPerClass.keySet().removeIf(type -> DexProgramClass.asProgramClassOrNull(this.appView.definitionFor((DexType)type)) == null);
        return inheritedClassMethodsPerClass;
    }

    private Map<DexType, Map<DexMethodSignature, Set<DexMethod>>> computeInheritedDefaultMethodsPerProgramType(Collection<DexProgramClass> classesOfInterest, Map<DexType, DexMethodSignatureSet> inheritedClassMethodsPerClass) {
        IdentityHashMap<DexType, Map<DexMethodSignature, Set<DexMethod>>> inheritedDefaultMethodsPerType = new IdentityHashMap<DexType, Map<DexMethodSignature, Set<DexMethod>>>();
        TopDownClassHierarchyTraversal.forAllClasses(this.appView).visit(classesOfInterest, clazz -> {
            HashMap<DexMethodSignature, Set> inheritedDefaultMethods = new HashMap<DexMethodSignature, Set>();
            for (DexType supertype : clazz.allImmediateSupertypes()) {
                Map<DexMethodSignature, Set> inheritedDefaultMethodsFromSuperType = inheritedDefaultMethodsPerType.getOrDefault(supertype, Collections.emptyMap());
                inheritedDefaultMethodsFromSuperType.forEach((signature, methods) -> inheritedDefaultMethods.computeIfAbsent((DexMethodSignature)signature, ignore -> Sets.newIdentityHashSet()).addAll(methods));
            }
            if (clazz.isInterface()) {
                for (DexEncodedMethod method : clazz.virtualMethods(DexEncodedMethod::isDefaultMethod)) {
                    inheritedDefaultMethods.computeIfAbsent(method.getSignature(), ignore -> Sets.newIdentityHashSet()).add((DexMethod)method.getReference());
                }
            }
            inheritedDefaultMethods.keySet().removeAll(inheritedClassMethodsPerClass.getOrDefault(clazz.getType(), DexMethodSignatureSet.empty()));
            if (!inheritedDefaultMethods.isEmpty()) {
                inheritedDefaultMethodsPerType.put(clazz.getType(), inheritedDefaultMethods);
            }
        });
        inheritedDefaultMethodsPerType.keySet().removeIf(type -> DexProgramClass.asProgramClassOrNull(this.appView.definitionFor((DexType)type)) == null);
        return inheritedDefaultMethodsPerType;
    }

    private Map<DexType, Map<DexMethodSignature, Set<DexMethod>>> computeDefaultMethodsInheritedBySubclassesPerProgramClass(Collection<DexProgramClass> classesOfInterest, Map<DexType, Map<DexMethodSignature, Set<DexMethod>>> inheritedDefaultMethodsPerClass, Collection<MergeGroup> groups2, SubtypingInfo subtypingInfo) {
        IdentityHashMap classGroupsByType = MapUtils.newIdentityHashMap(builder -> Iterables.filter(groups2, MergeGroup::isClassGroup).forEach(group -> group.forEach(clazz -> builder.accept(clazz.getType(), group))));
        Map<DexType, Map<DexMethodSignature, Set<DexMethod>>> defaultMethodsInheritedBySubclassesPerClass = MapUtils.clone(inheritedDefaultMethodsPerClass, new HashMap(), outerValue -> MapUtils.clone(outerValue, new HashMap(), SetUtils::newIdentityHashSet));
        Function<DexType, Iterable<DexType>> immediateSubtypesProvider = type -> {
            Set<DexType> immediateSubtypesAfterClassMerging = Sets.newIdentityHashSet();
            for (DexType immediateSubtype : subtypingInfo.allImmediateSubtypes((DexType)type)) {
                Iterable group = (Iterable)classGroupsByType.get(immediateSubtype);
                if (group != null) {
                    group.forEach(member -> immediateSubtypesAfterClassMerging.add(member.getType()));
                    continue;
                }
                immediateSubtypesAfterClassMerging.add(immediateSubtype);
            }
            return immediateSubtypesAfterClassMerging;
        };
        BottomUpClassHierarchyTraversal.forProgramClasses(this.appView, immediateSubtypesProvider).visit(classesOfInterest, clazz -> {
            Map<DexMethodSignature, Set> defaultMethodsToPropagate = defaultMethodsInheritedBySubclassesPerClass.getOrDefault(clazz.getType(), Collections.emptyMap());
            Iterable<DexProgramClass> group = classGroupsByType.getOrDefault(clazz.getType(), IterableUtils.singleton(clazz));
            for (DexProgramClass member : group) {
                for (DexType supertype : member.allImmediateSupertypes()) {
                    Map defaultMethodsInheritedBySubclassesForSupertype = defaultMethodsInheritedBySubclassesPerClass.computeIfAbsent(supertype, ignore -> new HashMap());
                    defaultMethodsToPropagate.forEach((signature, methods) -> defaultMethodsInheritedBySubclassesForSupertype.computeIfAbsent(signature, ignore -> Sets.newIdentityHashSet()).addAll(methods));
                }
            }
        });
        defaultMethodsInheritedBySubclassesPerClass.keySet().removeIf(type -> DexProgramClass.asProgramClassOrNull(this.appView.definitionFor((DexType)type)) == null);
        return defaultMethodsInheritedBySubclassesPerClass;
    }

    @Override
    public Collection<MergeGroup> apply(MergeGroup group, Map<DexType, InterfaceInfo> infos) {
        if (!group.isInterfaceGroup()) {
            return ImmutableList.of(group);
        }
        MergeGroup newGroup = new MergeGroup();
        for (DexProgramClass clazz : group) {
            Set<DexMethod> newDefaultMethodsAddedToClassByMerge;
            if (!this.isSafeToAddDefaultMethodsToClass(clazz, newDefaultMethodsAddedToClassByMerge = this.computeNewDefaultMethodsAddedToClassByMerge(clazz, group, infos), infos)) continue;
            newGroup.add(clazz);
        }
        return newGroup.isTrivial() ? Collections.emptyList() : ListUtils.newLinkedList(newGroup);
    }

    @Override
    public Map<DexType, InterfaceInfo> preprocess(Collection<MergeGroup> groups2, ExecutorService executorService) {
        SubtypingInfo subtypingInfo = SubtypingInfo.create(this.appView);
        Collection<DexProgramClass> classesOfInterest = this.computeClassesOfInterest(subtypingInfo);
        Map<DexType, DexMethodSignatureSet> inheritedClassMethodsPerClass = this.computeInheritedClassMethodsPerProgramClass(classesOfInterest);
        Map<DexType, Map<DexMethodSignature, Set<DexMethod>>> inheritedDefaultMethodsPerClass = this.computeInheritedDefaultMethodsPerProgramType(classesOfInterest, inheritedClassMethodsPerClass);
        Map<DexType, Map<DexMethodSignature, Set<DexMethod>>> defaultMethodsInheritedBySubclassesPerClass = this.computeDefaultMethodsInheritedBySubclassesPerProgramClass(classesOfInterest, inheritedDefaultMethodsPerClass, groups2, subtypingInfo);
        IdentityHashMap<DexType, InterfaceInfo> infos = new IdentityHashMap<DexType, InterfaceInfo>();
        for (MergeGroup group : groups2) {
            if (!group.isInterfaceGroup()) continue;
            for (DexProgramClass clazz : group) {
                infos.put(clazz.getType(), new InterfaceInfo(inheritedDefaultMethodsPerClass.getOrDefault(clazz.getType(), Collections.emptyMap()), defaultMethodsInheritedBySubclassesPerClass.getOrDefault(clazz.getType(), Collections.emptyMap())));
            }
        }
        return infos;
    }

    @Override
    public String getName() {
        return "NoDefaultInterfaceMethodCollisions";
    }

    @Override
    public boolean shouldSkipPolicy() {
        return !this.appView.options().horizontalClassMergerOptions().isInterfaceMergingEnabled(this.mode);
    }

    static class InterfaceInfo {
        private final Map<DexMethodSignature, Set<DexMethod>> inheritedDefaultMethods;
        private final Map<DexMethodSignature, Set<DexMethod>> defaultMethodsInheritedBySubclasses;

        InterfaceInfo(Map<DexMethodSignature, Set<DexMethod>> inheritedDefaultMethods, Map<DexMethodSignature, Set<DexMethod>> defaultMethodsInheritedBySubclasses) {
            this.inheritedDefaultMethods = inheritedDefaultMethods;
            this.defaultMethodsInheritedBySubclasses = defaultMethodsInheritedBySubclasses;
        }

        Map<DexMethodSignature, Set<DexMethod>> getInheritedDefaultMethods() {
            return this.inheritedDefaultMethods;
        }

        Map<DexMethodSignature, Set<DexMethod>> getDefaultMethodsInheritedBySubclasses() {
            return this.defaultMethodsInheritedBySubclasses;
        }
    }
}

