/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.horizontalclassmerging.policies;

import com.android.tools.r8.com.google.common.collect.Lists;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.horizontalclassmerging.HorizontalClassMerger;
import com.android.tools.r8.horizontalclassmerging.MergeGroup;
import com.android.tools.r8.horizontalclassmerging.MultiClassPolicy;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.ListUtils;
import com.android.tools.r8.utils.collections.DexMethodSignatureSet;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class NoDefaultInterfaceMethodMerging
extends MultiClassPolicy {
    private final HorizontalClassMerger.Mode mode;
    private final InternalOptions options;

    public NoDefaultInterfaceMethodMerging(AppView<?> appView, HorizontalClassMerger.Mode mode) {
        this.mode = mode;
        this.options = appView.options();
    }

    private void addClassToGroup(DexProgramClass clazz, Map<MergeGroup, DexMethodSignatureSet> newGroups) {
        DexMethodSignatureSet classSignatures = DexMethodSignatureSet.create();
        classSignatures.addAllMethods(clazz.virtualMethods(DexEncodedMethod::isDefaultMethod));
        for (Map.Entry<MergeGroup, DexMethodSignatureSet> entry : newGroups.entrySet()) {
            MergeGroup group = entry.getKey();
            DexMethodSignatureSet groupSignatures = entry.getValue();
            if (groupSignatures.containsAnyOf(classSignatures)) continue;
            groupSignatures.addAll(classSignatures);
            group.add(clazz);
            return;
        }
        newGroups.put(new MergeGroup(clazz), classSignatures);
    }

    @Override
    public Collection<MergeGroup> apply(MergeGroup group) {
        if (!group.isInterfaceGroup()) {
            return ListUtils.newLinkedList(group);
        }
        LinkedHashMap<MergeGroup, DexMethodSignatureSet> newGroups = new LinkedHashMap<MergeGroup, DexMethodSignatureSet>();
        for (DexProgramClass clazz : group) {
            this.addClassToGroup(clazz, newGroups);
        }
        return this.removeTrivialGroups(Lists.newLinkedList(newGroups.keySet()));
    }

    @Override
    public String getName() {
        return "NoDefaultInterfaceMethodMerging";
    }

    @Override
    public boolean shouldSkipPolicy() {
        return !this.options.horizontalClassMergerOptions().isInterfaceMergingEnabled(this.mode);
    }
}

