/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.horizontalclassmerging.policies;

import com.android.tools.r8.androidapi.AndroidApiLevelCompute;
import com.android.tools.r8.androidapi.ComputedApiLevel;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.horizontalclassmerging.MultiClassSameReferencePolicy;
import com.android.tools.r8.utils.AndroidApiLevelUtils;

public class NoDifferentApiReferenceLevel
extends MultiClassSameReferencePolicy<ComputedApiLevel> {
    private final AndroidApiLevelCompute apiLevelCompute;
    private final AppView<?> appView;
    private final boolean enableApiCallerIdentification;

    public NoDifferentApiReferenceLevel(AppView<?> appView) {
        this.appView = appView;
        this.apiLevelCompute = appView.apiLevelCompute();
        this.enableApiCallerIdentification = appView.options().apiModelingOptions().enableApiCallerIdentification;
    }

    @Override
    public boolean shouldSkipPolicy() {
        return !this.enableApiCallerIdentification;
    }

    @Override
    public String getName() {
        return "NoDifferentApiReferenceLevel";
    }

    @Override
    public ComputedApiLevel getMergeKey(DexProgramClass clazz) {
        assert (this.enableApiCallerIdentification);
        return AndroidApiLevelUtils.getApiReferenceLevelForMerging(this.appView, this.apiLevelCompute, clazz);
    }
}

