/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.horizontalclassmerging.policies;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.horizontalclassmerging.HorizontalClassMerger;
import com.android.tools.r8.horizontalclassmerging.SingleClassPolicy;
import com.android.tools.r8.shaking.RuntimeTypeCheckInfo;
import com.android.tools.r8.synthesis.SyntheticItems;
import com.android.tools.r8.utils.InternalOptions;

public class NoDirectRuntimeTypeChecks
extends SingleClassPolicy {
    private final InternalOptions options;
    private final RuntimeTypeCheckInfo runtimeTypeCheckInfo;
    private final SyntheticItems syntheticItems;

    public NoDirectRuntimeTypeChecks(AppView<?> appView, HorizontalClassMerger.Mode mode) {
        this(appView, mode, null);
    }

    public NoDirectRuntimeTypeChecks(AppView<?> appView, HorizontalClassMerger.Mode mode, RuntimeTypeCheckInfo runtimeTypeCheckInfo) {
        assert (runtimeTypeCheckInfo != null || mode.isFinal());
        this.options = appView.options();
        this.runtimeTypeCheckInfo = runtimeTypeCheckInfo;
        this.syntheticItems = appView.getSyntheticItems();
    }

    @Override
    public boolean canMerge(DexProgramClass clazz) {
        if (this.runtimeTypeCheckInfo == null) {
            assert (this.syntheticItems.isSyntheticClass(clazz)) : "Expected synthetic, got: " + clazz.getTypeName();
            return true;
        }
        return !this.runtimeTypeCheckInfo.isRuntimeCheckType(clazz);
    }

    @Override
    public String getName() {
        return "NoDirectRuntimeTypeChecks";
    }

    @Override
    public boolean shouldSkipPolicy() {
        return this.options.horizontalClassMergerOptions().isIgnoreRuntimeTypeChecksForTestingEnabled();
    }
}

