/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.horizontalclassmerging.policies;

import com.android.tools.r8.com.google.common.collect.Iterators;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodSignature;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.ProgramField;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.horizontalclassmerging.ClassInstanceFieldsMerger;
import com.android.tools.r8.horizontalclassmerging.HorizontalClassMerger;
import com.android.tools.r8.horizontalclassmerging.IRCodeProvider;
import com.android.tools.r8.horizontalclassmerging.InstanceInitializerAnalysis;
import com.android.tools.r8.horizontalclassmerging.InstanceInitializerDescription;
import com.android.tools.r8.horizontalclassmerging.MergeGroup;
import com.android.tools.r8.horizontalclassmerging.MultiClassPolicy;
import com.android.tools.r8.utils.ListUtils;
import com.android.tools.r8.utils.SetUtils;
import com.android.tools.r8.utils.collections.BidirectionalManyToOneHashMap;
import com.android.tools.r8.utils.collections.ProgramMethodMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;

public class NoInstanceInitializerMerging
extends MultiClassPolicy {
    private final AppView<? extends AppInfoWithClassHierarchy> appView;
    private final IRCodeProvider codeProvider;

    public NoInstanceInitializerMerging(AppView<? extends AppInfoWithClassHierarchy> appView, IRCodeProvider codeProvider, HorizontalClassMerger.Mode mode) {
        assert (mode.isFinal());
        this.appView = appView;
        this.codeProvider = codeProvider;
    }

    private boolean canAddClassToGroup(Map<DexMethodSignature, ProgramMethod> classInstanceInitializers, Map<DexMethodSignature, ProgramMethod> groupInstanceInitializers, Function<ProgramMethod, Optional<InstanceInitializerDescription>> instanceInitializerDescriptionProvider) {
        for (Map.Entry<DexMethodSignature, ProgramMethod> entry : classInstanceInitializers.entrySet()) {
            DexMethodSignature relaxedSignature = entry.getKey();
            ProgramMethod classInstanceInitializer = entry.getValue();
            ProgramMethod groupInstanceInitializer = groupInstanceInitializers.get(relaxedSignature);
            if (groupInstanceInitializer == null) continue;
            Optional<InstanceInitializerDescription> classInstanceInitializerDescription = instanceInitializerDescriptionProvider.apply(classInstanceInitializer);
            if (!classInstanceInitializerDescription.isPresent()) {
                return false;
            }
            Optional<InstanceInitializerDescription> groupInstanceInitializerDescription = instanceInitializerDescriptionProvider.apply(groupInstanceInitializer);
            if (groupInstanceInitializerDescription.isPresent() && classInstanceInitializerDescription.equals(groupInstanceInitializerDescription)) continue;
            return false;
        }
        return true;
    }

    private boolean hasMultipleInstanceInitializersWithSameRelaxedSignature(DexProgramClass clazz) {
        Iterator<ProgramMethod> instanceInitializers = clazz.programInstanceInitializers().iterator();
        if (!instanceInitializers.hasNext()) {
            return false;
        }
        ProgramMethod first = instanceInitializers.next();
        if (!instanceInitializers.hasNext()) {
            return false;
        }
        Set<DexMethod> seen = SetUtils.newIdentityHashSet(this.getRelaxedSignature(first));
        return Iterators.any(instanceInitializers, instanceInitializer -> !seen.add(this.getRelaxedSignature((ProgramMethod)instanceInitializer)));
    }

    private Map<DexMethodSignature, ProgramMethod> getInstanceInitializersByRelaxedSignature(DexProgramClass clazz) {
        HashMap<DexMethodSignature, ProgramMethod> result = new HashMap<DexMethodSignature, ProgramMethod>();
        for (ProgramMethod instanceInitializer : clazz.programInstanceInitializers()) {
            DexMethodSignature relaxedSignature = this.getRelaxedSignature(instanceInitializer).getSignature();
            ProgramMethod previous = result.put(relaxedSignature, instanceInitializer);
            assert (previous == null);
        }
        return result;
    }

    private Optional<InstanceInitializerDescription> getOrComputeInstanceInitializerDescription(MergeGroup group, ProgramMethod instanceInitializer, ProgramMethodMap<Optional<InstanceInitializerDescription>> instanceInitializerDescriptions) {
        return instanceInitializerDescriptions.computeIfAbsent(instanceInitializer, key -> {
            InstanceInitializerDescription instanceInitializerDescription = InstanceInitializerAnalysis.analyze(this.appView, this.codeProvider, group, instanceInitializer);
            return Optional.ofNullable(instanceInitializerDescription);
        });
    }

    private DexMethod getRelaxedSignature(ProgramMethod instanceInitializer) {
        DexTypeList relaxedParameters;
        DexType objectType = this.appView.dexItemFactory().objectType;
        DexTypeList parameters = instanceInitializer.getParameters();
        return parameters != (relaxedParameters = parameters.map(parameter -> parameter.isPrimitiveType() ? parameter : objectType)) ? this.appView.dexItemFactory().createInstanceInitializer(instanceInitializer.getHolderType(), relaxedParameters) : (DexMethod)instanceInitializer.getReference();
    }

    private void setInstanceFieldMaps(Iterable<MergeGroup> newGroups, MergeGroup group) {
        for (MergeGroup newGroup : newGroups) {
            newGroup.selectTarget(this.appView);
            IdentityHashMap oldTargetToNewTargetInstanceFieldMap = new IdentityHashMap();
            if (newGroup.getTarget() != group.getTarget()) {
                ClassInstanceFieldsMerger.mapFields(this.appView, group.getTarget(), newGroup.getTarget(), oldTargetToNewTargetInstanceFieldMap::put);
            }
            BidirectionalManyToOneHashMap<DexEncodedField, DexEncodedField> instanceFieldMap = BidirectionalManyToOneHashMap.newLinkedHashMap();
            newGroup.forEachSource(source -> source.forEachProgramInstanceField(sourceField -> {
                DexEncodedField oldTargetInstanceField = (DexEncodedField)group.getTargetInstanceField((ProgramField)sourceField).getDefinition();
                DexEncodedField newTargetInstanceField = oldTargetToNewTargetInstanceFieldMap.getOrDefault(oldTargetInstanceField, oldTargetInstanceField);
                instanceFieldMap.put((DexEncodedField)sourceField.getDefinition(), newTargetInstanceField);
            }));
            newGroup.setInstanceFieldMap(instanceFieldMap);
        }
    }

    @Override
    public Collection<MergeGroup> apply(MergeGroup group) {
        assert (!group.hasTarget());
        assert (!group.hasInstanceFieldMap());
        if (group.isInterfaceGroup()) {
            return ListUtils.newLinkedList(group);
        }
        group.removeIf((Predicate<? super DexProgramClass>)((Predicate<DexProgramClass>)this::hasMultipleInstanceInitializersWithSameRelaxedSignature));
        if (group.isEmpty()) {
            return Collections.emptyList();
        }
        group.selectTarget(this.appView);
        group.selectInstanceFieldMap(this.appView);
        LinkedHashMap<MergeGroup, Map<DexMethodSignature, ProgramMethod>> newGroups = new LinkedHashMap<MergeGroup, Map<DexMethodSignature, ProgramMethod>>();
        ProgramMethodMap instanceInitializerDescriptions = ProgramMethodMap.create();
        Function<ProgramMethod, Optional<InstanceInitializerDescription>> instanceInitializerDescriptionProvider = instanceInitializer -> this.getOrComputeInstanceInitializerDescription(group, (ProgramMethod)instanceInitializer, instanceInitializerDescriptions);
        for (DexProgramClass clazz : group) {
            MergeGroup newGroup = null;
            Map<DexMethodSignature, ProgramMethod> classInstanceInitializers = this.getInstanceInitializersByRelaxedSignature(clazz);
            for (Map.Entry entry : newGroups.entrySet()) {
                MergeGroup candidateGroup = (MergeGroup)entry.getKey();
                Map groupInstanceInitializers = (Map)entry.getValue();
                if (!this.canAddClassToGroup(classInstanceInitializers, groupInstanceInitializers, instanceInitializerDescriptionProvider)) continue;
                newGroup = candidateGroup;
                classInstanceInitializers.forEach(groupInstanceInitializers::put);
                break;
            }
            if (newGroup != null) {
                newGroup.add(clazz);
                continue;
            }
            newGroups.put(new MergeGroup(clazz), classInstanceInitializers);
        }
        Collection<MergeGroup> newNonTrivialGroups = this.removeTrivialGroups(newGroups.keySet());
        this.setInstanceFieldMaps(newNonTrivialGroups, group);
        return newNonTrivialGroups;
    }

    @Override
    public String getName() {
        return "NoInstanceInitializerMerging";
    }

    @Override
    public boolean isIdentityForInterfaceGroups() {
        return true;
    }
}

