/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.horizontalclassmerging.policies;

import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedMember;
import com.android.tools.r8.graph.DexMember;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.horizontalclassmerging.SingleClassPolicy;
import com.android.tools.r8.shaking.KeepInfoCollection;
import com.android.tools.r8.utils.InternalOptions;
import java.util.Set;

public class NoKeepRules
extends SingleClassPolicy {
    private final AppView<? extends AppInfoWithClassHierarchy> appView;
    private final KeepInfoCollection keepInfo;
    private final InternalOptions options;
    private final Set<DexType> dontMergeTypes = Sets.newIdentityHashSet();

    public NoKeepRules(AppView<? extends AppInfoWithClassHierarchy> appView) {
        this.appView = appView;
        this.keepInfo = appView.getKeepInfo();
        this.options = appView.options();
        appView.appInfo().classes().forEach(this::processClass);
    }

    private void processClass(DexProgramClass clazz) {
        DexType type = clazz.getType();
        boolean pinHolder = this.keepInfo.getClassInfo(clazz).isPinned(this.options);
        for (DexEncodedMember<?, ?> member : clazz.members()) {
            if (!this.keepInfo.getMemberInfo(member, clazz).isPinned(this.options)) continue;
            pinHolder = true;
            Iterables.addAll(this.dontMergeTypes, Iterables.filter(((DexMember)member.getReference()).getReferencedBaseTypes(this.appView.dexItemFactory()), DexType::isClassType));
        }
        if (pinHolder) {
            this.dontMergeTypes.add(type);
        }
    }

    @Override
    public boolean canMerge(DexProgramClass program) {
        return !this.dontMergeTypes.contains(program.getType());
    }

    @Override
    public String getName() {
        return "NoKeepRules";
    }
}

