/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.horizontalclassmerging.policies;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.horizontalclassmerging.HorizontalClassMerger;
import com.android.tools.r8.horizontalclassmerging.SingleClassPolicy;
import com.android.tools.r8.shaking.AppInfoWithLiveness;

public class NoVerticallyMergedClasses
extends SingleClassPolicy {
    private final AppView<AppInfoWithLiveness> appView;

    public NoVerticallyMergedClasses(AppView<AppInfoWithLiveness> appView, HorizontalClassMerger.Mode mode) {
        assert (mode.isInitial());
        this.appView = appView;
    }

    @Override
    public boolean canMerge(DexProgramClass program) {
        if (this.appView.verticallyMergedClasses() == null) {
            return true;
        }
        return !this.appView.verticallyMergedClasses().hasBeenMergedIntoSubtype(program.type);
    }

    @Override
    public String getName() {
        return "NotVerticallyMergedIntoSubtype";
    }
}

