/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.horizontalclassmerging.policies;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.ImmediateProgramSubtypingInfo;
import com.android.tools.r8.horizontalclassmerging.MergeGroup;
import com.android.tools.r8.horizontalclassmerging.MultiClassPolicy;
import com.android.tools.r8.optimize.argumentpropagation.utils.ProgramClassesBidirectedGraph;
import com.android.tools.r8.utils.collections.DexMethodSignatureSet;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class NoWeakerAccessPrivileges
extends MultiClassPolicy {
    private final ProgramClassesBidirectedGraph graph;
    private final ImmediateProgramSubtypingInfo immediateSubtypingInfo;
    private final Map<DexClass, DexMethodSignatureSet> inheritedInterfaceMethodsCache = new IdentityHashMap<DexClass, DexMethodSignatureSet>();
    private final Map<Set<DexProgramClass>, DexMethodSignatureSet> nonPublicVirtualMethodSignaturesCache = new IdentityHashMap<Set<DexProgramClass>, DexMethodSignatureSet>();
    private final Map<DexClass, DexMethodSignatureSet> nonPublicVirtualLibraryMethodSignaturesCache = new IdentityHashMap<DexClass, DexMethodSignatureSet>();
    private final Map<DexProgramClass, Set<DexProgramClass>> stronglyConnectedComponentsCache = new IdentityHashMap<DexProgramClass, Set<DexProgramClass>>();

    public NoWeakerAccessPrivileges(AppView<? extends AppInfoWithClassHierarchy> appView, ImmediateProgramSubtypingInfo immediateSubtypingInfo) {
        this.graph = new ProgramClassesBidirectedGraph(appView, immediateSubtypingInfo);
        this.immediateSubtypingInfo = immediateSubtypingInfo;
    }

    private boolean canAddToGroup(DexProgramClass clazz, MergeGroup group, DexMethodSignatureSet inheritedInterfaceMethodsInGroup) {
        DexMethodSignatureSet nonPublicVirtualMethodSignaturesInClassComponent = this.getOrComputeNonPublicVirtualMethodSignaturesInComponentOf(clazz);
        if (nonPublicVirtualMethodSignaturesInClassComponent.containsAnyOf(inheritedInterfaceMethodsInGroup)) {
            return false;
        }
        Set<Set<DexProgramClass>> components = Sets.newIdentityHashSet();
        for (DexProgramClass dexProgramClass : group) {
            components.add(this.getOrComputeStronglyConnectedComponent(dexProgramClass));
        }
        for (Set set : components) {
            if (!this.getOrComputeNonPublicVirtualMethodSignaturesInComponent(set).containsAnyOf(this.getOrComputeInheritedInterfaceMethods(clazz))) continue;
            return false;
        }
        return true;
    }

    private DexMethodSignatureSet getOrComputeInheritedInterfaceMethods(DexClass clazz) {
        if (this.inheritedInterfaceMethodsCache.containsKey(clazz)) {
            return this.inheritedInterfaceMethodsCache.get(clazz);
        }
        DexMethodSignatureSet inheritedInterfaceMethods = DexMethodSignatureSet.create();
        this.immediateSubtypingInfo.forEachImmediateSuperClassMatching(clazz, DexClass::isInterface, superclass -> inheritedInterfaceMethods.addAll(this.getOrComputeInheritedInterfaceMethods((DexClass)superclass)));
        if (clazz.isInterface()) {
            clazz.forEachClassMethodMatching(DexEncodedMethod::belongsToVirtualPool, inheritedInterfaceMethods::add);
        }
        this.inheritedInterfaceMethodsCache.put(clazz, inheritedInterfaceMethods);
        return inheritedInterfaceMethods;
    }

    private Set<DexProgramClass> getOrComputeStronglyConnectedComponent(DexProgramClass clazz) {
        if (this.stronglyConnectedComponentsCache.containsKey(clazz)) {
            return this.stronglyConnectedComponentsCache.get(clazz);
        }
        Set<DexProgramClass> stronglyConnectedComponent = this.graph.computeStronglyConnectedComponent(clazz);
        for (DexProgramClass member : stronglyConnectedComponent) {
            this.stronglyConnectedComponentsCache.put(member, stronglyConnectedComponent);
        }
        return stronglyConnectedComponent;
    }

    private DexMethodSignatureSet getOrComputeNonPublicVirtualMethodSignaturesInComponentOf(DexProgramClass clazz) {
        return this.getOrComputeNonPublicVirtualMethodSignaturesInComponent(this.getOrComputeStronglyConnectedComponent(clazz));
    }

    private DexMethodSignatureSet getOrComputeNonPublicVirtualMethodSignaturesInComponent(Set<DexProgramClass> stronglyConnectedComponent) {
        if (this.nonPublicVirtualMethodSignaturesCache.containsKey(stronglyConnectedComponent)) {
            return this.nonPublicVirtualMethodSignaturesCache.get(stronglyConnectedComponent);
        }
        DexMethodSignatureSet nonPublicVirtualMethodSignatures = DexMethodSignatureSet.create();
        for (DexProgramClass clazz : stronglyConnectedComponent) {
            clazz.forEachProgramVirtualMethodMatching(method -> method.getAccessFlags().isPackagePrivateOrProtected(), nonPublicVirtualMethodSignatures::add);
            this.immediateSubtypingInfo.forEachImmediateSuperClassMatching((DexClass)clazz, superclass -> !superclass.isProgramClass(), superclass -> nonPublicVirtualMethodSignatures.addAll(this.getOrComputeNonPublicVirtualLibraryMethodSignatures((DexClass)superclass)));
        }
        this.nonPublicVirtualMethodSignaturesCache.put(stronglyConnectedComponent, nonPublicVirtualMethodSignatures);
        return nonPublicVirtualMethodSignatures;
    }

    private DexMethodSignatureSet getOrComputeNonPublicVirtualLibraryMethodSignatures(DexClass clazz) {
        if (this.nonPublicVirtualLibraryMethodSignaturesCache.containsKey(clazz)) {
            return this.nonPublicVirtualLibraryMethodSignaturesCache.get(clazz);
        }
        DexMethodSignatureSet nonPublicVirtualLibraryMethodSignatures = DexMethodSignatureSet.create();
        clazz.forEachClassMethodMatching(method -> method.getAccessFlags().isPackagePrivateOrProtected(), nonPublicVirtualLibraryMethodSignatures::add);
        this.immediateSubtypingInfo.forEachImmediateSuperClass(clazz, superclass -> nonPublicVirtualLibraryMethodSignatures.addAll(this.getOrComputeNonPublicVirtualLibraryMethodSignatures((DexClass)superclass)));
        this.nonPublicVirtualLibraryMethodSignaturesCache.put(clazz, nonPublicVirtualLibraryMethodSignatures);
        return nonPublicVirtualLibraryMethodSignatures;
    }

    @Override
    public Collection<MergeGroup> apply(MergeGroup group) {
        LinkedList<MergeGroup> newMergeGroups = new LinkedList<MergeGroup>();
        IdentityHashMap<MergeGroup, DexMethodSignatureSet> inheritedInterfaceMethodsPerGroup = new IdentityHashMap<MergeGroup, DexMethodSignatureSet>();
        for (DexProgramClass clazz : group) {
            DexMethodSignatureSet inheritedInterfaceMethodsInGroup;
            MergeGroup newMergeGroup = null;
            for (MergeGroup candidateMergeGroup : newMergeGroups) {
                DexMethodSignatureSet inheritedInterfaceMethodsInGroup2;
                if (!this.canAddToGroup(clazz, candidateMergeGroup, inheritedInterfaceMethodsInGroup2 = (DexMethodSignatureSet)inheritedInterfaceMethodsPerGroup.get(candidateMergeGroup))) continue;
                newMergeGroup = candidateMergeGroup;
                break;
            }
            if (newMergeGroup == null) {
                newMergeGroup = new MergeGroup(clazz);
                newMergeGroups.add(newMergeGroup);
                inheritedInterfaceMethodsInGroup = DexMethodSignatureSet.create();
                inheritedInterfaceMethodsPerGroup.put(newMergeGroup, inheritedInterfaceMethodsInGroup);
            } else {
                newMergeGroup.add(clazz);
                inheritedInterfaceMethodsInGroup = (DexMethodSignatureSet)inheritedInterfaceMethodsPerGroup.get(newMergeGroup);
            }
            inheritedInterfaceMethodsInGroup.addAll(this.getOrComputeInheritedInterfaceMethods(clazz));
        }
        return this.removeTrivialGroups(newMergeGroups);
    }

    @Override
    public void clear() {
        this.inheritedInterfaceMethodsCache.clear();
        this.nonPublicVirtualMethodSignaturesCache.clear();
        this.stronglyConnectedComponentsCache.clear();
    }

    @Override
    public String getName() {
        return "NoWeakerAccessPriviledges";
    }
}

