/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.horizontalclassmerging.policies;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.SubtypingInfo;
import com.android.tools.r8.horizontalclassmerging.HorizontalClassMerger;
import com.android.tools.r8.horizontalclassmerging.MergeGroup;
import com.android.tools.r8.horizontalclassmerging.MultiClassPolicyWithPreprocessing;
import com.android.tools.r8.utils.SetUtils;
import com.android.tools.r8.utils.WorkList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;

public class OnlyDirectlyConnectedOrUnrelatedInterfaces
extends MultiClassPolicyWithPreprocessing<SubtypingInfo> {
    private final AppView<? extends AppInfoWithClassHierarchy> appView;
    private final HorizontalClassMerger.Mode mode;
    private final Map<DexProgramClass, MergeGroup> committed = new IdentityHashMap<DexProgramClass, MergeGroup>();

    public OnlyDirectlyConnectedOrUnrelatedInterfaces(AppView<? extends AppInfoWithClassHierarchy> appView, HorizontalClassMerger.Mode mode) {
        this.appView = appView;
        this.mode = mode;
    }

    private Set<DexProgramClass> computeSuperInterfaces(DexProgramClass clazz) {
        return this.computeTransitiveSubOrSuperInterfaces(clazz, DexClass::getInterfaces);
    }

    private Set<DexProgramClass> computeSubInterfaces(DexProgramClass clazz, SubtypingInfo subtypingInfo) {
        return this.computeTransitiveSubOrSuperInterfaces(clazz, definition -> subtypingInfo.allImmediateExtendsSubtypes(definition.getType()));
    }

    private Set<DexProgramClass> computeTransitiveSubOrSuperInterfaces(DexProgramClass clazz, Function<DexProgramClass, Iterable<DexType>> immediateSubOrSuperInterfacesProvider) {
        WorkList workList = WorkList.newWorkList(new LinkedHashSet());
        workList.addIgnoringSeenSet(clazz);
        while (workList.hasNext()) {
            DexProgramClass interfaceDefinition = (DexProgramClass)workList.next();
            MergeGroup group = this.committed.get(interfaceDefinition);
            if (group != null) {
                workList.addIfNotSeen(group);
            }
            for (DexType immediateSubOrSuperInterfaceType : immediateSubOrSuperInterfacesProvider.apply(interfaceDefinition)) {
                DexProgramClass immediateSubOrSuperInterface = DexProgramClass.asProgramClassOrNull(this.appView.definitionFor(immediateSubOrSuperInterfaceType));
                if (immediateSubOrSuperInterface == null) continue;
                workList.addIfNotSeen(immediateSubOrSuperInterface);
            }
        }
        assert (!workList.isSeen(clazz));
        return workList.getMutableSeenSet();
    }

    @Override
    public Collection<MergeGroup> apply(MergeGroup group, SubtypingInfo subtypingInfo) {
        if (!group.isInterfaceGroup()) {
            return ImmutableList.of(group);
        }
        ArrayList<MergeGroupWithInfo> newGroupsWithInfo = new ArrayList<MergeGroupWithInfo>();
        for (DexProgramClass clazz : group) {
            Set<DexProgramClass> superInterfaces = this.computeSuperInterfaces(clazz);
            Set<DexProgramClass> subInterfaces = this.computeSubInterfaces(clazz, subtypingInfo);
            MergeGroupWithInfo newGroup = null;
            for (MergeGroupWithInfo candidateGroup : newGroupsWithInfo) {
                if (!candidateGroup.isSafeToAddSubAndSuperInterfaces(clazz, subInterfaces, superInterfaces)) continue;
                newGroup = candidateGroup;
                break;
            }
            if (newGroup != null) {
                newGroup.add(clazz, superInterfaces, subInterfaces);
            } else {
                newGroup = new MergeGroupWithInfo(clazz, superInterfaces, subInterfaces);
                newGroupsWithInfo.add(newGroup);
            }
            this.committed.put(clazz, newGroup.getGroup());
        }
        LinkedList<MergeGroup> newGroups = new LinkedList<MergeGroup>();
        for (MergeGroupWithInfo newGroupWithInfo : newGroupsWithInfo) {
            MergeGroup newGroup = newGroupWithInfo.getGroup();
            if (newGroup.isTrivial()) {
                assert (!newGroup.isEmpty());
                this.committed.remove(newGroup.getClasses().getFirst());
                continue;
            }
            newGroups.add(newGroup);
        }
        return newGroups;
    }

    @Override
    public void clear() {
        this.committed.clear();
    }

    @Override
    public String getName() {
        return "OnlyDirectlyConnectedOrUnrelatedInterfaces";
    }

    @Override
    public SubtypingInfo preprocess(Collection<MergeGroup> groups2, ExecutorService executorService) {
        return SubtypingInfo.create(this.appView);
    }

    @Override
    public boolean shouldSkipPolicy() {
        return !this.appView.options().horizontalClassMergerOptions().isInterfaceMergingEnabled(this.mode);
    }

    static class MergeGroupWithInfo {
        private final MergeGroup group;
        private final Set<DexProgramClass> members;
        private final Set<DexProgramClass> superInterfaces;
        private final Set<DexProgramClass> subInterfaces;

        MergeGroupWithInfo(DexProgramClass clazz, Set<DexProgramClass> superInterfaces, Set<DexProgramClass> subInterfaces) {
            this.group = new MergeGroup(clazz);
            this.members = SetUtils.newIdentityHashSet(clazz);
            this.superInterfaces = superInterfaces;
            this.subInterfaces = subInterfaces;
        }

        void add(DexProgramClass clazz, Set<DexProgramClass> newSuperInterfaces, Set<DexProgramClass> newSubInterfaces) {
            this.group.add(clazz);
            this.members.add(clazz);
            Iterables.addAll(this.superInterfaces, Iterables.filter(newSuperInterfaces, superInterface -> !this.members.contains(superInterface)));
            this.superInterfaces.remove(clazz);
            Iterables.addAll(this.subInterfaces, Iterables.filter(newSubInterfaces, subInterface -> !this.members.contains(subInterface)));
            this.subInterfaces.remove(clazz);
        }

        MergeGroup getGroup() {
            return this.group;
        }

        boolean isSafeToAddSubAndSuperInterfaces(DexProgramClass clazz, Set<DexProgramClass> newSubInterfaces, Set<DexProgramClass> newSuperInterfaces) {
            for (DexProgramClass newSubInterface : newSubInterfaces) {
                if (this.group.contains(newSubInterface) || !this.superInterfaces.contains(newSubInterface)) continue;
                return false;
            }
            for (DexProgramClass newSuperInterface : newSuperInterfaces) {
                if (this.group.contains(newSuperInterface) || !this.subInterfaces.contains(newSuperInterface)) continue;
                return false;
            }
            for (DexProgramClass subInterface : this.subInterfaces) {
                if (subInterface == clazz || !newSuperInterfaces.contains(subInterface)) continue;
                return false;
            }
            for (DexProgramClass superInterface : this.superInterfaces) {
                if (superInterface == clazz || !newSubInterfaces.contains(superInterface)) continue;
                return false;
            }
            return true;
        }
    }
}

