/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.horizontalclassmerging.policies;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodSignature;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ImmediateProgramSubtypingInfo;
import com.android.tools.r8.graph.MethodResolutionResult;
import com.android.tools.r8.horizontalclassmerging.MergeGroup;
import com.android.tools.r8.horizontalclassmerging.MultiClassPolicy;
import com.android.tools.r8.utils.collections.DexMethodSignatureSet;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class PreventClassMethodAndDefaultMethodCollisions
extends MultiClassPolicy {
    private final AppView<? extends AppInfoWithClassHierarchy> appView;
    private final ImmediateProgramSubtypingInfo immediateSubtypingInfo;
    private final InterfaceDefaultSignaturesCache interfaceDefaultMethodsCache = new InterfaceDefaultSignaturesCache();
    private final ParentClassSignaturesCache parentClassMethodsCache = new ParentClassSignaturesCache();
    private final ReservedInterfaceSignaturesFor reservedInterfaceSignaturesFor = new ReservedInterfaceSignaturesFor();

    public PreventClassMethodAndDefaultMethodCollisions(AppView<? extends AppInfoWithClassHierarchy> appView, ImmediateProgramSubtypingInfo immediateSubtypingInfo) {
        this.appView = appView;
        this.immediateSubtypingInfo = immediateSubtypingInfo;
    }

    @Override
    public String getName() {
        return "PreventClassMethodAndDefaultMethodCollisions";
    }

    DexMethodSignatureSet computeReservedSignaturesForClass(DexProgramClass clazz) {
        DexMethodSignatureSet reservedSignatures = DexMethodSignatureSet.create(this.reservedInterfaceSignaturesFor.getOrComputeSignatures(clazz));
        reservedSignatures.removeAll(this.parentClassMethodsCache.getOrComputeSignatures(clazz));
        return reservedSignatures;
    }

    @Override
    public Collection<MergeGroup> apply(MergeGroup group) {
        if (group.isInterfaceGroup()) {
            return ImmutableList.of(group);
        }
        DexMethodSignatureSet signatures = DexMethodSignatureSet.createLinked();
        for (DexProgramClass clazz : group) {
            signatures.addAllMethods(clazz.methods());
        }
        LinkedHashMap<DispatchSignature, MergeGroup> newGroups = new LinkedHashMap<DispatchSignature, MergeGroup>();
        for (DexProgramClass clazz : group) {
            DexMethodSignatureSet clazzReserved = this.computeReservedSignaturesForClass(clazz);
            DispatchSignature dispatchSignature = new DispatchSignature();
            for (DexMethodSignature signature : signatures) {
                MethodCategory category = MethodCategory.CLASS_HIERARCHY_SAFE;
                if (clazzReserved.contains(signature)) {
                    DexMethod template = signature.withHolder(clazz, this.appView.dexItemFactory());
                    MethodResolutionResult.SingleResolutionResult result = this.appView.appInfo().resolveMethodOnClass(template, (DexClass)clazz).asSingleResolution();
                    if (result == null || result.getResolvedHolder().isInterface()) {
                        category = MethodCategory.KEEP_ABSENT;
                    }
                }
                dispatchSignature.addSignature(signature, category);
            }
            newGroups.computeIfAbsent(dispatchSignature, ignore -> new MergeGroup()).add(clazz);
        }
        return this.removeTrivialGroups(newGroups.values());
    }

    static class DispatchSignature
    extends LinkedHashMap<DexMethodSignature, MethodCategory> {
        DispatchSignature() {
        }

        void addSignature(DexMethodSignature signature, MethodCategory category) {
            MethodCategory old = this.put(signature, category);
            assert (old == null);
        }
    }

    static enum MethodCategory {
        CLASS_HIERARCHY_SAFE,
        KEEP_ABSENT;

    }

    private class ReservedInterfaceSignaturesFor
    extends SignaturesCache<DexProgramClass> {
        private ReservedInterfaceSignaturesFor() {
        }

        @Override
        void process(DexProgramClass clazz, DexMethodSignatureSet signatures) {
            signatures.addAll(clazz.getInterfaces(), PreventClassMethodAndDefaultMethodCollisions.this.interfaceDefaultMethodsCache::getOrComputeSignatures);
            signatures.addAll(PreventClassMethodAndDefaultMethodCollisions.this.immediateSubtypingInfo.getSubclasses(clazz), this::getOrComputeSignatures);
            signatures.removeAllMethods(clazz.methods());
        }
    }

    private class ParentClassSignaturesCache
    extends DexClassSignaturesCache {
        private ParentClassSignaturesCache() {
        }

        @Override
        void process(DexClass clazz, DexMethodSignatureSet signatures) {
            DexClass superClass;
            signatures.addAllMethods(clazz.methods());
            if (clazz.getSuperType() != null && (superClass = PreventClassMethodAndDefaultMethodCollisions.this.appView.definitionFor(clazz.getSuperType())) != null) {
                signatures.addAll(this.getOrComputeSignatures(superClass));
            }
        }
    }

    private class InterfaceDefaultSignaturesCache
    extends DexClassSignaturesCache {
        private InterfaceDefaultSignaturesCache() {
        }

        @Override
        void process(DexClass clazz, DexMethodSignatureSet signatures) {
            signatures.addAllMethods(clazz.virtualMethods(DexEncodedMethod::isDefaultMethod));
            signatures.addAll(clazz.getInterfaces(), this::getOrComputeSignatures);
        }
    }

    private abstract class DexClassSignaturesCache
    extends SignaturesCache<DexClass> {
        private DexClassSignaturesCache() {
        }

        @Override
        DexMethodSignatureSet getOrComputeSignatures(DexType type) {
            DexClass clazz = PreventClassMethodAndDefaultMethodCollisions.this.appView.definitionFor(type);
            return clazz != null ? this.getOrComputeSignatures(clazz) : DexMethodSignatureSet.create();
        }
    }

    private static abstract class SignaturesCache<C extends DexClass> {
        private final Map<DexClass, DexMethodSignatureSet> memoizedSignatures = new IdentityHashMap<DexClass, DexMethodSignatureSet>();

        private SignaturesCache() {
        }

        public DexMethodSignatureSet getOrComputeSignatures(C clazz) {
            return this.memoizedSignatures.computeIfAbsent((DexClass)clazz, ignore -> {
                DexMethodSignatureSet signatures = DexMethodSignatureSet.createLinked();
                this.process(clazz, signatures);
                return signatures;
            });
        }

        abstract void process(C var1, DexMethodSignatureSet var2);
    }
}

