/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.horizontalclassmerging.policies;

import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexDefinition;
import com.android.tools.r8.graph.DexEncodedMember;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.horizontalclassmerging.MergeGroup;
import com.android.tools.r8.horizontalclassmerging.MultiClassPolicy;
import com.android.tools.r8.shaking.VerticalClassMerger;
import com.android.tools.r8.utils.TraversalContinuation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;

public class RespectPackageBoundaries
extends MultiClassPolicy {
    private final AppView<? extends AppInfoWithClassHierarchy> appView;

    public RespectPackageBoundaries(AppView<? extends AppInfoWithClassHierarchy> appView) {
        this.appView = appView;
    }

    boolean shouldRestrictMergingAcrossPackageBoundary(DexProgramClass clazz) {
        if (!clazz.isPublic()) {
            return true;
        }
        if (clazz.hasAnnotations() || Iterables.any(clazz.members(), DexDefinition::hasAnyAnnotations)) {
            return true;
        }
        for (DexType dexType : clazz.getInterfaces()) {
            DexClass interfaceClass;
            if (!clazz.getType().isSamePackage(dexType) || (interfaceClass = this.appView.definitionFor(dexType)) != null && interfaceClass.isPublic()) continue;
            return true;
        }
        for (DexEncodedMember dexEncodedMember : clazz.members()) {
            if (!dexEncodedMember.getAccessFlags().isPackagePrivateOrProtected()) continue;
            return true;
        }
        TraversalContinuation<?> result = clazz.traverseProgramMethods(method -> {
            boolean foundIllegalAccess = method.registerCodeReferencesWithResult(new VerticalClassMerger.IllegalAccessDetector(this.appView, (ProgramMethod)method));
            if (foundIllegalAccess) {
                return TraversalContinuation.doBreak();
            }
            return TraversalContinuation.doContinue();
        });
        return result.shouldBreak();
    }

    void tryFindRestrictedPackage(MergeGroup unrestrictedClasses, Map<String, MergeGroup> restrictedClasses) {
        unrestrictedClasses.removeIf((Predicate<? super DexProgramClass>)((Predicate<DexProgramClass>)clazz -> {
            MergeGroup restrictedPackage = (MergeGroup)restrictedClasses.get(clazz.type.getPackageDescriptor());
            if (restrictedPackage != null) {
                restrictedPackage.add((DexProgramClass)clazz);
                return true;
            }
            return false;
        }));
    }

    @Override
    public Collection<MergeGroup> apply(MergeGroup group) {
        LinkedHashMap<String, MergeGroup> restrictedClasses = new LinkedHashMap<String, MergeGroup>();
        MergeGroup unrestrictedClasses = new MergeGroup();
        for (DexProgramClass clazz : group) {
            if (this.shouldRestrictMergingAcrossPackageBoundary(clazz)) {
                restrictedClasses.computeIfAbsent(clazz.getType().getPackageDescriptor(), ignore -> new MergeGroup()).add(clazz);
                continue;
            }
            unrestrictedClasses.add(clazz);
        }
        this.tryFindRestrictedPackage(unrestrictedClasses, restrictedClasses);
        this.removeTrivialGroups(restrictedClasses.values());
        ArrayList<MergeGroup> groups2 = new ArrayList<MergeGroup>(restrictedClasses.size() + 1);
        if (unrestrictedClasses.size() > 1) {
            groups2.add(unrestrictedClasses);
        }
        groups2.addAll(restrictedClasses.values());
        return groups2;
    }

    @Override
    public String getName() {
        return "RespectPackageBoundaries";
    }
}

