/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.horizontalclassmerging.policies;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.horizontalclassmerging.HorizontalClassMerger;
import com.android.tools.r8.horizontalclassmerging.MultiClassSameReferencePolicy;
import com.android.tools.r8.synthesis.SyntheticItems;

public class SyntheticItemsPolicy
extends MultiClassSameReferencePolicy<ClassKind> {
    private final HorizontalClassMerger.Mode mode;
    private final SyntheticItems syntheticItems;

    public SyntheticItemsPolicy(AppView<?> appView, HorizontalClassMerger.Mode mode) {
        this.mode = mode;
        this.syntheticItems = appView.getSyntheticItems();
    }

    @Override
    public ClassKind getMergeKey(DexProgramClass clazz) {
        if (this.syntheticItems.isSyntheticClass(clazz)) {
            return this.syntheticItems.isEligibleForClassMerging(clazz, this.mode) ? ClassKind.SYNTHETIC : (ClassKind)((Object)this.ineligibleForClassMerging());
        }
        return ClassKind.NOT_SYNTHETIC;
    }

    @Override
    public String getName() {
        return "SyntheticItemsPolicy";
    }

    static enum ClassKind {
        SYNTHETIC,
        NOT_SYNTHETIC;

    }
}

