/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.horizontalclassmerging.policies.deadlock;

import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.collections.ProgramMethodMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

public class SingleCallerInformation {
    private final ProgramMethodMap<ProgramMethod> singleCallers;
    private final Map<DexProgramClass, ProgramMethod> singleClinitCallers;

    SingleCallerInformation(ProgramMethodMap<ProgramMethod> singleCallers, Map<DexProgramClass, ProgramMethod> singleClinitCallers) {
        this.singleCallers = singleCallers;
        this.singleClinitCallers = singleClinitCallers;
    }

    public static Builder builder(AppView<? extends AppInfoWithClassHierarchy> appView) {
        return new Builder(appView);
    }

    public ProgramMethod getSingleCaller(ProgramMethod method) {
        return (ProgramMethod)this.singleCallers.get(method);
    }

    public ProgramMethod getSingleClassInitializerCaller(DexProgramClass clazz) {
        return this.singleClinitCallers.get(clazz);
    }

    public static class Builder {
        private final AppView<? extends AppInfoWithClassHierarchy> appView;
        final ProgramMethodMap<Optional<ProgramMethod>> callers = ProgramMethodMap.createConcurrent();
        final Map<DexProgramClass, Optional<ProgramMethod>> clinitCallers = new ConcurrentHashMap<DexProgramClass, Optional<ProgramMethod>>();

        Builder(AppView<? extends AppInfoWithClassHierarchy> appView) {
            this.appView = appView;
        }

        private void processMethod(ProgramMethod method) {
            method.registerCodeReferences(new InvokeExtractor(this.appView, method));
        }

        public Builder analyze(ExecutorService executorService) throws ExecutionException {
            ThreadUtils.processItems(this.appView.appInfo()::forEachMethod, this::processMethod, executorService);
            return this;
        }

        public SingleCallerInformation build() {
            ProgramMethodMap<ProgramMethod> singleCallers = ProgramMethodMap.create();
            this.callers.forEach((method, callers) -> callers.ifPresent(caller -> singleCallers.put(method, (ProgramMethod)caller)));
            IdentityHashMap<DexProgramClass, ProgramMethod> singleClinitCallers = new IdentityHashMap<DexProgramClass, ProgramMethod>();
            this.clinitCallers.forEach((clazz, callers) -> callers.ifPresent(caller -> singleClinitCallers.put((DexProgramClass)clazz, (ProgramMethod)caller)));
            return new SingleCallerInformation(singleCallers, singleClinitCallers);
        }

        private class InvokeExtractor
        extends UseRegistry<ProgramMethod> {
            private final AppView<? extends AppInfoWithClassHierarchy> appView;

            InvokeExtractor(AppView<? extends AppInfoWithClassHierarchy> appView, ProgramMethod context) {
                super(appView, context);
                this.appView = appView;
            }

            private void recordDispatchTarget(ProgramMethod target) {
                Builder.this.callers.compute(target, (key, value) -> {
                    if (value == null) {
                        return Optional.of((ProgramMethod)this.getContext());
                    }
                    if (value.orElse(null) == this.getContext()) {
                        return value;
                    }
                    return Optional.empty();
                });
            }

            private void triggerClassInitializerIfNotAlreadyTriggeredInContext(DexType type) {
                DexProgramClass clazz = type.asProgramClass(this.appView);
                if (clazz != null) {
                    this.triggerClassInitializerIfNotAlreadyTriggeredInContext(clazz);
                }
            }

            private void triggerClassInitializerIfNotAlreadyTriggeredInContext(DexProgramClass clazz) {
                if (!this.isClassAlreadyInitializedInCurrentContext(clazz)) {
                    this.triggerClassInitializer(clazz);
                }
            }

            private boolean isClassAlreadyInitializedInCurrentContext(DexProgramClass clazz) {
                return this.appView.appInfo().isSubtype(((ProgramMethod)this.getContext()).getHolder(), clazz);
            }

            private void triggerClassInitializer(DexType type) {
                DexProgramClass clazz = type.asProgramClass(this.appView);
                if (clazz != null) {
                    this.triggerClassInitializer(clazz);
                }
            }

            private void triggerClassInitializer(DexProgramClass clazz) {
                Optional<ProgramMethod> callers = Builder.this.clinitCallers.get(clazz);
                if (callers != null) {
                    if (!callers.isPresent()) {
                        return;
                    }
                    if (callers.get() == this.getContext()) {
                        return;
                    }
                }
                Builder.this.clinitCallers.compute(clazz, (key, value) -> {
                    if (value == null) {
                        return Optional.of((ProgramMethod)this.getContext());
                    }
                    assert (value.orElse(null) != this.getContext());
                    return Optional.empty();
                });
                this.triggerClassInitializer(clazz.getSuperType());
            }

            @Override
            public void registerInitClass(DexType type) {
                DexType rewrittenType = this.appView.graphLens().lookupType(type);
                this.triggerClassInitializerIfNotAlreadyTriggeredInContext(rewrittenType);
            }

            @Override
            public void registerInstanceFieldRead(DexField field) {
            }

            @Override
            public void registerInstanceFieldWrite(DexField field) {
            }

            @Override
            public void registerInvokeDirect(DexMethod method) {
                DexProgramClass holder;
                DexMethod rewrittenMethod = (DexMethod)this.appView.graphLens().lookupInvokeDirect(method, (ProgramMethod)this.getContext()).getReference();
                ProgramMethod target = rewrittenMethod.lookupOnProgramClass(holder = rewrittenMethod.getHolderType().asProgramClass(this.appView));
                if (target != null) {
                    this.recordDispatchTarget(target);
                }
            }

            @Override
            public void registerInvokeInterface(DexMethod method) {
            }

            @Override
            public void registerInvokeStatic(DexMethod method) {
                DexMethod rewrittenMethod = (DexMethod)this.appView.graphLens().lookupInvokeDirect(method, (ProgramMethod)this.getContext()).getReference();
                ProgramMethod target = this.appView.appInfo().unsafeResolveMethodDueToDexFormat(rewrittenMethod).getResolvedProgramMethod();
                if (target != null) {
                    this.recordDispatchTarget(target);
                    this.triggerClassInitializerIfNotAlreadyTriggeredInContext(target.getHolder());
                }
            }

            @Override
            public void registerInvokeSuper(DexMethod method) {
            }

            @Override
            public void registerInvokeVirtual(DexMethod method) {
            }

            @Override
            public void registerNewInstance(DexType type) {
                DexType rewrittenType = this.appView.graphLens().lookupType(type);
                this.triggerClassInitializerIfNotAlreadyTriggeredInContext(rewrittenType);
            }

            @Override
            public void registerStaticFieldRead(DexField field) {
                DexField rewrittenField = this.appView.graphLens().lookupField(field);
                this.triggerClassInitializerIfNotAlreadyTriggeredInContext(rewrittenField.getHolderType());
            }

            @Override
            public void registerStaticFieldWrite(DexField field) {
                DexField rewrittenField = this.appView.graphLens().lookupField(field);
                this.triggerClassInitializerIfNotAlreadyTriggeredInContext(rewrittenField.getHolderType());
            }

            @Override
            public void registerTypeReference(DexType type) {
            }
        }
    }
}

