/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.inspector.internal;

import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.inspector.FieldInspector;
import com.android.tools.r8.inspector.ValueInspector;
import com.android.tools.r8.inspector.internal.ClassInspectorImpl;
import com.android.tools.r8.inspector.internal.ValueInspectorImpl;
import com.android.tools.r8.references.FieldReference;
import com.android.tools.r8.references.Reference;
import java.util.Optional;

public class FieldInspectorImpl
implements FieldInspector {
    private final ClassInspectorImpl parent;
    private final DexEncodedField field;
    private FieldReference reference = null;

    public FieldInspectorImpl(ClassInspectorImpl parent, DexEncodedField field) {
        this.parent = parent;
        this.field = field;
    }

    @Override
    public FieldReference getFieldReference() {
        if (this.reference == null) {
            this.reference = Reference.field(this.parent.getClassReference(), ((DexField)this.field.getReference()).name.toString(), Reference.typeFromDescriptor(((DexField)this.field.getReference()).type.toDescriptorString()));
        }
        return this.reference;
    }

    @Override
    public boolean isStatic() {
        return this.field.accessFlags.isStatic();
    }

    @Override
    public boolean isFinal() {
        return this.field.accessFlags.isFinal();
    }

    @Override
    public Optional<ValueInspector> getInitialValue() {
        if (this.field.isStatic() && this.field.getStaticValue() != null) {
            return Optional.of(new ValueInspectorImpl(this.field.getStaticValue(), ((DexField)this.field.getReference()).type));
        }
        return Optional.empty();
    }
}

