/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.inspector.internal;

import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.inspector.ClassInspector;
import com.android.tools.r8.inspector.Inspector;
import com.android.tools.r8.inspector.internal.ClassInspectorImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

public class InspectorImpl
implements Inspector {
    private final Collection<DexProgramClass> classes;

    public static List<Consumer<InspectorImpl>> wrapInspections(Collection<Consumer<Inspector>> inspections) {
        if (inspections == null || inspections.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Consumer<InspectorImpl>> wrapped = new ArrayList<Consumer<InspectorImpl>>(inspections.size());
        for (Consumer<Inspector> inspection : inspections) {
            wrapped.add(inspection::accept);
        }
        return wrapped;
    }

    public static void runInspections(List<Consumer<InspectorImpl>> inspections, Collection<DexProgramClass> classes) {
        if (inspections == null || inspections.isEmpty()) {
            return;
        }
        InspectorImpl inspector = new InspectorImpl(classes);
        for (Consumer<InspectorImpl> inspection : inspections) {
            inspection.accept(inspector);
        }
    }

    public InspectorImpl(Collection<DexProgramClass> classes) {
        this.classes = classes;
    }

    @Override
    public void forEachClass(Consumer<ClassInspector> inspection) {
        for (DexProgramClass clazz : this.classes) {
            inspection.accept(new ClassInspectorImpl(clazz));
        }
    }
}

