/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.environmentdependence.ValueGraph;
import com.android.tools.r8.ir.analysis.value.AbstractValue;
import com.android.tools.r8.ir.code.ArrayPut;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InvokeDirect;
import com.android.tools.r8.ir.code.InvokeNewArray;
import com.android.tools.r8.ir.code.InvokeVirtual;
import com.android.tools.r8.ir.code.LogicalBinop;
import com.android.tools.r8.ir.code.NewArrayEmpty;
import com.android.tools.r8.ir.code.NewArrayFilledData;
import com.android.tools.r8.ir.code.NewInstance;
import com.android.tools.r8.ir.code.StaticPut;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.info.initializer.InstanceInitializerInfo;
import com.android.tools.r8.shaking.GlobalKeepInfoConfiguration;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.SetUtils;
import com.android.tools.r8.utils.WorkList;
import java.util.ArrayDeque;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ValueMayDependOnEnvironmentAnalysis {
    private final AppView<?> appView;
    private final ProgramMethod context;
    private final DexItemFactory dexItemFactory;
    private final InternalOptions options;

    public ValueMayDependOnEnvironmentAnalysis(AppView<?> appView, IRCode code) {
        this.appView = appView;
        this.context = code.context();
        this.dexItemFactory = appView.dexItemFactory();
        this.options = appView.options();
    }

    private boolean addValueToValueGraph(Value value, ValueGraph.Node node, ValueGraph graph, Set<Instruction> consumedInstructions, Set<Value> mutableValues, WorkList<Value> worklist) {
        return this.addConstantValueToValueGraph(value) || this.addArrayValueToValueGraph(value, node, graph, consumedInstructions, mutableValues, worklist) || this.addInvokeVirtualValueToValueGraph(value, node, graph, consumedInstructions, mutableValues, worklist) || this.addLogicalBinopValueToValueGraph(value, node, graph, consumedInstructions, mutableValues, worklist) || this.addNewInstanceValueToValueGraph(value, node, graph, consumedInstructions, mutableValues, worklist);
    }

    private boolean addConstantValueToValueGraph(Value value) {
        DexClass holder;
        DexField fieldReference;
        DexEncodedField field;
        if (value.isConstant()) {
            return true;
        }
        assert (!value.getAliasedValue().isConstant());
        AbstractValue abstractValue = value.getAbstractValue(this.appView, this.context);
        if (abstractValue.isSingleConstValue()) {
            return true;
        }
        return abstractValue.isSingleFieldValue() && (field = (fieldReference = abstractValue.asSingleFieldValue().getField()).lookupOnClass(holder = this.appView.definitionForHolder(fieldReference))) != null && field.isEnum();
    }

    private boolean addArrayValueToValueGraph(Value value, ValueGraph.Node node, ValueGraph graph, Set<Instruction> consumedInstructions, Set<Value> mutableValues, WorkList<Value> worklist) {
        if (value.isPhi()) {
            return false;
        }
        Instruction definition = value.definition;
        if (definition.isInvokeNewArray()) {
            InvokeNewArray invokeNewArray = definition.asInvokeNewArray();
            for (Value argument : invokeNewArray.arguments()) {
                graph.addDirectedEdge(node, graph.createNodeIfAbsent(argument));
                worklist.addIfNotSeen(argument);
            }
        } else if (definition.isNewArrayEmpty()) {
            NewArrayEmpty newArrayEmpty = definition.asNewArrayEmpty();
            Value sizeValue = newArrayEmpty.size();
            graph.addDirectedEdge(node, graph.createNodeIfAbsent(sizeValue));
            worklist.addIfNotSeen(sizeValue);
        } else {
            return false;
        }
        for (Instruction instruction : definition.getBlock().instructionsAfter(definition)) {
            Value array;
            if (instruction.isArrayPut()) {
                ArrayPut arrayPut = instruction.asArrayPut();
                array = arrayPut.array().getAliasedValue();
                if (array != value) break;
                graph.addDirectedEdge(node, graph.createNodeIfAbsent(arrayPut.index()));
                worklist.addIfNotSeen(arrayPut.index());
                graph.addDirectedEdge(node, graph.createNodeIfAbsent(arrayPut.value()));
                worklist.addIfNotSeen(arrayPut.value());
            } else if (instruction.isNewArrayFilledData()) {
                NewArrayFilledData newArrayFilledData = instruction.asNewArrayFilledData();
                array = newArrayFilledData.src();
                if (array != value) break;
                consumedInstructions.add(instruction);
            } else if (instruction.instructionMayHaveSideEffects(this.appView, this.context)) break;
            consumedInstructions.add(instruction);
        }
        mutableValues.add(value);
        return true;
    }

    private boolean addInvokeVirtualValueToValueGraph(Value value, ValueGraph.Node node, ValueGraph graph, Set<Instruction> consumedInstructions, Set<Value> mutableValues, WorkList<Value> worklist) {
        if (!value.isDefinedByInstructionSatisfying(Instruction::isInvokeVirtual)) {
            return false;
        }
        InvokeVirtual invoke = value.getDefinition().asInvokeVirtual();
        if (invoke.getInvokedMethod() == this.dexItemFactory.classMethods.desiredAssertionStatus) {
            return this.isNonPinnedClassConstant(invoke.getReceiver());
        }
        return false;
    }

    private boolean isNonPinnedClassConstant(Value value) {
        Value root = value.getAliasedValue();
        return root.isDefinedByInstructionSatisfying(Instruction::isConstClass) && !this.appView.getKeepInfo().isPinned(root.getDefinition().asConstClass().getType(), this.appView, (GlobalKeepInfoConfiguration)this.options);
    }

    private boolean addLogicalBinopValueToValueGraph(Value value, ValueGraph.Node node, ValueGraph graph, Set<Instruction> consumedInstructions, Set<Value> mutableValues, WorkList<Value> worklist) {
        if (!value.isDefinedByInstructionSatisfying(Instruction::isLogicalBinop)) {
            return false;
        }
        LogicalBinop logicalBinop = value.getDefinition().asLogicalBinop();
        for (Value inValue : logicalBinop.inValues()) {
            graph.addDirectedEdge(node, graph.createNodeIfAbsent(inValue));
            worklist.addIfNotSeen(inValue);
        }
        return true;
    }

    private boolean addNewInstanceValueToValueGraph(Value value, ValueGraph.Node node, ValueGraph graph, Set<Instruction> consumedInstructions, Set<Value> mutableValues, WorkList<Value> worklist) {
        if (!value.isDefinedByInstructionSatisfying(Instruction::isNewInstance)) {
            return false;
        }
        NewInstance newInstance = value.definition.asNewInstance();
        DexProgramClass clazz = DexProgramClass.asProgramClassOrNull(this.appView.definitionFor(newInstance.clazz));
        if (clazz == null) {
            return false;
        }
        InvokeDirect constructorInvoke = newInstance.getUniqueConstructorInvoke(this.dexItemFactory);
        if (constructorInvoke == null || constructorInvoke.getInvokedMethod().holder != clazz.type) {
            return false;
        }
        DexEncodedMethod constructor = clazz.lookupMethod(constructorInvoke.getInvokedMethod());
        if (constructor == null) {
            return false;
        }
        InstanceInitializerInfo initializerInfo = constructor.getOptimizationInfo().getInstanceInitializerInfo(constructorInvoke);
        List<DexEncodedField> fields = clazz.getDirectAndIndirectInstanceFields(this.appView);
        if (!fields.isEmpty()) {
            if (initializerInfo.instanceFieldInitializationMayDependOnEnvironment()) {
                return false;
            }
            for (int i = 1; i < constructorInvoke.arguments().size(); ++i) {
                Value argument = constructorInvoke.getArgument(i);
                graph.addDirectedEdge(node, graph.createNodeIfAbsent(argument));
                worklist.addIfNotSeen(argument);
            }
            boolean hasNonFinalField = false;
            for (DexEncodedField field : fields) {
                if (field.isFinal()) continue;
                hasNonFinalField = true;
                break;
            }
            if (hasNonFinalField) {
                mutableValues.add(value);
            }
        }
        if (!initializerInfo.mayHaveOtherSideEffectsThanInstanceFieldAssignments()) {
            consumedInstructions.add(constructorInvoke);
        }
        return true;
    }

    private boolean anyValueMayBeMutatedBeforeMethodExit(Set<Value> values2, Set<Instruction> whitelist) {
        Set<BasicBlock> initialBlocks = Sets.newIdentityHashSet();
        for (Value value : values2) {
            assert (!value.isPhi());
            initialBlocks.add(value.definition.getBlock());
        }
        IdentityHashMap<BasicBlock, TrackedValuesState> blockExitStates = new IdentityHashMap<BasicBlock, TrackedValuesState>();
        ArrayDeque<BasicBlock> worklist = new ArrayDeque<BasicBlock>(initialBlocks);
        while (!worklist.isEmpty()) {
            BasicBlock block = (BasicBlock)worklist.removeFirst();
            TrackedValuesState state = this.computeBlockEntryState(block, blockExitStates);
            boolean changed = false;
            for (Instruction instruction : block.getInstructions()) {
                if (whitelist.contains(instruction)) continue;
                if (instruction.isStaticPut()) {
                    DexType holder;
                    StaticPut staticPut = instruction.asStaticPut();
                    if (state.isTrackingValue(staticPut.value())) {
                        changed |= state.recordTrackedValueHasEscaped();
                    }
                    if (!state.hasTrackedValueEscaped() || !(holder = staticPut.getField().holder).classInitializationMayHaveSideEffectsInContext(this.appView, this.context)) continue;
                    return true;
                }
                if (instruction.instructionMayTriggerMethodInvocation(this.appView, this.context)) {
                    if (instruction.hasInValueThatMatches(state::isTrackingValue)) {
                        changed |= state.recordTrackedValueHasEscaped();
                    }
                    if (state.hasTrackedValueEscaped() && instruction.instructionMayHaveSideEffects(this.appView, this.context)) {
                        return true;
                    }
                }
                if (!instruction.hasOutValue() || !values2.contains(instruction.outValue())) continue;
                changed |= state.startTrackingValue(instruction.outValue());
            }
            blockExitStates.put(block, state);
            if (!changed) continue;
            worklist.addAll(block.getSuccessors());
        }
        return false;
    }

    private TrackedValuesState computeBlockEntryState(BasicBlock block, Map<BasicBlock, TrackedValuesState> states) {
        TrackedValuesState state = new TrackedValuesState();
        for (BasicBlock predecessor : block.getPredecessors()) {
            state.add(states.getOrDefault(predecessor, TrackedValuesState.empty()));
        }
        return state;
    }

    public boolean anyValueMayDependOnEnvironment(Iterable<Value> values2) {
        ValueGraph graph = new ValueGraph();
        Set<Instruction> consumedInstructions = Sets.newIdentityHashSet();
        Set<Value> mutableValues = Sets.newIdentityHashSet();
        WorkList<Value> worklist = WorkList.newIdentityWorkList(values2);
        while (worklist.hasNext()) {
            Value value = worklist.next();
            Value root = value.getAliasedValue();
            ValueGraph.Node node = graph.createNodeIfAbsent(root);
            if (root != value) {
                graph.addDirectedEdge(graph.createNodeIfAbsent(value), node);
            }
            if (this.addValueToValueGraph(root, node, graph, consumedInstructions, mutableValues, worklist)) continue;
            return true;
        }
        graph.mergeStronglyConnectedComponents();
        Set<ValueGraph.Node> nodesDependentOnEnvironment = SetUtils.newIdentityHashSet(graph.getNodes());
        while (!nodesDependentOnEnvironment.isEmpty()) {
            Set<ValueGraph.Node> newNodesIndependentOfEnvironment = Sets.newIdentityHashSet();
            for (ValueGraph.Node node : nodesDependentOnEnvironment) {
                boolean isDependentOfEnvironment = node.hasSuccessorThatMatches(successor -> nodesDependentOnEnvironment.contains(successor) && !newNodesIndependentOfEnvironment.contains(successor));
                if (isDependentOfEnvironment) continue;
                newNodesIndependentOfEnvironment.add(node);
            }
            if (newNodesIndependentOfEnvironment.isEmpty()) {
                return true;
            }
            nodesDependentOnEnvironment.removeAll(newNodesIndependentOfEnvironment);
        }
        return this.anyValueMayBeMutatedBeforeMethodExit(mutableValues, consumedInstructions);
    }

    static class TrackedValuesState {
        private static final TrackedValuesState EMPTY = new TrackedValuesState();
        boolean hasTrackedValueEscaped;
        Set<Value> trackedValues = Sets.newIdentityHashSet();

        TrackedValuesState() {
        }

        public static TrackedValuesState empty() {
            return EMPTY;
        }

        public void add(TrackedValuesState state) {
            this.hasTrackedValueEscaped |= state.hasTrackedValueEscaped;
            this.trackedValues.addAll(state.trackedValues);
        }

        public boolean hasTrackedValueEscaped() {
            return this.hasTrackedValueEscaped;
        }

        public boolean isTrackingValue(Value value) {
            return this.trackedValues.contains(value);
        }

        public boolean recordTrackedValueHasEscaped() {
            if (this.hasTrackedValueEscaped) {
                return false;
            }
            this.hasTrackedValueEscaped = true;
            return true;
        }

        public boolean startTrackingValue(Value value) {
            return this.trackedValues.add(value);
        }
    }
}

