/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.ir.analysis.type.TypeElement;

public class VerifyTypesHelper {
    private final AppView<?> appView;

    private VerifyTypesHelper(AppView<?> appView) {
        this.appView = appView;
    }

    public static VerifyTypesHelper create(AppView<?> appView) {
        return new VerifyTypesHelper(appView);
    }

    public boolean isAssignable(TypeElement one, TypeElement other) {
        if (one.isPrimitiveType() != other.isPrimitiveType()) {
            return false;
        }
        if (one.isPrimitiveType()) {
            assert (other.isPrimitiveType());
            return one.equals(other);
        }
        assert (one.isReferenceType() && other.isReferenceType());
        if (one.isNullType() && other.isReferenceType()) {
            return true;
        }
        if (one.isArrayType() != other.isArrayType()) {
            return one.isArrayType() && other.asClassType().getClassType() == this.appView.dexItemFactory().objectType;
        }
        if (one.isArrayType()) {
            assert (other.isArrayType());
            return this.isAssignable(one.asArrayType().getMemberType(), other.asArrayType().getMemberType());
        }
        assert (one.isClassType() && other.isClassType());
        if (this.appView.enableWholeProgramOptimizations()) {
            return one.lessThanOrEqual(other, this.appView) || one.isBasedOnMissingClass(this.appView.withClassHierarchy());
        }
        if (one.asClassType().getClassType() == this.appView.dexItemFactory().objectType) {
            return other.asClassType().getClassType() == this.appView.dexItemFactory().objectType;
        }
        return true;
    }
}

