/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.environmentdependence;

import com.android.tools.r8.algorithms.scc.SCC;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.utils.WorkList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

public class ValueGraph {
    private final Map<Value, Node> nodes = new IdentityHashMap<Value, Node>();

    public Node createNodeIfAbsent(Value value) {
        return this.nodes.computeIfAbsent(value, Node::new);
    }

    public void addDirectedEdge(Node from, Node to) {
        to.predecessors.add(from);
        from.successors.add(to);
    }

    public Collection<Node> getNodes() {
        return this.nodes.values();
    }

    public void mergeNodes(Iterable<Node> iterable) {
        Iterator<Node> iterator2 = iterable.iterator();
        assert (iterator2.hasNext());
        Node primary = iterator2.next();
        while (iterator2.hasNext()) {
            Node secondary = iterator2.next();
            secondary.moveEdgesTo(primary);
            primary.addLabel(secondary.label);
            this.nodes.put(secondary.value, primary);
        }
    }

    public void mergeStronglyConnectedComponents() {
        WorkList<Node> worklist = WorkList.newIdentityWorkList(this.nodes.values());
        while (worklist.hasNext()) {
            Node node = worklist.next();
            List<Set<Node>> components = new SCC<Node>(Node::getSuccessors).computeSCC(node);
            for (Set<Node> component : components) {
                this.mergeNodes(component);
                worklist.markAsSeen(component);
            }
        }
    }

    public static class Node {
        private final Value value;
        private final Set<Value> label = Sets.newIdentityHashSet();
        private final Set<Node> predecessors = Sets.newIdentityHashSet();
        private final Set<Node> successors = Sets.newIdentityHashSet();

        public Node(Value value) {
            this.label.add(value);
            this.value = value;
        }

        public void addLabel(Set<Value> label) {
            this.label.addAll(label);
        }

        public Set<Node> getSuccessors() {
            return this.successors;
        }

        public boolean hasSuccessorThatMatches(Predicate<Node> predicate) {
            for (Node successor : this.successors) {
                if (!predicate.test(successor)) continue;
                return true;
            }
            return false;
        }

        public void moveEdgesTo(Node node) {
            for (Node predecessor : this.predecessors) {
                predecessor.successors.remove(this);
                predecessor.successors.add(node);
                node.predecessors.add(predecessor);
            }
            this.predecessors.clear();
            for (Node successor : this.successors) {
                successor.predecessors.remove(this);
                successor.predecessors.add(node);
                node.successors.add(successor);
            }
            this.successors.clear();
        }
    }
}

