/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.equivalence;

import com.android.tools.r8.com.google.common.base.Predicates;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.ConstClass;
import com.android.tools.r8.ir.code.ConstNumber;
import com.android.tools.r8.ir.code.ConstString;
import com.android.tools.r8.ir.code.DexItemBasedConstString;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.InvokeDirect;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.Return;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.utils.SetUtils;
import java.util.List;
import java.util.Set;

public class BasicBlockBehavioralSubsumption {
    private final AppView<?> appView;
    private final IRCode code;
    private final ProgramMethod context;

    public BasicBlockBehavioralSubsumption(AppView<?> appView, IRCode code) {
        this.appView = appView;
        this.code = code;
        this.context = code.context();
    }

    private boolean isSubsumedBy(InstructionIterator iterator2, InstructionIterator otherIterator, Set<BasicBlock> visited) {
        Instruction instruction = (Instruction)iterator2.nextUntil(Predicates.or(Predicates.not(this::isBlockLocalInstructionWithoutSideEffects), Instruction::isJumpInstruction));
        if (this.definesValueWithNonLocalUsages(instruction)) {
            return false;
        }
        Instruction otherInstruction = (Instruction)otherIterator.nextUntil(Predicates.or(this::instructionMayHaveSideEffects, Instruction::isJumpInstruction));
        assert (otherInstruction != null);
        if (instruction.isGoto()) {
            BasicBlock targetBlock = instruction.asGoto().getTarget();
            if (otherInstruction.isGoto()) {
                BasicBlock otherTargetBlock = otherInstruction.asGoto().getTarget();
                if (targetBlock == otherTargetBlock) {
                    return this.passesIdenticalValuesForPhis(instruction.getBlock(), otherInstruction.getBlock(), targetBlock);
                }
                if (otherTargetBlock.hasPhis()) {
                    return false;
                }
                otherIterator = otherTargetBlock.iterator();
            } else {
                if (targetBlock.hasPhis()) {
                    return false;
                }
                otherIterator.previous();
            }
            if (visited == null) {
                visited = SetUtils.newIdentityHashSet(instruction.getBlock());
            }
            if (visited.add(targetBlock)) {
                return this.isSubsumedBy(targetBlock.iterator(), otherIterator, visited);
            }
            return false;
        }
        Set<BasicBlock> otherVisited = null;
        while (otherInstruction.isGoto()) {
            BasicBlock block = otherInstruction.getBlock();
            if (otherVisited != null && !otherVisited.add(block)) {
                return false;
            }
            BasicBlock targetBlock = otherInstruction.asGoto().getTarget();
            if (targetBlock.hasPhis()) {
                return false;
            }
            otherIterator = targetBlock.iterator();
            otherInstruction = (Instruction)otherIterator.nextUntil(Predicates.or(this::instructionMayHaveSideEffects, Instruction::isJumpInstruction));
            if (!otherInstruction.isGoto() || otherVisited != null) continue;
            otherVisited = SetUtils.newIdentityHashSet(block);
        }
        if (instruction.isInvokeConstructor(this.appView.dexItemFactory())) {
            InvokeDirect invoke = instruction.asInvokeDirect();
            if (otherInstruction.isInvokeConstructor(this.appView.dexItemFactory())) {
                InvokeDirect otherInvoke = otherInstruction.asInvokeDirect();
                DexClassAndMethod singleTarget = invoke.lookupSingleTarget(this.appView, this.context);
                if (singleTarget == null || ((DexEncodedMethod)singleTarget.getDefinition()).getOptimizationInfo().mayHaveSideEffects()) {
                    return false;
                }
                DexClassAndMethod otherSingleTarget = otherInvoke.lookupSingleTarget(this.appView, this.context);
                if (otherSingleTarget == null || ((DexEncodedMethod)otherSingleTarget.getDefinition()).getOptimizationInfo().mayHaveSideEffects()) {
                    return false;
                }
                return this.isSubsumedBy(iterator2, otherIterator, visited);
            }
            return false;
        }
        if (instruction.isReturn()) {
            Return returnInstruction = instruction.asReturn();
            if (otherInstruction.isReturn()) {
                Return otherReturnInstruction = otherInstruction.asReturn();
                if (returnInstruction.isReturnVoid()) {
                    assert (otherReturnInstruction.isReturnVoid());
                    return true;
                }
                return this.valuesAreIdentical(otherReturnInstruction.returnValue(), returnInstruction.returnValue());
            }
            return false;
        }
        return false;
    }

    private boolean isBlockLocalInstructionWithoutSideEffects(Instruction instruction) {
        return this.definesBlockLocalValue(instruction) && !this.instructionMayHaveSideEffects(instruction);
    }

    private boolean definesBlockLocalValue(Instruction instruction) {
        return !this.definesValueWithNonLocalUsages(instruction);
    }

    private boolean definesValueWithNonLocalUsages(Instruction instruction) {
        if (instruction.hasOutValue()) {
            Value outValue = instruction.outValue();
            if (outValue.numberOfPhiUsers() > 0) {
                return true;
            }
            for (Instruction user : outValue.uniqueUsers()) {
                if (user.getBlock() == instruction.getBlock()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean instructionMayHaveSideEffects(Instruction instruction) {
        return instruction.isInvokeConstructor(this.appView.dexItemFactory()) || instruction.instructionMayHaveSideEffects(this.appView, this.context);
    }

    private boolean valuesAreIdentical(Value value, Value other) {
        if ((value = value.getAliasedValue()) == (other = other.getAliasedValue())) {
            return true;
        }
        if (value.isPhi() || other.isPhi()) {
            return false;
        }
        return this.instructionsDefineIdenticalValues(value.definition, other.definition);
    }

    private boolean instructionsDefineIdenticalValues(Instruction instruction, Instruction other) {
        assert (instruction.hasOutValue());
        assert (other.hasOutValue());
        Value outValue = instruction.outValue();
        Value otherOutValue = other.outValue();
        if (!outValue.getType().equals(otherOutValue.getType())) {
            return false;
        }
        if (instruction.isConstClass()) {
            if (!other.isConstClass()) {
                return false;
            }
            ConstClass constClassInstruction = instruction.asConstClass();
            ConstClass otherConstClassInstruction = other.asConstClass();
            return constClassInstruction.getValue() == otherConstClassInstruction.getValue();
        }
        if (instruction.isConstNumber()) {
            if (!other.isConstNumber()) {
                return false;
            }
            ConstNumber constNumberInstruction = instruction.asConstNumber();
            ConstNumber otherConstNumberInstruction = other.asConstNumber();
            return constNumberInstruction.getRawValue() == otherConstNumberInstruction.getRawValue();
        }
        if (instruction.isConstString()) {
            if (!other.isConstString()) {
                return false;
            }
            ConstString constStringInstruction = instruction.asConstString();
            ConstString otherConstStringInstruction = other.asConstString();
            return constStringInstruction.getValue() == otherConstStringInstruction.getValue();
        }
        if (instruction.isDexItemBasedConstString()) {
            if (!other.isDexItemBasedConstString()) {
                return false;
            }
            DexItemBasedConstString constStringInstruction = instruction.asDexItemBasedConstString();
            DexItemBasedConstString otherConstStringInstruction = other.asDexItemBasedConstString();
            return constStringInstruction.getItem() == otherConstStringInstruction.getItem();
        }
        return false;
    }

    private boolean passesIdenticalValuesForPhis(BasicBlock block, BasicBlock other, BasicBlock blockWithPhis) {
        if (block == other) {
            return true;
        }
        int predecessorIndex = -1;
        int otherPredecessorIndex = -1;
        List<BasicBlock> predecessors = blockWithPhis.getPredecessors();
        for (int i = 0; i < predecessors.size(); ++i) {
            BasicBlock predecessor = predecessors.get(i);
            if (predecessor == block) {
                predecessorIndex = i;
                if (otherPredecessorIndex < 0) continue;
                break;
            }
            if (predecessor != other) continue;
            otherPredecessorIndex = i;
            if (predecessorIndex >= 0) break;
        }
        assert (predecessorIndex >= 0);
        assert (otherPredecessorIndex >= 0);
        for (Phi phi : blockWithPhis.getPhis()) {
            if (this.valuesAreIdentical(phi.getOperand(predecessorIndex), phi.getOperand(otherPredecessorIndex))) continue;
            return false;
        }
        return true;
    }

    public boolean isSubsumedBy(BasicBlock block, BasicBlock other) {
        return this.isSubsumedBy(block.iterator(), other.iterator(), null);
    }
}

