/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.fieldaccess;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.FieldAccessInfo;
import com.android.tools.r8.graph.FieldAccessInfoCollection;
import com.android.tools.r8.graph.ObjectAllocationInfoCollection;
import com.android.tools.r8.graph.ProgramField;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.horizontalclassmerging.HorizontalClassMergerUtils;
import com.android.tools.r8.ir.analysis.fieldaccess.state.ConcreteArrayTypeFieldState;
import com.android.tools.r8.ir.analysis.fieldaccess.state.ConcreteClassTypeFieldState;
import com.android.tools.r8.ir.analysis.fieldaccess.state.ConcretePrimitiveTypeFieldState;
import com.android.tools.r8.ir.analysis.fieldaccess.state.FieldState;
import com.android.tools.r8.ir.analysis.type.ClassTypeElement;
import com.android.tools.r8.ir.analysis.type.DynamicType;
import com.android.tools.r8.ir.analysis.type.DynamicTypeWithUpperBound;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.value.AbstractValue;
import com.android.tools.r8.ir.analysis.value.AbstractValueFactory;
import com.android.tools.r8.ir.analysis.value.BottomValue;
import com.android.tools.r8.ir.analysis.value.NonConstantNumberValue;
import com.android.tools.r8.ir.analysis.value.SingleValue;
import com.android.tools.r8.ir.analysis.value.UnknownValue;
import com.android.tools.r8.ir.code.FieldInstruction;
import com.android.tools.r8.ir.code.InvokeDirect;
import com.android.tools.r8.ir.code.NewInstance;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.ClassInitializerDefaultsOptimization;
import com.android.tools.r8.ir.optimize.info.OptimizationFeedbackDelayed;
import com.android.tools.r8.ir.optimize.info.field.InstanceFieldArgumentInitializationInfo;
import com.android.tools.r8.ir.optimize.info.field.InstanceFieldInitializationInfo;
import com.android.tools.r8.ir.optimize.info.field.InstanceFieldInitializationInfoCollection;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2IntMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import com.android.tools.r8.optimize.argumentpropagation.utils.WideningUtils;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.shaking.KeepFieldInfo;
import com.android.tools.r8.utils.collections.ProgramMethodSet;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

public class FieldAssignmentTracker {
    private final AbstractValueFactory abstractValueFactory;
    private final AppView<AppInfoWithLiveness> appView;
    private final DexItemFactory dexItemFactory;
    private final FieldAccessGraph fieldAccessGraph;
    private final ObjectAllocationGraph objectAllocationGraph;
    private final Map<DexEncodedField, FieldState> fieldStates = new ConcurrentHashMap<DexEncodedField, FieldState>();
    private final Map<DexProgramClass, Map<DexEncodedField, AbstractValue>> abstractInstanceFieldValues = new ConcurrentHashMap<DexProgramClass, Map<DexEncodedField, AbstractValue>>();

    FieldAssignmentTracker(AppView<AppInfoWithLiveness> appView) {
        this.abstractValueFactory = appView.abstractValueFactory();
        this.appView = appView;
        this.dexItemFactory = appView.dexItemFactory();
        this.fieldAccessGraph = new FieldAccessGraph();
        this.objectAllocationGraph = new ObjectAllocationGraph();
    }

    private void initializeAbstractInstanceFieldValues() {
        FieldAccessInfoCollection<? extends FieldAccessInfo> fieldAccessInfos = this.appView.appInfo().getFieldAccessInfoCollection();
        ObjectAllocationInfoCollection objectAllocationInfos = this.appView.appInfo().getObjectAllocationInfoCollection();
        objectAllocationInfos.forEachClassWithKnownAllocationSites((clazz, allocationSites) -> {
            if (this.appView.appInfo().isInstantiatedIndirectly((DexProgramClass)clazz)) {
                return;
            }
            List<DexEncodedField> instanceFields = clazz.instanceFields();
            if (instanceFields.isEmpty()) {
                return;
            }
            IdentityHashMap<DexEncodedField, BottomValue> abstractInstanceFieldValuesForClass = new IdentityHashMap<DexEncodedField, BottomValue>();
            for (DexEncodedField field : clazz.instanceFields()) {
                Object fieldAccessInfo = fieldAccessInfos.get((DexField)field.getReference());
                if (fieldAccessInfo == null || fieldAccessInfo.hasReflectiveAccess()) continue;
                abstractInstanceFieldValuesForClass.put(field, BottomValue.getInstance());
            }
            this.abstractInstanceFieldValues.put((DexProgramClass)clazz, (Map<DexEncodedField, AbstractValue>)abstractInstanceFieldValuesForClass);
        });
        for (DexProgramClass clazz2 : this.appView.appInfo().classes()) {
            clazz2.forEachProgramField(field -> {
                Object accessInfo = fieldAccessInfos.get((DexField)field.getReference());
                KeepFieldInfo keepInfo = this.appView.getKeepInfo((ProgramField)field);
                if (keepInfo.isPinned(this.appView.options()) || accessInfo.isWrittenFromMethodHandle()) {
                    this.fieldStates.put((DexEncodedField)field.getDefinition(), FieldState.unknown());
                }
            });
        }
    }

    private void recordFieldPut(ProgramField field, Value value, ProgramMethod context) {
        UnknownValue abstractValue = value.isZero() ? this.abstractValueFactory.createZeroValue() : AbstractValue.unknown();
        this.fieldStates.compute((DexEncodedField)field.getDefinition(), (f, fieldState) -> {
            if (fieldState == null || fieldState.isBottom()) {
                DexType fieldType = field.getType();
                if (fieldType.isArrayType()) {
                    return ConcreteArrayTypeFieldState.create(abstractValue);
                }
                if (fieldType.isPrimitiveType()) {
                    return ConcretePrimitiveTypeFieldState.create(abstractValue);
                }
                assert (fieldType.isClassType());
                DynamicTypeWithUpperBound dynamicType = fieldType.isArrayType() ? DynamicType.unknown() : WideningUtils.widenDynamicNonReceiverType(this.appView, value.getDynamicType(this.appView).withNullability(Nullability.maybeNull()), field.getType());
                return ConcreteClassTypeFieldState.create(abstractValue, dynamicType);
            }
            if (fieldState.isUnknown()) {
                return fieldState;
            }
            assert (fieldState.isConcrete());
            if (fieldState.isArray()) {
                ConcreteArrayTypeFieldState arrayFieldState = fieldState.asArray();
                return arrayFieldState.mutableJoin(this.appView, abstractValue);
            }
            if (fieldState.isPrimitive()) {
                ConcretePrimitiveTypeFieldState primitiveFieldState = fieldState.asPrimitive();
                return primitiveFieldState.mutableJoin(abstractValue, this.abstractValueFactory);
            }
            assert (fieldState.isClass());
            ConcreteClassTypeFieldState classFieldState = fieldState.asClass();
            return classFieldState.mutableJoin(this.appView, abstractValue, value.getDynamicType(this.appView), field);
        });
    }

    private void recordAllFieldPutsProcessed(ProgramField field, ProgramMethod context, OptimizationFeedbackDelayed feedback) {
        ConcreteClassTypeFieldState classFieldState;
        DynamicType dynamicType;
        FieldState fieldState = this.fieldStates.getOrDefault(field.getDefinition(), FieldState.bottom());
        AbstractValue abstractValue = fieldState.getAbstractValue(this.appView.abstractValueFactory());
        if (abstractValue.isNonTrivial()) {
            feedback.recordFieldHasAbstractValue((DexEncodedField)field.getDefinition(), this.appView, abstractValue);
        }
        if (fieldState.isClass() && field.getOptimizationInfo().getDynamicType().isUnknown() && !(dynamicType = (classFieldState = fieldState.asClass()).getDynamicType()).isUnknown()) {
            assert (WideningUtils.widenDynamicNonReceiverType(this.appView, dynamicType, field.getType()) == dynamicType);
            if (dynamicType.isNotNullType()) {
                feedback.markFieldHasDynamicType((DexEncodedField)field.getDefinition(), dynamicType);
            } else {
                DynamicTypeWithUpperBound staticType = field.getType().toDynamicType(this.appView);
                if (dynamicType.asDynamicTypeWithUpperBound().strictlyLessThan(staticType, this.appView)) {
                    feedback.markFieldHasDynamicType((DexEncodedField)field.getDefinition(), dynamicType);
                }
            }
        }
        if (!field.getAccessFlags().isStatic()) {
            this.recordAllInstanceFieldPutsProcessed(field, feedback);
        }
    }

    private void recordAllInstanceFieldPutsProcessed(ProgramField field, OptimizationFeedbackDelayed feedback) {
        if (this.appView.appInfo().isInstanceFieldWrittenOnlyInInstanceInitializers(field)) {
            AbstractValue abstractValue = BottomValue.getInstance();
            DexProgramClass clazz = field.getHolder();
            for (DexEncodedMethod method : clazz.directMethods(DexEncodedMethod::isInstanceInitializer)) {
                InstanceFieldInitializationInfo fieldInitializationInfo = method.getOptimizationInfo().getContextInsensitiveInstanceInitializerInfo().fieldInitializationInfos().get(field);
                if (fieldInitializationInfo.isSingleValue()) {
                    if (!(abstractValue = abstractValue.join(fieldInitializationInfo.asSingleValue(), this.appView.abstractValueFactory(), field.getType())).isUnknown()) continue;
                    break;
                }
                if (fieldInitializationInfo.isTypeInitializationInfo()) {
                    abstractValue = UnknownValue.getInstance();
                    break;
                }
                assert (fieldInitializationInfo.isArgumentInitializationInfo() || fieldInitializationInfo.isUnknown());
                abstractValue = UnknownValue.getInstance();
                break;
            }
            assert (!abstractValue.isBottom());
            if (!abstractValue.isUnknown()) {
                feedback.recordFieldHasAbstractValue((DexEncodedField)field.getDefinition(), this.appView, abstractValue);
            }
        }
    }

    private void recordAllAllocationsSitesProcessed(DexProgramClass clazz, OptimizationFeedbackDelayed feedback) {
        Map<DexEncodedField, AbstractValue> abstractInstanceFieldValuesForClass = this.abstractInstanceFieldValues.get(clazz);
        if (abstractInstanceFieldValuesForClass == null) {
            return;
        }
        for (DexEncodedField field : clazz.instanceFields()) {
            AbstractValue abstractValue = abstractInstanceFieldValuesForClass.getOrDefault(field, UnknownValue.getInstance());
            if (abstractValue.isBottom()) {
                feedback.modifyAppInfoWithLiveness(modifier -> modifier.removeInstantiatedType(clazz));
                break;
            }
            if (abstractValue.isUnknown()) continue;
            feedback.recordFieldHasAbstractValue(field, this.appView, abstractValue);
        }
    }

    public void initialize() {
        this.fieldAccessGraph.initialize(this.appView);
        this.objectAllocationGraph.initialize(this.appView);
        this.initializeAbstractInstanceFieldValues();
    }

    void acceptClassInitializerDefaultsResult(ClassInitializerDefaultsOptimization.ClassInitializerDefaultsResult classInitializerDefaultsResult) {
        classInitializerDefaultsResult.forEachOptimizedField((field, value) -> {
            DexType fieldType = field.getType();
            if (value.isDefault(field.getType())) {
                return;
            }
            assert (fieldType.isClassType() || fieldType.isPrimitiveType());
            this.fieldStates.compute((DexEncodedField)field, (f, fieldState) -> {
                if (fieldState == null) {
                    AbstractValue abstractValue = value.toAbstractValue(this.abstractValueFactory);
                    if (fieldType.isClassType()) {
                        assert (abstractValue.isSingleStringValue() || abstractValue.isSingleDexItemBasedStringValue());
                        if (fieldType == this.dexItemFactory.stringType) {
                            return ConcreteClassTypeFieldState.create(abstractValue, DynamicType.definitelyNotNull());
                        }
                        ClassTypeElement nonNullableStringType = this.dexItemFactory.stringType.toTypeElement(this.appView, Nullability.definitelyNotNull()).asClassType();
                        return ConcreteClassTypeFieldState.create(abstractValue, DynamicType.createExact(nonNullableStringType));
                    }
                    assert (fieldType.isPrimitiveType());
                    return ConcretePrimitiveTypeFieldState.create(abstractValue);
                }
                return FieldState.unknown();
            });
        });
    }

    void recordFieldAccess(FieldInstruction instruction, ProgramField field, ProgramMethod context) {
        if (instruction.isFieldPut()) {
            this.recordFieldPut(field, instruction.value(), context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recordAllocationSite(NewInstance instruction, DexProgramClass clazz, ProgramMethod context) {
        Map<DexEncodedField, AbstractValue> abstractInstanceFieldValuesForClass = this.abstractInstanceFieldValues.get(clazz);
        if (abstractInstanceFieldValuesForClass == null) {
            return;
        }
        InvokeDirect invoke = instruction.getUniqueConstructorInvoke(this.dexItemFactory);
        if (invoke == null) {
            this.abstractInstanceFieldValues.remove(clazz);
            return;
        }
        DexClassAndMethod singleTarget = invoke.lookupSingleTarget(this.appView, context);
        if (singleTarget == null) {
            this.abstractInstanceFieldValues.remove(clazz);
            return;
        }
        InstanceFieldInitializationInfoCollection initializationInfoCollection = ((DexEncodedMethod)singleTarget.getDefinition()).getOptimizationInfo().getInstanceInitializerInfo(invoke).fieldInitializationInfos();
        Map<DexEncodedField, AbstractValue> map = abstractInstanceFieldValuesForClass;
        synchronized (map) {
            Iterator<Map.Entry<DexEncodedField, AbstractValue>> iterator2 = abstractInstanceFieldValuesForClass.entrySet().iterator();
            while (iterator2.hasNext()) {
                NonConstantNumberValue initialAbstractValue;
                Map.Entry<DexEncodedField, AbstractValue> entry = iterator2.next();
                DexEncodedField field = entry.getKey();
                AbstractValue abstractValue = entry.getValue();
                boolean isClassIdField = HorizontalClassMergerUtils.isClassIdField(this.appView, field);
                InstanceFieldInitializationInfo initializationInfo = initializationInfoCollection.get(field);
                if (initializationInfo.isArgumentInitializationInfo()) {
                    InstanceFieldArgumentInitializationInfo argumentInitializationInfo = initializationInfo.asArgumentInitializationInfo();
                    Value argument = invoke.arguments().get(argumentInitializationInfo.getArgumentIndex());
                    AbstractValue argumentAbstractValue = argument.getAbstractValue(this.appView, context);
                    abstractValue = abstractValue.join(argumentAbstractValue, this.appView.abstractValueFactory(), field.getType().isReferenceType(), isClassIdField);
                    assert (!abstractValue.isBottom());
                } else if (initializationInfo.isSingleValue()) {
                    SingleValue singleValueInitializationInfo = initializationInfo.asSingleValue();
                    abstractValue = abstractValue.join(singleValueInitializationInfo, this.appView.abstractValueFactory(), field.getType().isReferenceType(), isClassIdField);
                } else if (initializationInfo.isTypeInitializationInfo()) {
                    abstractValue = UnknownValue.getInstance();
                } else {
                    assert (initializationInfo.isUnknown());
                    abstractValue = UnknownValue.getInstance();
                }
                assert (!abstractValue.isBottom());
                if (isClassIdField && abstractValue.isNonConstantNumberValue() && (initialAbstractValue = field.getOptimizationInfo().getAbstractValue().asNonConstantNumberValue()) != null && abstractValue.asNonConstantNumberValue().getAbstractionSize() >= initialAbstractValue.getAbstractionSize()) {
                    abstractValue = UnknownValue.getInstance();
                }
                if (!abstractValue.isUnknown()) {
                    entry.setValue(abstractValue);
                    continue;
                }
                iterator2.remove();
            }
        }
    }

    public void waveDone(ProgramMethodSet wave, OptimizationFeedbackDelayed feedback) {
        assert (feedback.noUpdatesLeft());
        for (ProgramMethod method : wave) {
            this.fieldAccessGraph.markProcessed(method, field -> this.recordAllFieldPutsProcessed((ProgramField)field, method, feedback));
            this.objectAllocationGraph.markProcessed(method, clazz -> this.recordAllAllocationsSitesProcessed((DexProgramClass)clazz, feedback));
        }
        feedback.refineAppInfoWithLiveness(this.appView.appInfo().withLiveness());
        feedback.updateVisibleOptimizationInfo();
    }

    static class ObjectAllocationGraph {
        private final Map<DexEncodedMethod, List<DexProgramClass>> objectAllocations = new IdentityHashMap<DexEncodedMethod, List<DexProgramClass>>();
        private final Reference2IntMap<DexProgramClass> pendingObjectAllocations = new Reference2IntOpenHashMap<DexProgramClass>();

        ObjectAllocationGraph() {
        }

        public void initialize(AppView<AppInfoWithLiveness> appView) {
            ObjectAllocationInfoCollection objectAllocationInfos = appView.appInfo().getObjectAllocationInfoCollection();
            objectAllocationInfos.forEachClassWithKnownAllocationSites((clazz, contexts) -> {
                for (DexEncodedMethod context : contexts) {
                    this.objectAllocations.computeIfAbsent(context, ignore -> new ArrayList()).add(clazz);
                }
                this.pendingObjectAllocations.put((DexProgramClass)clazz, contexts.size());
            });
        }

        void markProcessed(ProgramMethod method, Consumer<DexProgramClass> allAllocationsSitesSeenConsumer) {
            List<DexProgramClass> allocationSitesInMethod = this.objectAllocations.get(method.getDefinition());
            if (allocationSitesInMethod != null) {
                for (DexProgramClass type : allocationSitesInMethod) {
                    int numberOfPendingAllocationSites = this.pendingObjectAllocations.removeInt(type) - 1;
                    if (numberOfPendingAllocationSites > 0) {
                        this.pendingObjectAllocations.put(type, numberOfPendingAllocationSites);
                        continue;
                    }
                    allAllocationsSitesSeenConsumer.accept(type);
                }
            }
        }
    }

    static class FieldAccessGraph {
        private final Map<DexEncodedMethod, List<ProgramField>> fieldWrites = new IdentityHashMap<DexEncodedMethod, List<ProgramField>>();
        private final Reference2IntMap<DexEncodedField> pendingFieldWrites = new Reference2IntOpenHashMap<DexEncodedField>();

        FieldAccessGraph() {
        }

        public void initialize(AppView<AppInfoWithLiveness> appView) {
            FieldAccessInfoCollection<? extends FieldAccessInfo> fieldAccessInfoCollection = appView.appInfo().getFieldAccessInfoCollection();
            fieldAccessInfoCollection.forEach(info -> {
                ProgramField field = ((AppInfoWithLiveness)appView.appInfo()).resolveField(info.getField()).getSingleProgramField();
                if (field == null) {
                    return;
                }
                if (!info.hasReflectiveAccess() && !info.isWrittenFromMethodHandle()) {
                    info.forEachWriteContext(context -> this.fieldWrites.computeIfAbsent((DexEncodedMethod)context.getDefinition(), ignore -> new ArrayList()).add(field));
                    this.pendingFieldWrites.put((DexEncodedField)field.getDefinition(), info.getNumberOfWriteContexts());
                }
            });
        }

        void markProcessed(ProgramMethod method, Consumer<ProgramField> allWritesSeenConsumer) {
            List<ProgramField> fieldWritesInMethod = this.fieldWrites.get(method.getDefinition());
            if (fieldWritesInMethod != null) {
                for (ProgramField field : fieldWritesInMethod) {
                    int numberOfPendingFieldWrites = this.pendingFieldWrites.removeInt(field.getDefinition()) - 1;
                    if (numberOfPendingFieldWrites > 0) {
                        this.pendingFieldWrites.put((DexEncodedField)field.getDefinition(), numberOfPendingFieldWrites);
                        continue;
                    }
                    allWritesSeenConsumer.accept(field);
                }
            }
        }
    }
}

