/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.fieldaccess;

import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.ir.code.And;
import com.android.tools.r8.ir.code.FieldInstruction;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.LogicalBinop;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.info.BitAccessInfo;
import com.android.tools.r8.ir.optimize.info.OptimizationFeedback;

public class FieldBitAccessAnalysis {
    private int computeBitsRead(FieldInstruction instruction, DexEncodedField encodedField) {
        Value outValue = instruction.outValue();
        if (outValue.numberOfPhiUsers() > 0) {
            return BitAccessInfo.getAllBitsReadValue();
        }
        int bitsRead = BitAccessInfo.getNoBitsReadValue();
        for (Instruction user : outValue.uniqueUsers()) {
            if (this.isOnlyUsedToUpdateFieldValue(user, encodedField)) continue;
            if (user.isAnd()) {
                And andInstruction = user.asAnd();
                Value other = andInstruction.inValues().get(1 - andInstruction.inValues().indexOf(outValue)).getAliasedValue();
                if (other.isPhi() || !other.definition.isConstNumber()) {
                    return BitAccessInfo.getAllBitsReadValue();
                }
                bitsRead |= other.definition.asConstNumber().getIntValue();
                continue;
            }
            return BitAccessInfo.getAllBitsReadValue();
        }
        return bitsRead;
    }

    private boolean isOnlyUsedToUpdateFieldValue(Instruction user, DexEncodedField encodedField) {
        FieldInstruction fieldInstruction;
        if (user.isLogicalBinop()) {
            LogicalBinop binop = user.asLogicalBinop();
            Value outValue = binop.outValue();
            if (outValue.numberOfPhiUsers() > 0) {
                return false;
            }
            for (Instruction indirectUser : outValue.uniqueUsers()) {
                if (this.isOnlyUsedToUpdateFieldValue(indirectUser, encodedField)) continue;
                return false;
            }
            return true;
        }
        return user.isFieldPut() && (fieldInstruction = user.asFieldInstruction()).getField() == encodedField.getReference();
    }

    public void recordFieldAccess(FieldInstruction instruction, DexEncodedField field, OptimizationFeedback feedback) {
        if (!((DexField)field.getReference()).type.isIntType()) {
            return;
        }
        if (BitAccessInfo.allBitsRead(field.getOptimizationInfo().getReadBits())) {
            return;
        }
        if (instruction.isFieldGet()) {
            feedback.markFieldBitsRead(field, this.computeBitsRead(instruction, field));
        }
    }
}

