/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.fieldvalueanalysis;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.PrunedItems;
import com.android.tools.r8.graph.proto.ArgumentInfoCollection;
import com.android.tools.r8.ir.analysis.fieldvalueanalysis.AbstractFieldSet;
import com.android.tools.r8.ir.analysis.fieldvalueanalysis.EmptyFieldSet;
import com.android.tools.r8.ir.analysis.fieldvalueanalysis.KnownFieldSet;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.SetUtils;
import java.util.Collections;
import java.util.Set;

public class ConcreteMutableFieldSet
extends AbstractFieldSet
implements KnownFieldSet {
    private final Set<DexEncodedField> fields;

    public ConcreteMutableFieldSet() {
        this.fields = Sets.newIdentityHashSet();
    }

    public ConcreteMutableFieldSet(DexEncodedField field) {
        this.fields = SetUtils.newIdentityHashSet(field);
    }

    public void add(DexEncodedField field) {
        this.fields.add(field);
    }

    public ConcreteMutableFieldSet addAll(ConcreteMutableFieldSet other) {
        this.fields.addAll(other.fields);
        return this;
    }

    Set<DexEncodedField> getFields() {
        if (InternalOptions.assertionsEnabled()) {
            return Collections.unmodifiableSet(this.fields);
        }
        return this.fields;
    }

    @Override
    public boolean isConcreteFieldSet() {
        return true;
    }

    @Override
    public ConcreteMutableFieldSet asConcreteFieldSet() {
        return this;
    }

    @Override
    public boolean isKnownFieldSet() {
        return true;
    }

    @Override
    public ConcreteMutableFieldSet asKnownFieldSet() {
        return this;
    }

    @Override
    public boolean contains(DexEncodedField field) {
        return this.fields.contains(field);
    }

    @Override
    public AbstractFieldSet fixupReadSetAfterParametersChanged(AppView<AppInfoWithLiveness> appView, ArgumentInfoCollection argumentInfoCollection) {
        assert (!this.isEmpty());
        if (argumentInfoCollection.isEmpty()) {
            return this;
        }
        AbstractFieldSet newReadSet = EmptyFieldSet.getInstance().fixupReadSetAfterParametersChanged(appView, argumentInfoCollection);
        return newReadSet.isEmpty() ? this : newReadSet.asConcreteFieldSet().addAll(this);
    }

    @Override
    public AbstractFieldSet rewrittenWithLens(AppView<?> appView, GraphLens lens, GraphLens codeLens, PrunedItems prunedItems) {
        assert (!this.isEmpty());
        ConcreteMutableFieldSet rewrittenSet = new ConcreteMutableFieldSet();
        for (DexEncodedField field : this.fields) {
            DexClass holder;
            if (prunedItems.isRemoved((DexField)field.getReference())) continue;
            DexField rewrittenFieldReference = lens.lookupField((DexField)field.getReference());
            DexEncodedField rewrittenField = rewrittenFieldReference.lookupOnClass(holder = appView.definitionForHolder(rewrittenFieldReference));
            if (rewrittenField == null) {
                assert (false);
                continue;
            }
            rewrittenSet.add(rewrittenField);
        }
        return rewrittenSet;
    }

    @Override
    public boolean isEmpty() {
        return this.fields.isEmpty();
    }

    @Override
    public int size() {
        return this.fields.size();
    }

    public int hashCode() {
        return this.fields.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        ConcreteMutableFieldSet concreteFieldSet = (ConcreteMutableFieldSet)other;
        return this.fields.equals(concreteFieldSet.fields);
    }
}

