/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.fieldvalueanalysis;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.graph.ProgramField;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.fieldvalueanalysis.AbstractFieldSet;
import com.android.tools.r8.ir.analysis.fieldvalueanalysis.ConcreteMutableFieldSet;
import com.android.tools.r8.ir.analysis.fieldvalueanalysis.EmptyFieldSet;
import com.android.tools.r8.ir.analysis.fieldvalueanalysis.InstanceFieldValueAnalysis;
import com.android.tools.r8.ir.analysis.fieldvalueanalysis.KnownFieldSet;
import com.android.tools.r8.ir.analysis.fieldvalueanalysis.StaticFieldValueAnalysis;
import com.android.tools.r8.ir.analysis.fieldvalueanalysis.UnknownFieldSet;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.DominatorTree;
import com.android.tools.r8.ir.code.FieldInstruction;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.InvokeDirect;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.ClassInitializerDefaultsOptimization;
import com.android.tools.r8.ir.optimize.info.OptimizationFeedback;
import com.android.tools.r8.ir.optimize.info.field.InstanceFieldInitializationInfo;
import com.android.tools.r8.ir.optimize.info.field.UnknownInstanceFieldInitializationInfo;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.DequeUtils;
import com.android.tools.r8.utils.ListUtils;
import java.util.ArrayList;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public abstract class FieldValueAnalysis {
    final AppView<AppInfoWithLiveness> appView;
    final IRCode code;
    final ProgramMethod context;
    final OptimizationFeedback feedback;
    private DominatorTree dominatorTree;
    private Map<BasicBlock, AbstractFieldSet> fieldsMaybeReadBeforeBlockInclusiveCache;
    final Map<DexEncodedField, List<FieldInitializationInfo>> putsPerField = new IdentityHashMap<DexEncodedField, List<FieldInitializationInfo>>();

    FieldValueAnalysis(AppView<AppInfoWithLiveness> appView, IRCode code, OptimizationFeedback feedback) {
        this.appView = appView;
        this.code = code;
        this.feedback = feedback;
        this.context = code.context();
    }

    private Map<BasicBlock, AbstractFieldSet> getOrCreateFieldsMaybeReadBeforeBlockInclusive() {
        if (this.fieldsMaybeReadBeforeBlockInclusiveCache == null) {
            this.fieldsMaybeReadBeforeBlockInclusiveCache = this.createFieldsMaybeReadBeforeBlockInclusive();
        }
        return this.fieldsMaybeReadBeforeBlockInclusiveCache;
    }

    private boolean fieldMaybeReadBeforeInstruction(DexEncodedField encodedField, Instruction instruction) {
        Instruction current;
        BasicBlock block = instruction.getBlock();
        if (this.fieldMaybeReadBeforeBlock(encodedField, block)) {
            return true;
        }
        InstructionIterator instructionIterator = block.iterator();
        while (instructionIterator.hasNext() && (current = (Instruction)instructionIterator.next()) != instruction) {
            if (!current.readSet(this.appView, this.context).contains(encodedField)) continue;
            return true;
        }
        return false;
    }

    private boolean fieldMaybeReadBeforeBlock(DexEncodedField encodedField, BasicBlock block) {
        for (BasicBlock predecessor : block.getPredecessors()) {
            if (!this.fieldMaybeReadBeforeBlockInclusive(encodedField, predecessor)) continue;
            return true;
        }
        return false;
    }

    private boolean fieldMaybeReadBeforeBlockInclusive(DexEncodedField encodedField, BasicBlock block) {
        return this.getOrCreateFieldsMaybeReadBeforeBlockInclusive().get(block).contains(encodedField);
    }

    private Map<BasicBlock, AbstractFieldSet> createFieldsMaybeReadBeforeBlockInclusive() {
        IdentityHashMap<BasicBlock, AbstractFieldSet> result = new IdentityHashMap<BasicBlock, AbstractFieldSet>();
        Deque<BasicBlock> worklist = DequeUtils.newArrayDeque(this.code.entryBlock());
        while (!worklist.isEmpty()) {
            BasicBlock block = worklist.removeFirst();
            boolean seenBefore = result.containsKey(block);
            AbstractFieldSet readSet = result.computeIfAbsent(block, ignore -> EmptyFieldSet.getInstance());
            if (readSet.isTop()) continue;
            assert (readSet.isKnownFieldSet());
            KnownFieldSet knownReadSet = readSet.asKnownFieldSet();
            int oldSize = seenBefore ? knownReadSet.size() : -1;
            boolean blockOrPredecessorMaybeReadAnyField = false;
            for (BasicBlock predecessor : block.getPredecessors()) {
                AbstractFieldSet predecessorReadSet = result.getOrDefault(predecessor, EmptyFieldSet.getInstance());
                if (predecessorReadSet.isBottom()) continue;
                if (predecessorReadSet.isTop()) {
                    blockOrPredecessorMaybeReadAnyField = true;
                    break;
                }
                assert (predecessorReadSet.isConcreteFieldSet());
                if (!knownReadSet.isConcreteFieldSet()) {
                    knownReadSet = new ConcreteMutableFieldSet();
                }
                knownReadSet.asConcreteFieldSet().addAll(predecessorReadSet.asConcreteFieldSet());
            }
            if (!blockOrPredecessorMaybeReadAnyField) {
                if (seenBefore) {
                    assert (this.verifyFieldSetContainsAllFieldReadsInBlock(knownReadSet, block, this.context));
                } else {
                    for (Instruction instruction : block.getInstructions()) {
                        AbstractFieldSet instructionReadSet = instruction.readSet(this.appView, this.context);
                        if (instructionReadSet.isBottom()) continue;
                        if (instructionReadSet.isTop()) {
                            blockOrPredecessorMaybeReadAnyField = true;
                            break;
                        }
                        if (!knownReadSet.isConcreteFieldSet()) {
                            knownReadSet = new ConcreteMutableFieldSet();
                        }
                        knownReadSet.asConcreteFieldSet().addAll(instructionReadSet.asConcreteFieldSet());
                    }
                }
            }
            boolean changed = false;
            if (blockOrPredecessorMaybeReadAnyField) {
                result.put(block, UnknownFieldSet.getInstance());
                changed = true;
            } else {
                if (knownReadSet != readSet) {
                    result.put(block, knownReadSet.asConcreteFieldSet());
                }
                if (knownReadSet.size() != oldSize) {
                    assert (knownReadSet.size() > oldSize);
                    changed = true;
                }
            }
            if (!changed) continue;
            worklist.addAll(block.getSuccessors());
        }
        return result;
    }

    private boolean verifyFieldSetContainsAllFieldReadsInBlock(KnownFieldSet readSet, BasicBlock block, ProgramMethod context) {
        for (Instruction instruction : block.getInstructions()) {
            AbstractFieldSet instructionReadSet = instruction.readSet(this.appView, context);
            assert (!instructionReadSet.isTop());
            if (instructionReadSet.isBottom()) continue;
            for (DexEncodedField field : instructionReadSet.asConcreteFieldSet().getFields()) {
                assert (readSet.contains(field));
            }
        }
        return true;
    }

    DominatorTree getOrCreateDominatorTree() {
        if (this.dominatorTree == null) {
            this.dominatorTree = new DominatorTree(this.code, DominatorTree.Assumption.NO_UNREACHABLE_BLOCKS);
        }
        return this.dominatorTree;
    }

    boolean isInstanceFieldValueAnalysis() {
        return false;
    }

    InstanceFieldValueAnalysis asInstanceFieldValueAnalysis() {
        return null;
    }

    boolean isStaticFieldValueAnalysis() {
        return false;
    }

    StaticFieldValueAnalysis asStaticFieldValueAnalysis() {
        return null;
    }

    abstract boolean isSubjectToOptimizationIgnoringPinning(DexEncodedField var1);

    abstract boolean isSubjectToOptimization(DexEncodedField var1);

    void recordFieldPut(DexEncodedField field, Instruction instruction) {
        this.recordFieldPut(field, instruction, UnknownInstanceFieldInitializationInfo.getInstance());
    }

    void recordFieldPut(DexEncodedField field, Instruction instruction, InstanceFieldInitializationInfo info) {
        this.putsPerField.computeIfAbsent(field, ignore -> new ArrayList()).add(new FieldInitializationInfo(instruction, info));
    }

    void computeFieldOptimizationInfo(ClassInitializerDefaultsOptimization.ClassInitializerDefaultsResult classInitializerDefaultsResult) {
        AppInfoWithLiveness appInfo = this.appView.appInfo();
        boolean isStraightLineCode = true;
        for (BasicBlock block : this.code.blocks) {
            if (block.getSuccessors().size() >= 2) {
                isStraightLineCode = false;
            }
            for (Instruction instruction : block.getInstructions()) {
                if (instruction.isFieldPut()) {
                    FieldInstruction fieldPut = instruction.asFieldInstruction();
                    DexField field = fieldPut.getField();
                    ProgramField programField = appInfo.resolveField(field).getProgramField();
                    if (programField == null) continue;
                    DexEncodedField encodedField = (DexEncodedField)programField.getDefinition();
                    if (this.isSubjectToOptimization(encodedField)) {
                        this.recordFieldPut(encodedField, fieldPut);
                        continue;
                    }
                    if (!this.isStaticFieldValueAnalysis() || !programField.getHolder().isEnum() || !this.isSubjectToOptimizationIgnoringPinning(encodedField)) continue;
                    this.recordFieldPut(encodedField, fieldPut);
                    continue;
                }
                if (!this.isInstanceFieldValueAnalysis() || !instruction.isInvokeConstructor(this.appView.dexItemFactory())) continue;
                InvokeDirect invoke = instruction.asInvokeDirect();
                this.asInstanceFieldValueAnalysis().analyzeForwardingConstructorCall(invoke, this.code.getThis());
            }
        }
        List<BasicBlock> normalExitBlocks = this.code.computeNormalExitBlocks();
        for (Map.Entry<DexEncodedField, List<FieldInitializationInfo>> entry : this.putsPerField.entrySet()) {
            boolean priorReadsWillReadSameValue;
            DexEncodedField field = entry.getKey();
            List<FieldInitializationInfo> fieldPuts = entry.getValue();
            if (fieldPuts.size() > 1) continue;
            FieldInitializationInfo info = ListUtils.first(fieldPuts);
            Instruction instruction = info.instruction;
            if (instruction.isInvokeDirect()) {
                this.asInstanceFieldValueAnalysis().recordInstanceFieldIsInitializedWithInfo(field, info.instanceFieldInitializationInfo);
                continue;
            }
            FieldInstruction fieldPut = instruction.asFieldInstruction();
            if (!isStraightLineCode && !this.getOrCreateDominatorTree().dominatesAllOf(fieldPut.getBlock(), normalExitBlocks)) continue;
            boolean bl = priorReadsWillReadSameValue = !classInitializerDefaultsResult.hasStaticValue(field) && fieldPut.value().isZero();
            if (!priorReadsWillReadSameValue && this.fieldMaybeReadBeforeInstruction(field, fieldPut)) {
                if (!this.isStaticFieldValueAnalysis()) continue;
                DexValue valueBeforePut = classInitializerDefaultsResult.getStaticValue(field);
                this.asStaticFieldValueAnalysis().updateFieldOptimizationInfoWith2Values(field, fieldPut.value(), valueBeforePut);
                continue;
            }
            this.updateFieldOptimizationInfo(field, fieldPut, fieldPut.value());
        }
    }

    abstract void updateFieldOptimizationInfo(DexEncodedField var1, FieldInstruction var2, Value var3);

    static class FieldInitializationInfo {
        private final Instruction instruction;
        private final InstanceFieldInitializationInfo instanceFieldInitializationInfo;

        FieldInitializationInfo(Instruction instruction, InstanceFieldInitializationInfo instanceFieldInitializationInfo) {
            this.instruction = instruction;
            this.instanceFieldInitializationInfo = instanceFieldInitializationInfo;
        }
    }
}

