/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.fieldvalueanalysis;

import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.fieldvalueanalysis.FieldValueAnalysis;
import com.android.tools.r8.ir.analysis.type.ClassTypeElement;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.analysis.value.AbstractValue;
import com.android.tools.r8.ir.code.Argument;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.FieldInstruction;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.IRCodeUtils;
import com.android.tools.r8.ir.code.InstancePut;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InvokeDirect;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.ClassInitializerDefaultsOptimization;
import com.android.tools.r8.ir.optimize.info.OptimizationFeedback;
import com.android.tools.r8.ir.optimize.info.field.EmptyInstanceFieldInitializationInfoCollection;
import com.android.tools.r8.ir.optimize.info.field.InstanceFieldInitializationInfo;
import com.android.tools.r8.ir.optimize.info.field.InstanceFieldInitializationInfoCollection;
import com.android.tools.r8.ir.optimize.info.field.InstanceFieldInitializationInfoFactory;
import com.android.tools.r8.ir.optimize.info.field.UnknownInstanceFieldInitializationInfo;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.Timing;

public class InstanceFieldValueAnalysis
extends FieldValueAnalysis {
    private final InstanceFieldInitializationInfoCollection.Builder builder = InstanceFieldInitializationInfoCollection.builder();
    private final InstanceFieldInitializationInfoFactory factory;
    private final DexClassAndMethod parentConstructor;
    private final InvokeDirect parentConstructorCall;

    private InstanceFieldValueAnalysis(AppView<AppInfoWithLiveness> appView, IRCode code, OptimizationFeedback feedback, DexClassAndMethod parentConstructor, InvokeDirect parentConstructorCall) {
        super(appView, code, feedback);
        this.factory = appView.instanceFieldInitializationInfoFactory();
        this.parentConstructor = parentConstructor;
        this.parentConstructorCall = parentConstructorCall;
    }

    public static InstanceFieldInitializationInfoCollection run(AppView<?> appView, IRCode code, ClassInitializerDefaultsOptimization.ClassInitializerDefaultsResult classInitializerDefaultsResult, OptimizationFeedback feedback, Timing timing) {
        timing.begin("Analyze instance initializer");
        InstanceFieldInitializationInfoCollection result = InstanceFieldValueAnalysis.run(appView, code, classInitializerDefaultsResult, feedback);
        timing.end();
        return result;
    }

    private static InstanceFieldInitializationInfoCollection run(AppView<?> appView, IRCode code, ClassInitializerDefaultsOptimization.ClassInitializerDefaultsResult classInitializerDefaultsResult, OptimizationFeedback feedback) {
        assert (((AppInfo)appView.appInfo()).hasLiveness());
        assert (appView.enableWholeProgramOptimizations());
        assert (((DexEncodedMethod)code.context().getDefinition()).isInstanceInitializer());
        InvokeDirect parentConstructorCall = IRCodeUtils.getUniqueConstructorInvoke(code.getThis(), appView.dexItemFactory());
        if (parentConstructorCall == null) {
            return EmptyInstanceFieldInitializationInfoCollection.getInstance();
        }
        DexClassAndMethod parentConstructor = parentConstructorCall.lookupSingleTarget(appView, code.context());
        if (parentConstructor == null) {
            return EmptyInstanceFieldInitializationInfoCollection.getInstance();
        }
        InstanceFieldValueAnalysis analysis = new InstanceFieldValueAnalysis(appView.withLiveness(), code, feedback, parentConstructor, parentConstructorCall);
        analysis.computeFieldOptimizationInfo(classInitializerDefaultsResult);
        analysis.analyzeParentConstructorCall();
        return analysis.builder.build();
    }

    private void analyzeParentConstructorCall() {
        if (this.parentConstructor.getHolderType() == this.context.getHolderType()) {
            return;
        }
        InstanceFieldInitializationInfoCollection infos = ((DexEncodedMethod)this.parentConstructor.getDefinition()).getOptimizationInfo().getInstanceInitializerInfo(this.parentConstructorCall).fieldInitializationInfos();
        infos.forEach(this.appView, (field, info) -> {
            if (this.fieldNeverWrittenBetweenParentConstructorCallAndMethodExit((DexEncodedField)field)) {
                if (info.isArgumentInitializationInfo()) {
                    int argumentIndex = info.asArgumentInitializationInfo().getArgumentIndex();
                    this.recordInstanceFieldIsInitializedWithValue((DexEncodedField)field, this.parentConstructorCall.getArgument(argumentIndex));
                } else {
                    assert (info.isSingleValue() || info.isTypeInitializationInfo());
                    this.builder.recordInitializationInfo((DexEncodedField)field, (InstanceFieldInitializationInfo)info);
                }
            }
        });
    }

    private InstanceFieldInitializationInfo getInstanceFieldInitializationInfo(DexEncodedField field, Value value) {
        Value root = value.getAliasedValue();
        if (root.isDefinedByInstructionSatisfying(Instruction::isArgument)) {
            Argument argument = root.definition.asArgument();
            return this.factory.createArgumentInitializationInfo(argument.getIndex());
        }
        AbstractValue abstractValue = value.getAbstractValue(this.appView, this.context);
        if (abstractValue.isSingleValue()) {
            return abstractValue.asSingleValue();
        }
        DexType fieldType = field.type();
        if (fieldType.isClassType()) {
            ClassTypeElement dynamicLowerBoundType = value.getDynamicLowerBoundType(this.appView);
            TypeElement dynamicUpperBoundType = value.getDynamicUpperBoundType(this.appView);
            TypeElement staticFieldType = TypeElement.fromDexType(fieldType, Nullability.maybeNull(), this.appView);
            if (dynamicLowerBoundType != null || !dynamicUpperBoundType.equals(staticFieldType)) {
                return this.factory.createTypeInitializationInfo(dynamicLowerBoundType, dynamicUpperBoundType);
            }
        }
        return UnknownInstanceFieldInitializationInfo.getInstance();
    }

    private boolean fieldNeverWrittenBetweenInstancePutAndMethodExit(DexEncodedField field, InstancePut instancePut) {
        if (field.isFinal()) {
            return true;
        }
        if (((AppInfoWithLiveness)this.appView.appInfo()).isFieldOnlyWrittenInMethod(field, (DexEncodedMethod)this.context.getDefinition())) {
            return true;
        }
        if (((AppInfoWithLiveness)this.appView.appInfo()).isInstanceFieldWrittenOnlyInInstanceInitializers(field)) {
            BasicBlock parentConstructorCallBlock;
            if (this.parentConstructorCall.getInvokedMethod().holder != this.context.getHolderType()) {
                return true;
            }
            BasicBlock instancePutBlock = instancePut.getBlock();
            if (instancePutBlock != (parentConstructorCallBlock = this.parentConstructorCall.getBlock())) {
                return this.getOrCreateDominatorTree().dominatedBy(instancePutBlock, parentConstructorCallBlock);
            }
            for (Instruction instruction : instancePutBlock.getInstructions()) {
                if (instruction == instancePut) {
                    return false;
                }
                if (instruction != this.parentConstructorCall) continue;
                return true;
            }
            throw new Unreachable();
        }
        return false;
    }

    private boolean fieldNeverWrittenBetweenParentConstructorCallAndMethodExit(DexEncodedField field) {
        if (field.isFinal()) {
            return true;
        }
        return ((AppInfoWithLiveness)this.appView.appInfo()).isFieldOnlyWrittenInMethod(field, (DexEncodedMethod)this.parentConstructor.getDefinition());
    }

    @Override
    boolean isInstanceFieldValueAnalysis() {
        return true;
    }

    @Override
    InstanceFieldValueAnalysis asInstanceFieldValueAnalysis() {
        return this;
    }

    @Override
    boolean isSubjectToOptimization(DexEncodedField field) {
        return !field.isStatic() && field.getHolderType() == this.context.getHolderType();
    }

    @Override
    boolean isSubjectToOptimizationIgnoringPinning(DexEncodedField field) {
        throw new Unreachable("Used by static analysis only.");
    }

    @Override
    void updateFieldOptimizationInfo(DexEncodedField field, FieldInstruction fieldPut, Value value) {
        if (this.fieldNeverWrittenBetweenInstancePutAndMethodExit(field, fieldPut.asInstancePut())) {
            this.recordInstanceFieldIsInitializedWithValue(field, value);
        }
    }

    void analyzeForwardingConstructorCall(InvokeDirect invoke, Value thisValue) {
        if (invoke.getReceiver() != thisValue || invoke.getInvokedMethod().getHolderType() != this.context.getHolderType()) {
            return;
        }
        ProgramMethod singleTarget = invoke.lookupSingleProgramTarget(this.appView, this.context);
        if (singleTarget == null) {
            return;
        }
        InstanceFieldInitializationInfoCollection infos = ((DexEncodedMethod)singleTarget.getDefinition()).getOptimizationInfo().getInstanceInitializerInfo(invoke).fieldInitializationInfos();
        for (DexEncodedField field : singleTarget.getHolder().getDirectAndIndirectInstanceFields(this.appView)) {
            InstanceFieldInitializationInfo info = infos.get(field);
            if (info.isArgumentInitializationInfo()) {
                int argumentIndex = info.asArgumentInitializationInfo().getArgumentIndex();
                info = this.getInstanceFieldInitializationInfo(field, invoke.getArgument(argumentIndex));
            }
            this.recordFieldPut(field, invoke, info);
        }
    }

    void recordInstanceFieldIsInitializedWithInfo(DexEncodedField field, InstanceFieldInitializationInfo info) {
        if (!info.isUnknown()) {
            this.builder.recordInitializationInfo(field, info);
        }
    }

    void recordInstanceFieldIsInitializedWithValue(DexEncodedField field, Value value) {
        this.recordInstanceFieldIsInitializedWithInfo(field, this.getInstanceFieldInitializationInfo(field, value));
    }
}

