/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.fieldvalueanalysis;

import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMember;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.ir.analysis.fieldvalueanalysis.FieldValueAnalysis;
import com.android.tools.r8.ir.analysis.fieldvalueanalysis.StaticFieldValues;
import com.android.tools.r8.ir.analysis.type.DynamicTypeWithUpperBound;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.value.AbstractValue;
import com.android.tools.r8.ir.analysis.value.AbstractValueFactory;
import com.android.tools.r8.ir.analysis.value.NullOrAbstractValue;
import com.android.tools.r8.ir.analysis.value.SingleFieldValue;
import com.android.tools.r8.ir.analysis.value.UnknownValue;
import com.android.tools.r8.ir.analysis.value.objectstate.EnumValuesObjectState;
import com.android.tools.r8.ir.analysis.value.objectstate.ObjectState;
import com.android.tools.r8.ir.analysis.value.objectstate.ObjectStateAnalysis;
import com.android.tools.r8.ir.code.ArrayPut;
import com.android.tools.r8.ir.code.FieldInstruction;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InvokeDirect;
import com.android.tools.r8.ir.code.NewArrayEmpty;
import com.android.tools.r8.ir.code.NewInstance;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.ClassInitializerDefaultsOptimization;
import com.android.tools.r8.ir.optimize.info.OptimizationFeedback;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.Timing;
import java.util.IdentityHashMap;
import java.util.Map;

public class StaticFieldValueAnalysis
extends FieldValueAnalysis {
    private final StaticFieldValues.Builder builder;
    private final Map<Value, AbstractValue> computedValues = new IdentityHashMap<Value, AbstractValue>();

    private StaticFieldValueAnalysis(AppView<AppInfoWithLiveness> appView, IRCode code, OptimizationFeedback feedback) {
        super(appView, code, feedback);
        this.builder = StaticFieldValues.builder(code.context().getHolder());
    }

    public static StaticFieldValues run(AppView<?> appView, IRCode code, ClassInitializerDefaultsOptimization.ClassInitializerDefaultsResult classInitializerDefaultsResult, OptimizationFeedback feedback, Timing timing) {
        assert (((AppInfo)appView.appInfo()).hasLiveness());
        assert (appView.enableWholeProgramOptimizations());
        assert (((DexEncodedMethod)code.context().getDefinition()).isClassInitializer());
        timing.begin("Analyze class initializer");
        StaticFieldValues result = new StaticFieldValueAnalysis(appView.withLiveness(), code, feedback).analyze(classInitializerDefaultsResult);
        timing.end();
        return result;
    }

    private AbstractValue getOrComputeAbstractValue(Value value, DexEncodedField field) {
        Value root = value.getAliasedValue();
        AbstractValue abstractValue = root.getAbstractValue(this.appView, this.context);
        if (!abstractValue.isSingleValue()) {
            return this.computeSingleFieldValue(field, root);
        }
        return abstractValue;
    }

    private SingleFieldValue computeSingleFieldValue(DexEncodedField field, Value value) {
        assert (!value.hasAliasedValue());
        SingleFieldValue result = this.computeSingleEnumFieldValue(value);
        if (result != null) {
            return result;
        }
        return this.appView.abstractValueFactory().createSingleFieldValue((DexField)field.getReference(), this.computeObjectState(value));
    }

    private SingleFieldValue computeSingleEnumFieldValue(Value value) {
        if (!this.context.getHolder().isEnum()) {
            return null;
        }
        assert (!value.hasAliasedValue());
        if (value.isPhi()) {
            return null;
        }
        if (value.definition.isNewArrayEmpty()) {
            return this.computeSingleEnumFieldValueForValuesArray(value);
        }
        if (value.definition.isNewInstance()) {
            return this.computeSingleEnumFieldValueForInstance(value);
        }
        return null;
    }

    private SingleFieldValue computeSingleEnumFieldValueForValuesArray(Value value) {
        if (!value.definition.isNewArrayEmpty()) {
            return null;
        }
        AbstractValue valuesValue = this.computedValues.get(value);
        if (valuesValue != null) {
            SingleFieldValue fieldValue;
            if (valuesValue.isSingleFieldValue() && (fieldValue = valuesValue.asSingleFieldValue()).getObjectState().isEnumValuesObjectState()) {
                return fieldValue;
            }
            return null;
        }
        SingleFieldValue singleFieldValue = this.internalComputeSingleEnumFieldValueForValuesArray(value);
        this.computedValues.put(value, singleFieldValue == null ? UnknownValue.getInstance() : singleFieldValue);
        return singleFieldValue;
    }

    private SingleFieldValue internalComputeSingleEnumFieldValueForValuesArray(Value value) {
        assert (value.isDefinedByInstructionSatisfying(Instruction::isNewArrayEmpty));
        NewArrayEmpty newArrayEmpty = value.definition.asNewArrayEmpty();
        if (newArrayEmpty.type.toBaseType(this.appView.dexItemFactory()) != this.context.getHolder().type) {
            return null;
        }
        if (value.hasDebugUsers() || value.hasPhiUsers()) {
            return null;
        }
        if (!newArrayEmpty.size().isConstNumber()) {
            return null;
        }
        int valuesSize = newArrayEmpty.size().getConstInstruction().asConstNumber().getIntValue();
        if (valuesSize == 0) {
            return null;
        }
        ObjectState[] valuesState = new ObjectState[valuesSize];
        DexEncodedMember valuesField = null;
        block5: for (Instruction user : value.aliasedUsers()) {
            switch (user.opcode()) {
                case 8: {
                    ArrayPut arrayPut = user.asArrayPut();
                    if (arrayPut.array() != value) {
                        return null;
                    }
                    if (!arrayPut.index().isConstNumber()) {
                        return null;
                    }
                    int index = arrayPut.index().getConstInstruction().asConstNumber().getIntValue();
                    if (index < 0 || index >= valuesSize) {
                        return null;
                    }
                    ObjectState objectState = this.computeEnumInstanceObjectState(arrayPut.value());
                    if (objectState == null || objectState.isEmpty()) {
                        return null;
                    }
                    if (!this.valuesArrayIndexMatchesOrdinal(index, objectState)) {
                        return null;
                    }
                    if (valuesState[index] != null) {
                        return null;
                    }
                    valuesState[index] = objectState;
                    continue block5;
                }
                case 9: {
                    if (!user.outValue().hasPhiUsers()) continue block5;
                    return null;
                }
                case 60: {
                    DexEncodedField field = this.context.getHolder().lookupStaticField(user.asStaticPut().getField());
                    if (field == null) {
                        return null;
                    }
                    if (valuesField != null) {
                        return null;
                    }
                    valuesField = field;
                    continue block5;
                }
            }
            return null;
        }
        if (valuesField == null) {
            return null;
        }
        for (ObjectState objectState : valuesState) {
            if (objectState != null) continue;
            return null;
        }
        return this.appView.abstractValueFactory().createSingleFieldValue((DexField)valuesField.getReference(), new EnumValuesObjectState(valuesState));
    }

    private ObjectState computeEnumInstanceObjectState(Value value) {
        Value root = value.getAliasedValue();
        if (root.isPhi()) {
            return ObjectState.empty();
        }
        Instruction definition = root.getDefinition();
        if (definition.isNewInstance()) {
            return this.computeObjectState(definition.outValue());
        }
        if (definition.isStaticGet()) {
            return ObjectState.empty();
        }
        return ObjectState.empty();
    }

    private boolean valuesArrayIndexMatchesOrdinal(int ordinal, ObjectState objectState) {
        DexEncodedField ordinalField = ((AppInfoWithLiveness)this.appView.appInfo()).resolveField(this.appView.dexItemFactory().enumMembers.ordinalField, this.context).getResolvedField();
        if (ordinalField == null) {
            return false;
        }
        AbstractValue ordinalState = objectState.getAbstractFieldValue(ordinalField);
        if (ordinalState == null || !ordinalState.isSingleNumberValue()) {
            return false;
        }
        int intValue = ordinalState.asSingleNumberValue().getIntValue();
        return intValue == ordinal;
    }

    private SingleFieldValue computeSingleEnumFieldValueForInstance(Value value) {
        DexClass dexClass;
        assert (value.isDefinedByInstructionSatisfying(Instruction::isNewInstance));
        NewInstance newInstance = value.definition.asNewInstance();
        if (newInstance.clazz != this.context.getHolderType() && ((dexClass = this.appView.definitionFor(newInstance.clazz)) == null || dexClass.superType != this.context.getHolderType())) {
            return null;
        }
        if (value.hasDebugUsers() || value.hasPhiUsers()) {
            return null;
        }
        DexEncodedMember enumField = null;
        block5: for (Instruction user : value.uniqueUsers()) {
            switch (user.opcode()) {
                case 8: {
                    ArrayPut arrayPut = user.asArrayPut();
                    if (arrayPut.value().getAliasedValue() == value && this.isEnumValuesArray(arrayPut.array())) continue block5;
                    return null;
                }
                case 33: {
                    InvokeDirect invoke = user.asInvokeDirect();
                    if (this.appView.dexItemFactory().isConstructor(invoke.getInvokedMethod()) && invoke.getReceiver() == value) continue block5;
                    return null;
                }
                case 60: {
                    DexEncodedField field = this.context.getHolder().lookupStaticField(user.asStaticPut().getField());
                    if (field == null || !field.accessFlags.isEnum()) continue block5;
                    if (enumField != null) {
                        return null;
                    }
                    enumField = field;
                    continue block5;
                }
            }
            return null;
        }
        if (enumField == null) {
            return null;
        }
        return this.appView.abstractValueFactory().createSingleFieldValue((DexField)enumField.getReference(), this.computeObjectState(value));
    }

    private ObjectState computeObjectState(Value value) {
        return ObjectStateAnalysis.computeObjectState(value, this.appView, this.context);
    }

    private boolean isEnumValuesArray(Value value) {
        SingleFieldValue singleFieldValue = this.computeSingleEnumFieldValueForValuesArray(value);
        return singleFieldValue != null && singleFieldValue.getObjectState().isEnumValuesObjectState();
    }

    @Override
    boolean isStaticFieldValueAnalysis() {
        return true;
    }

    @Override
    StaticFieldValueAnalysis asStaticFieldValueAnalysis() {
        return this;
    }

    StaticFieldValues analyze(ClassInitializerDefaultsOptimization.ClassInitializerDefaultsResult classInitializerDefaultsResult) {
        this.computeFieldOptimizationInfo(classInitializerDefaultsResult);
        return this.builder.build();
    }

    @Override
    void computeFieldOptimizationInfo(ClassInitializerDefaultsOptimization.ClassInitializerDefaultsResult classInitializerDefaultsResult) {
        super.computeFieldOptimizationInfo(classInitializerDefaultsResult);
        classInitializerDefaultsResult.forEachOptimizedField((field, value) -> {
            if (this.putsPerField.containsKey(field) || !((AppInfoWithLiveness)this.appView.appInfo()).isFieldOnlyWrittenInMethod((DexEncodedField)field, (DexEncodedMethod)this.context.getDefinition())) {
                return;
            }
            AbstractValueFactory factory = this.appView.abstractValueFactory();
            if (value.isDexValueNumber()) {
                this.feedback.recordFieldHasAbstractValue((DexEncodedField)field, this.appView, factory.createSingleNumberValue(value.asDexValueNumber().getRawValue()));
            } else if (value.isDexValueString()) {
                this.feedback.recordFieldHasAbstractValue((DexEncodedField)field, this.appView, factory.createSingleStringValue((DexString)value.asDexValueString().getValue()));
            } else if (!value.isDexItemBasedValueString()) assert (false) : value.getClass().getName();
        });
    }

    @Override
    boolean isSubjectToOptimization(DexEncodedField field) {
        return field.isStatic() && field.getHolderType() == this.context.getHolderType() && ((AppInfoWithLiveness)this.appView.appInfo()).isFieldOnlyWrittenInMethod(field, (DexEncodedMethod)this.context.getDefinition());
    }

    @Override
    boolean isSubjectToOptimizationIgnoringPinning(DexEncodedField field) {
        return field.isStatic() && field.getHolderType() == this.context.getHolderType() && ((AppInfoWithLiveness)this.appView.appInfo()).isFieldOnlyWrittenInMethodIgnoringPinning(field, (DexEncodedMethod)this.context.getDefinition());
    }

    @Override
    void updateFieldOptimizationInfo(DexEncodedField field, FieldInstruction fieldPut, Value value) {
        AbstractValue abstractValue = this.getOrComputeAbstractValue(value, field);
        this.updateFieldOptimizationInfo(field, value, abstractValue, false);
    }

    void updateFieldOptimizationInfo(DexEncodedField field, Value value, AbstractValue abstractValue, boolean maybeNull) {
        this.builder.recordStaticField(field, abstractValue, this.appView.dexItemFactory());
        if (((AppInfoWithLiveness)this.appView.appInfo()).isPinned(field)) {
            return;
        }
        this.feedback.recordFieldHasAbstractValue(field, this.appView, abstractValue);
        if (field.getType().isReferenceType()) {
            DynamicTypeWithUpperBound staticType = field.getType().toDynamicType(this.appView);
            DynamicTypeWithUpperBound dynamicType = value.getDynamicType(this.appView);
            if (dynamicType.strictlyLessThan(staticType, this.appView)) {
                if (maybeNull && dynamicType.getNullability().isDefinitelyNotNull()) {
                    assert (dynamicType.getDynamicUpperBoundType().isReferenceType());
                    dynamicType = dynamicType.withNullability(Nullability.maybeNull());
                }
                this.feedback.markFieldHasDynamicType(field, dynamicType);
            }
        }
    }

    public void updateFieldOptimizationInfoWith2Values(DexEncodedField field, Value valuePut, DexValue valueBeforePut) {
        if (valueBeforePut != DexValue.DexValueNull.NULL) {
            return;
        }
        AbstractValue abstractValue = NullOrAbstractValue.create(this.getOrComputeAbstractValue(valuePut, field));
        this.updateFieldOptimizationInfo(field, valuePut, abstractValue, true);
    }
}

