/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.inlining;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.proto.ArgumentInfoCollection;
import com.android.tools.r8.graph.proto.RemovedArgumentInfo;
import com.android.tools.r8.ir.analysis.inlining.AlwaysSimpleInliningConstraint;
import com.android.tools.r8.ir.analysis.inlining.NeverSimpleInliningConstraint;
import com.android.tools.r8.ir.analysis.inlining.SimpleInliningArgumentConstraint;
import com.android.tools.r8.ir.analysis.inlining.SimpleInliningConstraint;
import com.android.tools.r8.ir.analysis.inlining.SimpleInliningConstraintFactory;
import com.android.tools.r8.ir.analysis.value.SingleValue;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.shaking.AppInfoWithLiveness;

public class EqualToBooleanSimpleInliningConstraint
extends SimpleInliningArgumentConstraint {
    private final boolean value;

    private EqualToBooleanSimpleInliningConstraint(int argumentIndex, boolean value) {
        super(argumentIndex);
        this.value = value;
    }

    static EqualToBooleanSimpleInliningConstraint create(int argumentIndex, boolean value, SimpleInliningConstraintFactory witness) {
        assert (witness != null);
        return new EqualToBooleanSimpleInliningConstraint(argumentIndex, value);
    }

    @Override
    public SimpleInliningConstraint fixupAfterParametersChanged(AppView<AppInfoWithLiveness> appView, ArgumentInfoCollection changes, SimpleInliningConstraintFactory factory) {
        if (changes.isArgumentRemoved(this.getArgumentIndex())) {
            RemovedArgumentInfo removedArgumentInfo = changes.getArgumentInfo(this.getArgumentIndex()).asRemovedArgumentInfo();
            if (!removedArgumentInfo.hasSingleValue()) {
                assert (false);
                return NeverSimpleInliningConstraint.getInstance();
            }
            SingleValue singleValue = removedArgumentInfo.getSingleValue();
            return singleValue.isSingleNumberValue() && singleValue.asSingleNumberValue().getBooleanValue() == this.value ? AlwaysSimpleInliningConstraint.getInstance() : NeverSimpleInliningConstraint.getInstance();
        }
        assert (!changes.hasArgumentInfo(this.getArgumentIndex()));
        return this.withArgumentIndex(changes.getNewArgumentIndex(this.getArgumentIndex()), factory);
    }

    @Override
    public boolean isSatisfied(InvokeMethod invoke) {
        Value argumentRoot = this.getArgument(invoke).getAliasedValue();
        return argumentRoot.isDefinedByInstructionSatisfying(Instruction::isConstNumber) && argumentRoot.getDefinition().asConstNumber().getBooleanValue() == this.value;
    }

    @Override
    SimpleInliningArgumentConstraint withArgumentIndex(int argumentIndex, SimpleInliningConstraintFactory factory) {
        return factory.createEqualToBooleanConstraint(argumentIndex, this.value);
    }
}

