/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.proto;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.proto.ProtoReferences;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import java.util.Set;

public class EnumLiteProtoShrinker {
    private AppView<AppInfoWithLiveness> appView;
    private ProtoReferences references;
    private Set<DexType> deadEnumLiteMaps = Sets.newIdentityHashSet();

    public EnumLiteProtoShrinker(AppView<AppInfoWithLiveness> appView, ProtoReferences references) {
        this.appView = appView;
        this.references = references;
    }

    private DexField createInternalValueMapField(DexType holder) {
        return this.appView.dexItemFactory().createField(holder, this.references.enumLiteMapType, this.references.internalValueMapFieldName);
    }

    private void internalClearDeadEnumLiteMaps() {
        for (DexProgramClass clazz : this.appView.appInfo().classes()) {
            if (!this.isDeadEnumLiteMap(clazz)) continue;
            this.deadEnumLiteMaps.add(clazz.getType());
            clazz.setVirtualMethods(DexEncodedMethod.EMPTY_ARRAY);
        }
    }

    private DexProgramClass computeCorrespondingEnumLite(DexProgramClass enumLiteMap) {
        if (enumLiteMap.getMethodCollection().numberOfVirtualMethods() != 2) {
            return null;
        }
        DexType enumLiteCandidate = null;
        for (DexEncodedMethod virtualMethod : enumLiteMap.virtualMethods()) {
            if (!this.matchesFindValueByNumberMethod((DexMethod)virtualMethod.getReference())) {
                return null;
            }
            if (virtualMethod.returnType() == this.references.enumLiteType) continue;
            if (enumLiteCandidate != null) {
                return null;
            }
            enumLiteCandidate = virtualMethod.returnType();
        }
        if (enumLiteCandidate == null) {
            return null;
        }
        DexProgramClass enumLite = this.appView.programDefinitionFor(enumLiteCandidate, enumLiteMap);
        if (enumLite != null && enumLite.isEnum() && enumLite.interfaces.contains(this.references.enumLiteType)) {
            return enumLite;
        }
        return null;
    }

    private boolean matchesFindValueByNumberMethod(DexMethod method) {
        return method.name == this.references.findValueByNumberName && method.getArity() == 1 && method.getParameters().values[0] == this.appView.dexItemFactory().intType;
    }

    public Set<DexType> getDeadEnumLiteMaps() {
        return this.deadEnumLiteMaps;
    }

    public void clearDeadEnumLiteMaps() {
        assert (this.appView.options().protoShrinking().isEnumLiteProtoShrinkingEnabled());
        if (!this.appView.options().enableEnumUnboxing) {
            return;
        }
        if (!this.appView.options().isShrinking()) {
            return;
        }
        this.internalClearDeadEnumLiteMaps();
    }

    public boolean isDeadEnumLiteMap(DexProgramClass clazz) {
        DexProgramClass enumLite;
        if (clazz.getInterfaces().contains(this.references.enumLiteMapType) && (enumLite = this.computeCorrespondingEnumLite(clazz)) != null) {
            DexEncodedField field = enumLite.lookupField(this.createInternalValueMapField(enumLite.getType()));
            return field != null && this.appView.appInfo().isStaticFieldWrittenOnlyInEnclosingStaticInitializer(field) && !this.appView.appInfo().isFieldRead(field);
        }
        return false;
    }

    public void verifyDeadEnumLiteMapsAreDead() {
        for (DexType deadEnumLiteMap : this.deadEnumLiteMaps) {
            if (this.appView.appInfo().definitionForWithoutExistenceAssert(deadEnumLiteMap) == null) continue;
            throw new CompilationError("EnumLite Proto Shrinker failure: Type " + deadEnumLiteMap + " was assumed to be dead during optimizations, but it is not.");
        }
    }
}

