/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.proto;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.SubtypingInfo;
import com.android.tools.r8.graph.analysis.EnqueuerAnalysis;
import com.android.tools.r8.ir.analysis.proto.ProtoInliningReasonStrategy;
import com.android.tools.r8.ir.analysis.proto.ProtoReferences;
import com.android.tools.r8.ir.analysis.type.ClassTypeElement;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeAnalysis;
import com.android.tools.r8.ir.code.CheckCast;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InvokeDirect;
import com.android.tools.r8.ir.code.InvokeVirtual;
import com.android.tools.r8.ir.code.NewInstance;
import com.android.tools.r8.ir.code.SafeCheckCast;
import com.android.tools.r8.ir.code.StaticGet;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.IRConverter;
import com.android.tools.r8.ir.conversion.MethodProcessor;
import com.android.tools.r8.ir.conversion.callgraph.Node;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.enums.EnumValueOptimizer;
import com.android.tools.r8.ir.optimize.info.OptimizationFeedback;
import com.android.tools.r8.ir.optimize.info.OptimizationFeedbackSimple;
import com.android.tools.r8.ir.optimize.inliner.FixedInliningReasonStrategy;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.shaking.EnqueuerWorklist;
import com.android.tools.r8.utils.ObjectUtils;
import com.android.tools.r8.utils.PredicateSet;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.Timing;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.BooleanSupplier;

public class GeneratedMessageLiteBuilderShrinker {
    private final AppView<? extends AppInfoWithClassHierarchy> appView;
    private final ProtoReferences references;
    private final boolean enableAggressiveBuilderOptimization;
    private final Map<DexProgramClass, ProgramMethod> builders = new IdentityHashMap<DexProgramClass, ProgramMethod>();

    GeneratedMessageLiteBuilderShrinker(AppView<? extends AppInfoWithClassHierarchy> appView, ProtoReferences references) {
        this.appView = appView;
        this.references = references;
        this.enableAggressiveBuilderOptimization = this.computeEnableAggressiveBuilderOptimization();
        assert (this.enableAggressiveBuilderOptimization);
    }

    private boolean computeEnableAggressiveBuilderOptimization() {
        DexClass generatedMessageLiteBuilderClass = this.appView.appInfo().definitionForWithoutExistenceAssert(this.references.generatedMessageLiteBuilderType);
        DexClass generatedMessageLiteExtendableBuilderClass = this.appView.appInfo().definitionForWithoutExistenceAssert(this.references.generatedMessageLiteExtendableBuilderType);
        if (generatedMessageLiteBuilderClass == null && generatedMessageLiteExtendableBuilderClass == null) {
            return false;
        }
        boolean unexpectedGeneratedMessageLiteBuilder = ObjectUtils.getBooleanOrElse(generatedMessageLiteBuilderClass, clazz -> clazz.getMethodCollection().hasMethods(DexEncodedMethod::isAbstract), true);
        if (unexpectedGeneratedMessageLiteBuilder) {
            this.appView.options().reporter.warning("Unexpected implementation of `" + this.references.generatedMessageLiteBuilderType.toSourceString() + "`: disabling aggressive protobuf builder optimization.");
            return false;
        }
        boolean unexpectedGeneratedMessageLiteExtendableBuilder = ObjectUtils.getBooleanOrElse(generatedMessageLiteExtendableBuilderClass, clazz -> clazz.getMethodCollection().hasMethods(DexEncodedMethod::isAbstract), true);
        if (unexpectedGeneratedMessageLiteExtendableBuilder) {
            this.appView.options().reporter.warning("Unexpected implementation of `" + this.references.generatedMessageLiteExtendableBuilderType.toSourceString() + "`: disabling aggressive protobuf builder optimization.");
            return false;
        }
        return true;
    }

    private void rewriteDeadBuilderReferencesFromDynamicMethod(AppView<AppInfoWithLiveness> appView, DexProgramClass builder, ProgramMethod dynamicMethod, IRConverter converter) {
        IRCode code = dynamicMethod.buildIR(appView);
        InstructionListIterator instructionIterator = code.instructionListIterator();
        assert (builder.superType == this.references.generatedMessageLiteBuilderType || builder.superType == this.references.generatedMessageLiteExtendableBuilderType);
        DexField defaultInstanceField = this.references.getDefaultInstanceField(dynamicMethod.getHolder());
        Value builderValue = code.createValue(ClassTypeElement.create(builder.superType, Nullability.definitelyNotNull(), appView));
        Value defaultInstanceValue = code.createValue(ClassTypeElement.create(defaultInstanceField.type, Nullability.maybeNull(), appView));
        NewInstance newInstance = (NewInstance)instructionIterator.nextUntil(instruction -> instruction.isNewInstance() && instruction.asNewInstance().clazz == builder.type);
        assert (newInstance != null);
        instructionIterator.replaceCurrentInstruction(new NewInstance(builder.superType, builderValue));
        InvokeDirect constructorInvoke = (InvokeDirect)instructionIterator.nextUntil(instruction -> {
            assert (instruction.isInvokeDirect() || instruction.isConstNumber());
            return instruction.isInvokeDirect();
        });
        assert (constructorInvoke != null);
        instructionIterator.replaceCurrentInstruction(new StaticGet(defaultInstanceValue, defaultInstanceField));
        instructionIterator.setInsertionPosition(constructorInvoke.getPosition());
        instructionIterator.add(new InvokeDirect(builder.superType == this.references.generatedMessageLiteBuilderType ? this.references.generatedMessageLiteBuilderMethods.constructorMethod : this.references.generatedMessageLiteExtendableBuilderMethods.constructorMethod, null, ImmutableList.of(builderValue, defaultInstanceValue)));
        converter.removeDeadCodeAndFinalizeIR(code, OptimizationFeedbackSimple.getInstance(), Timing.empty());
    }

    public static void addInliningHeuristicsForBuilderInlining(AppView<? extends AppInfoWithClassHierarchy> appView, SubtypingInfo subtypingInfo, PredicateSet<DexType> alwaysClassInline, Set<DexType> neverMergeClassVertically, Set<DexType> neverMergeClassHorizontally, Set<DexMethod> alwaysInline, Set<DexMethod> bypassClinitforInlining) {
        new RootSetExtension(appView, alwaysClassInline, neverMergeClassVertically, neverMergeClassHorizontally, alwaysInline, bypassClinitforInlining).extend(subtypingInfo);
    }

    private void strengthenCheckCastInstructions(IRCode code) {
        CheckCast checkCast;
        Set<Value> affectedValues = Sets.newIdentityHashSet();
        InstructionListIterator instructionIterator = code.instructionListIterator();
        while ((checkCast = (CheckCast)instructionIterator.nextUntil(Instruction::isCheckCast)) != null) {
            DexType rawReceiverType;
            AppInfoWithClassHierarchy appInfo;
            ClassTypeElement receiverType;
            InvokeVirtual invoke;
            DexMethod invokedMethod;
            Value root;
            if (checkCast.getType() != this.references.generatedMessageLiteType || (root = checkCast.object().getAliasedValue()).isPhi() || !root.definition.isInvokeVirtual() || !this.references.isDynamicMethod(invokedMethod = (invoke = root.definition.asInvokeVirtual()).getInvokedMethod()) && !this.references.isDynamicMethodBridge(invokedMethod)) continue;
            assert (invokedMethod.proto.parameters.values[0] == this.references.methodToInvokeType);
            Value methodToInvokeValue = invoke.arguments().get(1);
            if (!this.references.methodToInvokeMembers.isNewMutableInstanceEnum(methodToInvokeValue) || (receiverType = invoke.getReceiver().getDynamicUpperBoundType(this.appView).asClassType()) == null || !(appInfo = this.appView.appInfo()).isStrictSubtypeOf(rawReceiverType = receiverType.getClassType(), this.references.generatedMessageLiteType)) continue;
            Value dest = code.createValue(receiverType.asMaybeNull(), checkCast.getLocalInfo());
            SafeCheckCast replacement = new SafeCheckCast(dest, checkCast.object(), rawReceiverType);
            instructionIterator.replaceCurrentInstruction(replacement, affectedValues);
        }
        if (!affectedValues.isEmpty()) {
            new TypeAnalysis(this.appView).narrowing(affectedValues);
        }
    }

    public EnqueuerAnalysis createEnqueuerAnalysis() {
        final Set seen = Sets.newIdentityHashSet();
        return new EnqueuerAnalysis(){

            @Override
            public void notifyFixpoint(Enqueuer enqueuer, EnqueuerWorklist worklist, Timing timing) {
                GeneratedMessageLiteBuilderShrinker.this.builders.forEach((builder, dynamicMethod) -> {
                    if (seen.add(builder)) {
                        DexProgramClass superClass = DexProgramClass.asProgramClassOrNull(GeneratedMessageLiteBuilderShrinker.this.appView.definitionFor(builder.superType));
                        assert (superClass != null);
                        superClass.accessFlags.demoteFromAbstract();
                        if (superClass.type == ((GeneratedMessageLiteBuilderShrinker)GeneratedMessageLiteBuilderShrinker.this).references.generatedMessageLiteBuilderType) {
                            worklist.enqueueTraceNewInstanceAction(((GeneratedMessageLiteBuilderShrinker)GeneratedMessageLiteBuilderShrinker.this).references.generatedMessageLiteBuilderType, (ProgramMethod)dynamicMethod);
                            worklist.enqueueTraceInvokeDirectAction(((GeneratedMessageLiteBuilderShrinker)GeneratedMessageLiteBuilderShrinker.this).references.generatedMessageLiteBuilderMethods.constructorMethod, (ProgramMethod)dynamicMethod);
                        } else {
                            assert (superClass.type == ((GeneratedMessageLiteBuilderShrinker)GeneratedMessageLiteBuilderShrinker.this).references.generatedMessageLiteExtendableBuilderType);
                            worklist.enqueueTraceNewInstanceAction(((GeneratedMessageLiteBuilderShrinker)GeneratedMessageLiteBuilderShrinker.this).references.generatedMessageLiteExtendableBuilderType, (ProgramMethod)dynamicMethod);
                            worklist.enqueueTraceInvokeDirectAction(((GeneratedMessageLiteBuilderShrinker)GeneratedMessageLiteBuilderShrinker.this).references.generatedMessageLiteExtendableBuilderMethods.constructorMethod, (ProgramMethod)dynamicMethod);
                        }
                        worklist.enqueueTraceStaticFieldRead(GeneratedMessageLiteBuilderShrinker.this.references.getDefaultInstanceField(dynamicMethod.getHolder()), (ProgramMethod)dynamicMethod);
                    }
                });
            }
        };
    }

    public boolean deferDeadProtoBuilders(DexProgramClass clazz, ProgramMethod method, BooleanSupplier register) {
        if (!this.enableAggressiveBuilderOptimization) {
            return false;
        }
        DexEncodedMethod definition = (DexEncodedMethod)method.getDefinition();
        if (this.references.isDynamicMethod(definition) && this.references.isGeneratedMessageLiteBuilder(clazz) && register.getAsBoolean()) {
            assert (!this.builders.containsKey(clazz) || this.builders.get(clazz).getDefinition() == definition);
            this.builders.put(clazz, method);
            return true;
        }
        return false;
    }

    public void rewriteDeadBuilderReferencesFromDynamicMethods(AppView<AppInfoWithLiveness> appView, ExecutorService executorService, Timing timing) throws ExecutionException {
        if (this.builders.isEmpty()) {
            return;
        }
        timing.begin("Remove dead builder references");
        AppInfoWithLiveness appInfo = appView.appInfo();
        IRConverter converter = new IRConverter(appView, Timing.empty());
        ThreadUtils.processMap(this.builders, (builder, dynamicMethod) -> {
            if (!appInfo.isLiveProgramClass((DexProgramClass)builder)) {
                this.rewriteDeadBuilderReferencesFromDynamicMethod(appView, (DexProgramClass)builder, (ProgramMethod)dynamicMethod, converter);
            }
        }, executorService);
        this.builders.clear();
        timing.end();
    }

    public void preprocessCallGraphBeforeCycleElimination(Map<DexMethod, Node> nodes) {
        Node node = nodes.get(this.references.generatedMessageLiteBuilderMethods.constructorMethod);
        if (node != null) {
            ArrayList<Node> calleesToBeRemoved = new ArrayList<Node>();
            for (Node callee : node.getCalleesWithDeterministicOrder()) {
                if (!this.references.isDynamicMethodBridge(callee.getMethod())) continue;
                calleesToBeRemoved.add(callee);
            }
            for (Node callee : calleesToBeRemoved) {
                callee.removeCaller(node);
            }
        }
    }

    public void inlineCallsToDynamicMethod(ProgramMethod method, IRCode code, EnumValueOptimizer enumValueOptimizer, OptimizationFeedback feedback, MethodProcessor methodProcessor, Inliner inliner) {
        this.strengthenCheckCastInstructions(code);
        ProtoInliningReasonStrategy inliningReasonStrategy = new ProtoInliningReasonStrategy(this.appView, new FixedInliningReasonStrategy(Inliner.Reason.NEVER));
        inliner.performInlining(method, code, feedback, methodProcessor, Timing.empty(), inliningReasonStrategy);
        if (enumValueOptimizer != null) {
            enumValueOptimizer.rewriteConstantEnumMethodCalls(code);
        }
    }

    private static class RootSetExtension {
        private final AppView<? extends AppInfoWithClassHierarchy> appView;
        private final ProtoReferences references;
        private final PredicateSet<DexType> alwaysClassInline;
        private final Set<DexType> neverMergeClassVertically;
        private final Set<DexType> neverMergeClassHorizontally;
        private final Set<DexMethod> alwaysInline;
        private final Set<DexMethod> bypassClinitforInlining;

        RootSetExtension(AppView<? extends AppInfoWithClassHierarchy> appView, PredicateSet<DexType> alwaysClassInline, Set<DexType> neverMergeClassVertically, Set<DexType> neverMergeClassHorizontally, Set<DexMethod> alwaysInline, Set<DexMethod> bypassClinitforInlining) {
            this.appView = appView;
            this.references = appView.protoShrinker().references;
            this.alwaysClassInline = alwaysClassInline;
            this.neverMergeClassVertically = neverMergeClassVertically;
            this.neverMergeClassHorizontally = neverMergeClassHorizontally;
            this.alwaysInline = alwaysInline;
            this.bypassClinitforInlining = bypassClinitforInlining;
        }

        private void alwaysClassInlineGeneratedMessageLiteBuilders() {
            this.alwaysClassInline.addPredicate(type -> this.appView.appInfo().isStrictSubtypeOf((DexType)type, this.references.generatedMessageLiteBuilderType));
        }

        private void bypassClinitforInliningNewBuilderMethods(SubtypingInfo subtypingInfo) {
            for (DexType type : subtypingInfo.subtypes(this.references.generatedMessageLiteType)) {
                DexEncodedMethod newBuilderMethod;
                DexProgramClass clazz = this.appView.definitionFor(type).asProgramClass();
                if (clazz == null || (newBuilderMethod = clazz.lookupDirectMethod(method -> ((DexMethod)method.getReference()).name == this.references.newBuilderMethodName)) == null) continue;
                this.bypassClinitforInlining.add((DexMethod)newBuilderMethod.getReference());
            }
        }

        private void alwaysInlineBuildPartialFromGeneratedMessageLiteExtendableBuilder() {
            this.alwaysInline.add(this.references.generatedMessageLiteExtendableBuilderMethods.buildPartialMethod);
        }

        private void alwaysInlineCreateBuilderFromGeneratedMessageLite() {
            this.alwaysInline.add(this.references.generatedMessageLiteMethods.createBuilderMethod);
        }

        private void neverMergeGeneratedMessageLiteBuilder() {
            this.neverMergeClass(this.references.generatedMessageLiteBuilderType);
            this.neverMergeClass(this.references.generatedMessageLiteExtendableBuilderType);
        }

        private void neverMergeMessageLite() {
            this.neverMergeClass(this.references.messageLiteType);
        }

        private void neverMergeClass(DexType type) {
            this.neverMergeClassVertically.add(type);
            this.neverMergeClassHorizontally.add(type);
        }

        void extend(SubtypingInfo subtypingInfo) {
            this.alwaysClassInlineGeneratedMessageLiteBuilders();
            this.alwaysInlineCreateBuilderFromGeneratedMessageLite();
            this.neverMergeMessageLite();
            this.bypassClinitforInliningNewBuilderMethods(subtypingInfo);
            this.alwaysInlineBuildPartialFromGeneratedMessageLiteExtendableBuilder();
            this.neverMergeGeneratedMessageLiteBuilder();
        }
    }
}

