/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.proto;

import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.fieldvalueanalysis.StaticFieldValues;
import com.android.tools.r8.ir.analysis.proto.ProtoReferences;
import com.android.tools.r8.ir.analysis.value.SingleNumberValue;
import com.android.tools.r8.ir.analysis.value.objectstate.ObjectState;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ProtoEnumSwitchMapRemover {
    private final ProtoReferences references;
    private final Map<DexType, StaticFieldValues.EnumStaticFieldValues> staticFieldValuesMap = new IdentityHashMap<DexType, StaticFieldValues.EnumStaticFieldValues>();
    private final Map<DexType, StaticFieldValues.EnumStaticFieldValues> staticFieldValuesMapDelayed = new ConcurrentHashMap<DexType, StaticFieldValues.EnumStaticFieldValues>();

    public ProtoEnumSwitchMapRemover(ProtoReferences references) {
        this.references = references;
    }

    private boolean isProtoEnum(DexProgramClass clazz) {
        assert (clazz.isEnum());
        if (clazz.type == this.references.methodToInvokeType) {
            return true;
        }
        return clazz.getInterfaces().contains(this.references.enumLiteMapType);
    }

    public void recordStaticValues(DexProgramClass clazz, StaticFieldValues staticFieldValues) {
        if (staticFieldValues == null || !staticFieldValues.isEnumStaticFieldValues()) {
            return;
        }
        assert (clazz.isEnum());
        StaticFieldValues.EnumStaticFieldValues enumStaticFieldValues = staticFieldValues.asEnumStaticFieldValues();
        if (this.isProtoEnum(clazz)) {
            this.staticFieldValuesMapDelayed.put(clazz.type, enumStaticFieldValues);
        }
    }

    public void updateVisibleStaticFieldValues() {
        this.staticFieldValuesMap.putAll(this.staticFieldValuesMapDelayed);
        this.staticFieldValuesMapDelayed.clear();
    }

    public SingleNumberValue getOrdinal(DexProgramClass enumClass, DexEncodedField enumInstanceField, DexEncodedField ordinalField) {
        if (enumClass == null || !this.isProtoEnum(enumClass)) {
            return null;
        }
        StaticFieldValues.EnumStaticFieldValues enumStaticFieldValues = this.staticFieldValuesMap.get(enumClass.type);
        if (enumStaticFieldValues == null) {
            return null;
        }
        ObjectState state = enumStaticFieldValues.getObjectStateForPossiblyPinnedField((DexField)enumInstanceField.getReference());
        if (state == null) {
            return null;
        }
        return state.getAbstractFieldValue(ordinalField).asSingleNumberValue();
    }
}

