/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.proto;

import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.proto.ProtoReferences;
import com.android.tools.r8.ir.analysis.proto.ProtoUtils;
import com.android.tools.r8.ir.analysis.proto.schema.DeadProtoFieldObject;
import com.android.tools.r8.ir.analysis.proto.schema.LiveProtoFieldObject;
import com.android.tools.r8.ir.analysis.proto.schema.ProtoFieldInfo;
import com.android.tools.r8.ir.analysis.proto.schema.ProtoFieldType;
import com.android.tools.r8.ir.analysis.proto.schema.ProtoFieldTypeFactory;
import com.android.tools.r8.ir.analysis.proto.schema.ProtoMessageInfo;
import com.android.tools.r8.ir.analysis.proto.schema.ProtoObject;
import com.android.tools.r8.ir.analysis.proto.schema.ProtoObjectFromInvokeStatic;
import com.android.tools.r8.ir.analysis.proto.schema.ProtoObjectFromStaticGet;
import com.android.tools.r8.ir.analysis.proto.schema.ProtoTypeObject;
import com.android.tools.r8.ir.code.ArrayPut;
import com.android.tools.r8.ir.code.ConstClass;
import com.android.tools.r8.ir.code.ConstString;
import com.android.tools.r8.ir.code.DexItemBasedConstString;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.InvokeStatic;
import com.android.tools.r8.ir.code.NewArrayEmpty;
import com.android.tools.r8.ir.code.StaticGet;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.naming.dexitembasedstring.NameComputationInfo;
import com.android.tools.r8.utils.ThrowingCharIterator;
import com.android.tools.r8.utils.ThrowingIntIterator;
import com.android.tools.r8.utils.ThrowingIterator;
import java.io.UTFDataFormatException;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.OptionalInt;

public class RawMessageInfoDecoder {
    private final ProtoFieldTypeFactory factory;
    private final ProtoReferences references;

    RawMessageInfoDecoder(ProtoFieldTypeFactory factory, ProtoReferences references) {
        this.factory = factory;
        this.references = references;
    }

    private ProtoObject createProtoObject(Value value, ProgramMethod context) throws InvalidRawMessageInfoException {
        Value root = value.getAliasedValue();
        if (!root.isPhi()) {
            Instruction definition = root.definition;
            if (definition.isConstClass()) {
                ConstClass constClass = definition.asConstClass();
                return new ProtoTypeObject(constClass.getValue());
            }
            if (definition.isConstString()) {
                ConstString constString = definition.asConstString();
                DexField field = context.getHolder().lookupUniqueInstanceFieldWithName(constString.getValue());
                if (field != null) {
                    return new LiveProtoFieldObject(field);
                }
                return new DeadProtoFieldObject(context.getHolderType(), constString.getValue());
            }
            if (definition.isDexItemBasedConstString()) {
                DexItemBasedConstString constString = definition.asDexItemBasedConstString();
                DexReference reference = constString.getItem();
                NameComputationInfo<?> nameComputationInfo = constString.getNameComputationInfo();
                if (reference.isDexField() && nameComputationInfo.isFieldNameComputationInfo()) {
                    DexField field = reference.asDexField();
                    DexEncodedField encodedField = context.getHolder().lookupInstanceField(field);
                    if (encodedField != null) {
                        return new LiveProtoFieldObject(field);
                    }
                    return new DeadProtoFieldObject(context.getHolderType(), field.name);
                }
            } else if (definition.isInvokeStatic()) {
                InvokeStatic invoke = definition.asInvokeStatic();
                if (invoke.arguments().isEmpty()) {
                    return new ProtoObjectFromInvokeStatic(invoke.getInvokedMethod());
                }
            } else if (definition.isStaticGet()) {
                StaticGet staticGet = definition.asStaticGet();
                return new ProtoObjectFromStaticGet(staticGet.getField());
            }
        }
        throw new InvalidRawMessageInfoException();
    }

    private int invalidInfoFailure() throws InvalidRawMessageInfoException {
        throw new InvalidRawMessageInfoException();
    }

    private Value invalidObjectsFailure() throws InvalidRawMessageInfoException {
        throw new InvalidRawMessageInfoException();
    }

    public static ThrowingIntIterator<InvalidRawMessageInfoException> createInfoIterator(Value infoValue) throws InvalidRawMessageInfoException {
        if (!infoValue.isPhi() && infoValue.definition.isConstString()) {
            return RawMessageInfoDecoder.createInfoIterator(infoValue.definition.asConstString().getValue());
        }
        throw new InvalidRawMessageInfoException();
    }

    private static ThrowingIntIterator<InvalidRawMessageInfoException> createInfoIterator(final DexString info) {
        return new ThrowingIntIterator<InvalidRawMessageInfoException>(){
            private final ThrowingCharIterator<UTFDataFormatException> charIterator;
            {
                this.charIterator = info.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.charIterator.hasNext();
            }

            @Override
            public int nextInt() throws InvalidRawMessageInfoException {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                int value = 0;
                int shift = 0;
                do {
                    char c;
                    try {
                        c = this.charIterator.nextChar();
                    }
                    catch (UTFDataFormatException e) {
                        throw new InvalidRawMessageInfoException();
                    }
                    if (c >= '\ud800' && c < '\ue000') {
                        throw new InvalidRawMessageInfoException();
                    }
                    if (c < '\ud800') {
                        return value | c << shift;
                    }
                    value |= (c & 0x1FFF) << shift;
                    shift += 13;
                } while (this.hasNext());
                throw new InvalidRawMessageInfoException();
            }
        };
    }

    private static ThrowingIterator<Value, InvalidRawMessageInfoException> createObjectIterator(final Value objectsValue) throws InvalidRawMessageInfoException {
        if (objectsValue.isPhi() || !objectsValue.definition.isNewArrayEmpty()) {
            throw new InvalidRawMessageInfoException();
        }
        NewArrayEmpty newArrayEmpty = objectsValue.definition.asNewArrayEmpty();
        int expectedArraySize = objectsValue.uniqueUsers().size() - 1;
        Value sizeValue = newArrayEmpty.size().getAliasedValue();
        if (sizeValue.isPhi() || !sizeValue.definition.isConstNumber() || sizeValue.definition.asConstNumber().getIntValue() != expectedArraySize) {
            throw new InvalidRawMessageInfoException();
        }
        final InstructionIterator instructionIterator = newArrayEmpty.getBlock().iterator();
        instructionIterator.nextUntil(instruction -> instruction == newArrayEmpty);
        return new ThrowingIterator<Value, InvalidRawMessageInfoException>(){
            private int expectedNextIndex = 0;

            private boolean isArrayPutOfInterest(Instruction instruction) {
                return instruction.isArrayPut() && instruction.asArrayPut().array().getAliasedValue() == objectsValue;
            }

            @Override
            public boolean hasNext() {
                while (instructionIterator.hasNext()) {
                    Instruction next = instructionIterator.peekNext();
                    if (this.isArrayPutOfInterest(next)) {
                        return true;
                    }
                    if (next.isJumpInstruction()) {
                        return false;
                    }
                    instructionIterator.next();
                }
                return false;
            }

            @Override
            public Value next() throws InvalidRawMessageInfoException {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ArrayPut arrayPut = ((Instruction)instructionIterator.next()).asArrayPut();
                Value indexValue = arrayPut.index().getAliasedValue();
                if (indexValue.isPhi() || !indexValue.definition.isConstNumber() || indexValue.definition.asConstNumber().getIntValue() != this.expectedNextIndex) {
                    throw new InvalidRawMessageInfoException();
                }
                ++this.expectedNextIndex;
                return arrayPut.value().getAliasedValue();
            }
        };
    }

    public ProtoMessageInfo run(ProgramMethod dynamicMethod, InvokeMethod invoke) {
        assert (this.references.isMessageInfoConstructionMethod(invoke.getInvokedMethod()));
        Value infoValue = ProtoUtils.getInfoValueFromMessageInfoConstructionInvoke(invoke, this.references);
        Value objectsValue = ProtoUtils.getObjectsValueFromMessageInfoConstructionInvoke(invoke, this.references);
        return this.run(dynamicMethod, infoValue, objectsValue);
    }

    public ProtoMessageInfo run(ProgramMethod dynamicMethod, Value infoValue, Value objectsValue) {
        try {
            int i;
            ProtoMessageInfo.Builder builder = ProtoMessageInfo.builder(dynamicMethod);
            ThrowingIntIterator<InvalidRawMessageInfoException> infoIterator = RawMessageInfoDecoder.createInfoIterator(infoValue);
            int flags = infoIterator.nextIntComputeIfAbsent(this::invalidInfoFailure);
            builder.setFlags(flags);
            int fieldCount = infoIterator.nextIntComputeIfAbsent(this::invalidInfoFailure);
            if (fieldCount == 0) {
                return builder.build();
            }
            int numberOfOneOfObjects = infoIterator.nextIntComputeIfAbsent(this::invalidInfoFailure);
            int numberOfHasBitsObjects = infoIterator.nextIntComputeIfAbsent(this::invalidInfoFailure);
            for (int i2 = 4; i2 < 10; ++i2) {
                infoIterator.nextIntComputeIfAbsent(this::invalidInfoFailure);
            }
            ThrowingIterator<Value, InvalidRawMessageInfoException> objectIterator = RawMessageInfoDecoder.createObjectIterator(objectsValue);
            for (i = 0; i < numberOfOneOfObjects; ++i) {
                ProtoObject oneOfObject = this.createProtoObject(objectIterator.computeNextIfAbsent(this::invalidObjectsFailure), dynamicMethod);
                if (!oneOfObject.isProtoFieldObject()) {
                    throw new InvalidRawMessageInfoException();
                }
                ProtoObject oneOfCaseObject = this.createProtoObject(objectIterator.computeNextIfAbsent(this::invalidObjectsFailure), dynamicMethod);
                if (!oneOfCaseObject.isProtoFieldObject()) {
                    throw new InvalidRawMessageInfoException();
                }
                builder.addOneOfObject(oneOfObject.asProtoFieldObject(), oneOfCaseObject.asProtoFieldObject());
            }
            for (i = 0; i < numberOfHasBitsObjects; ++i) {
                ProtoObject hasBitsObject = this.createProtoObject(objectIterator.computeNextIfAbsent(this::invalidObjectsFailure), dynamicMethod);
                if (!hasBitsObject.isProtoFieldObject()) {
                    throw new InvalidRawMessageInfoException();
                }
                builder.addHasBitsObject(hasBitsObject.asProtoFieldObject());
            }
            boolean isProto2 = ProtoUtils.isProto2(flags);
            for (int i3 = 0; i3 < fieldCount; ++i3) {
                int fieldNumber = infoIterator.nextIntComputeIfAbsent(this::invalidInfoFailure);
                int fieldTypeWithExtraBits = infoIterator.nextIntComputeIfAbsent(this::invalidInfoFailure);
                ProtoFieldType fieldType = this.factory.createField(fieldTypeWithExtraBits);
                if (fieldType.serialize() != fieldTypeWithExtraBits) {
                    throw new CompilationError("Unexpected proto field type `" + fieldTypeWithExtraBits + "`");
                }
                OptionalInt auxData = fieldType.hasAuxData(isProto2) ? OptionalInt.of(infoIterator.nextIntComputeIfAbsent(this::invalidInfoFailure)) : OptionalInt.empty();
                int numberOfObjects = fieldType.numberOfObjects(isProto2, this.factory);
                try {
                    ArrayList<ProtoObject> objects = new ArrayList<ProtoObject>(numberOfObjects);
                    for (Value value : objectIterator.take(numberOfObjects)) {
                        objects.add(this.createProtoObject(value, dynamicMethod));
                    }
                    builder.addField(new ProtoFieldInfo(fieldNumber, fieldType, auxData, objects));
                    continue;
                }
                catch (NoSuchElementException e) {
                    throw new InvalidRawMessageInfoException();
                }
            }
            if (infoIterator.hasNext() || objectIterator.hasNext()) {
                throw new InvalidRawMessageInfoException();
            }
            return builder.build();
        }
        catch (InvalidRawMessageInfoException | ProtoMessageInfo.ProtoMessageInfoBuilderException e) {
            assert (false);
            return null;
        }
    }

    private static class InvalidRawMessageInfoException
    extends Exception {
        private InvalidRawMessageInfoException() {
        }
    }
}

