/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.proto.schema;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.ir.analysis.proto.schema.ProtoFieldObject;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.code.ConstString;
import com.android.tools.r8.ir.code.DexItemBasedConstString;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.naming.dexitembasedstring.FieldNameComputationInfo;

public class LiveProtoFieldObject
extends ProtoFieldObject {
    private final DexField field;

    public LiveProtoFieldObject(DexField field) {
        this.field = field;
    }

    public DexField getField() {
        return this.field;
    }

    @Override
    public Instruction buildIR(AppView<?> appView, IRCode code) {
        Value value = code.createValue(TypeElement.stringClassType(appView, Nullability.definitelyNotNull()));
        if (appView.options().isMinifying()) {
            return new DexItemBasedConstString(value, this.field, FieldNameComputationInfo.forFieldName());
        }
        return new ConstString(value, this.field.name);
    }

    @Override
    public boolean isLiveProtoFieldObject() {
        return true;
    }

    @Override
    public LiveProtoFieldObject asLiveProtoFieldObject() {
        return this;
    }

    public String toString() {
        return "LiveProtoFieldObject(" + this.field.toSourceString() + ")";
    }
}

