/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.proto.schema;

import com.android.tools.r8.ir.analysis.proto.schema.ProtoFieldTypeFactory;
import com.android.tools.r8.ir.analysis.proto.schema.ProtoOneOfFieldType;
import com.android.tools.r8.utils.BitUtils;
import com.android.tools.r8.utils.BooleanUtils;

public class ProtoFieldType {
    public static final int MESSAGE_ID = 9;
    public static final int ENUM_ID = 12;
    public static final int GROUP_ID = 17;
    public static final int MESSAGE_LIST_ID = 27;
    public static final int ENUM_LIST_ID = 30;
    public static final int ENUM_LIST_PACKAGED_ID = 44;
    public static final int GROUP_LIST_ID = 49;
    public static final int MAP_ID = 50;
    private static final int FIELD_ID_MASK = 255;
    private static final int FIELD_IS_REQUIRED_MASK = 256;
    private static final int FIELD_ENFORCE_UTF8_MASK = 512;
    private static final int FIELD_NEEDS_IS_INITIALIZED_CHECK_MASK = 1024;
    private static final int FIELD_IS_MAP_FIELD_WITH_PROTO_2_ENUM_VALUE_MASK = 2048;
    private static final int FIELD_HAS_HAS_BIT_MASK = 4096;
    private final int id;
    private final boolean isRequired;
    private final boolean enforceUtf8Mask;
    private final boolean needsIsInitializedCheck;
    private final boolean isMapFieldWithProto2EnumValue;
    private final boolean hasHasBit;

    ProtoFieldType(int id, boolean isRequired, boolean enforceUtf8Mask, boolean needsIsInitializedCheck, boolean isMapFieldWithProto2EnumValue, boolean hasHasBit) {
        this.id = id;
        this.isRequired = isRequired;
        this.enforceUtf8Mask = enforceUtf8Mask;
        this.needsIsInitializedCheck = needsIsInitializedCheck;
        this.isMapFieldWithProto2EnumValue = isMapFieldWithProto2EnumValue;
        this.hasHasBit = hasHasBit;
        assert (this.isValid());
    }

    static ProtoFieldType fromFieldIdWithExtraBits(int fieldTypeWithExtraBits) {
        int fieldId = fieldTypeWithExtraBits & 0xFF;
        if (fieldId < 51) {
            return new ProtoFieldType(fieldTypeWithExtraBits & 0xFF, BitUtils.isBitInMaskSet(fieldTypeWithExtraBits, 256), BitUtils.isBitInMaskSet(fieldTypeWithExtraBits, 512), BitUtils.isBitInMaskSet(fieldTypeWithExtraBits, 1024), BitUtils.isBitInMaskSet(fieldTypeWithExtraBits, 2048), BitUtils.isBitInMaskSet(fieldTypeWithExtraBits, 4096));
        }
        return new ProtoOneOfFieldType(fieldTypeWithExtraBits & 0xFF, BitUtils.isBitInMaskSet(fieldTypeWithExtraBits, 256), BitUtils.isBitInMaskSet(fieldTypeWithExtraBits, 512), BitUtils.isBitInMaskSet(fieldTypeWithExtraBits, 1024), BitUtils.isBitInMaskSet(fieldTypeWithExtraBits, 2048), BitUtils.isBitInMaskSet(fieldTypeWithExtraBits, 4096));
    }

    public boolean hasAuxData(boolean isProto2) {
        if (this.isSingular()) {
            return isProto2 || this.hasHasBit();
        }
        return false;
    }

    public boolean hasHasBit() {
        return this.hasHasBit;
    }

    public int id() {
        return this.id;
    }

    public boolean isGroup() {
        return this.id == 17;
    }

    public boolean isGroupList() {
        return this.id == 49;
    }

    public boolean isMap() {
        return this.id == 50;
    }

    public boolean isMapFieldWithProto2EnumValue() {
        return this.isMapFieldWithProto2EnumValue;
    }

    public boolean isMessage() {
        return this.id == 9;
    }

    public boolean isMessageList() {
        return this.id == 27;
    }

    public boolean isOneOf() {
        return false;
    }

    public ProtoOneOfFieldType asOneOf() {
        return null;
    }

    public boolean isRepeated() {
        return !this.isSingular() && !this.isMap();
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public boolean isSingular() {
        return this.id <= 17;
    }

    public boolean isValid() {
        assert (this.id < 51);
        return true;
    }

    public boolean needsIsInitializedCheck() {
        return this.needsIsInitializedCheck;
    }

    public int numberOfObjects(boolean isProto2, ProtoFieldTypeFactory factory) {
        switch (this.id) {
            case 27: 
            case 49: {
                return 2;
            }
            case 12: 
            case 30: 
            case 44: {
                return BooleanUtils.intValue(isProto2) + 1;
            }
            case 50: {
                return BooleanUtils.intValue(this.isMapFieldWithProto2EnumValue) + 2;
            }
        }
        return 1;
    }

    public int serialize() {
        int result = this.id;
        if (this.isRequired) {
            result |= 0x100;
        }
        if (this.enforceUtf8Mask) {
            result |= 0x200;
        }
        if (this.needsIsInitializedCheck) {
            result |= 0x400;
        }
        if (this.isMapFieldWithProto2EnumValue) {
            result |= 0x800;
        }
        if (this.hasHasBit) {
            result |= 0x1000;
        }
        return result;
    }
}

