/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.proto.schema;

import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.proto.ProtoUtils;
import com.android.tools.r8.ir.analysis.proto.schema.ProtoFieldInfo;
import com.android.tools.r8.ir.analysis.proto.schema.ProtoFieldObject;
import com.android.tools.r8.ir.analysis.proto.schema.ProtoObject;
import com.android.tools.r8.ir.analysis.proto.schema.ProtoOneOfObjectPair;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;

public class ProtoMessageInfo {
    public static final int BITS_PER_HAS_BITS_WORD = 32;
    private final ProgramMethod dynamicMethod;
    private final int flags;
    private final LinkedList<ProtoFieldInfo> fields;
    private final LinkedList<ProtoFieldObject> hasBitsObjects;
    private final LinkedList<ProtoOneOfObjectPair> oneOfObjects;

    private ProtoMessageInfo(ProgramMethod dynamicMethod, int flags, LinkedList<ProtoFieldInfo> fields, LinkedList<ProtoFieldObject> hasBitsObjects, LinkedList<ProtoOneOfObjectPair> oneOfObjects) {
        this.dynamicMethod = dynamicMethod;
        this.flags = flags;
        this.fields = fields;
        this.hasBitsObjects = hasBitsObjects;
        this.oneOfObjects = oneOfObjects;
    }

    public static Builder builder(ProgramMethod dynamicMethod) {
        return new Builder(dynamicMethod);
    }

    public boolean isProto2() {
        return ProtoUtils.isProto2(this.flags);
    }

    public ProgramMethod getDynamicMethod() {
        return this.dynamicMethod;
    }

    public List<ProtoFieldInfo> getFields() {
        return this.fields;
    }

    public int getFlags() {
        return this.flags;
    }

    public List<ProtoFieldObject> getHasBitsObjects() {
        return this.hasBitsObjects;
    }

    public List<ProtoOneOfObjectPair> getOneOfObjects() {
        return this.oneOfObjects;
    }

    public DexType getType() {
        return this.dynamicMethod.getHolderType();
    }

    public boolean hasFields() {
        return this.fields != null && !this.fields.isEmpty();
    }

    public int numberOfFields() {
        return this.fields != null ? this.fields.size() : 0;
    }

    public int numberOfHasBitsObjects() {
        return this.hasBitsObjects != null ? this.hasBitsObjects.size() : 0;
    }

    public int numberOfOneOfObjects() {
        return this.oneOfObjects != null ? this.oneOfObjects.size() : 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ProtoMessageInfo(fields=[");
        if (this.hasFields()) {
            Iterator fieldIterator = this.fields.iterator();
            builder.append(fieldIterator.next());
            while (fieldIterator.hasNext()) {
                builder.append(", ").append(fieldIterator.next());
            }
        }
        return builder.append("])").toString();
    }

    public static class ProtoMessageInfoBuilderException
    extends Exception {
        private ProtoMessageInfoBuilderException() {
        }
    }

    public static class Builder {
        private final ProgramMethod dynamicMethod;
        private int flags;
        private LinkedList<ProtoFieldInfo> fields;
        private LinkedList<ProtoFieldObject> hasBitsObjects;
        private LinkedList<ProtoOneOfObjectPair> oneOfObjects;

        private Builder(ProgramMethod dynamicMethod) {
            this.dynamicMethod = dynamicMethod;
        }

        private void removeDeadFields() {
            if (this.fields != null) {
                Predicate<ProtoFieldInfo> isFieldDead = field -> {
                    ProtoObject object = field.getType().isOneOf() ? this.oneOfObjects.get(field.getAuxData()).getOneOfObject() : field.getObjects().get(0);
                    return object.isDeadProtoFieldObject();
                };
                this.fields.removeIf(isFieldDead);
            }
        }

        private void removeUnusedSharedData() throws ProtoMessageInfoBuilderException {
            if (this.fields == null || this.fields.isEmpty()) {
                this.oneOfObjects = null;
                this.hasBitsObjects = null;
                return;
            }
            IntOpenHashSet usedOneOfIndices = new IntOpenHashSet();
            IntOpenHashSet usedHasBitsIndices = new IntOpenHashSet();
            for (ProtoFieldInfo field : this.fields) {
                if (!field.hasAuxData()) continue;
                if (field.getType().isOneOf()) {
                    usedOneOfIndices.add(field.getAuxData());
                    continue;
                }
                usedHasBitsIndices.add(field.getAuxData() / 32);
            }
            if (this.hasBitsObjects != null) {
                for (int i = 0; i < this.hasBitsObjects.size(); ++i) {
                    ProtoFieldObject hasBitsObject = this.hasBitsObjects.get(i);
                    if (!hasBitsObject.isLiveProtoFieldObject()) continue;
                    usedHasBitsIndices.add(i);
                }
            }
            Int2IntArrayMap newOneOfObjectIndices = new Int2IntArrayMap();
            if (this.oneOfObjects != null) {
                Iterator oneOfObjectIterator = this.oneOfObjects.iterator();
                int i = 0;
                int numberOfRemovedOneOfObjects = 0;
                while (oneOfObjectIterator.hasNext()) {
                    oneOfObjectIterator.next();
                    if (usedOneOfIndices.contains(i)) {
                        newOneOfObjectIndices.put(i, i - numberOfRemovedOneOfObjects);
                    } else {
                        oneOfObjectIterator.remove();
                        ++numberOfRemovedOneOfObjects;
                    }
                    ++i;
                }
                assert (this.oneOfObjects.stream().allMatch(oneOfObjectPair -> oneOfObjectPair.stream().noneMatch(ProtoObject::isDeadProtoFieldObject)));
            }
            Int2IntArrayMap newHasBitsObjectIndices = new Int2IntArrayMap();
            if (this.hasBitsObjects != null) {
                Iterator hasBitsObjectIterator = this.hasBitsObjects.iterator();
                int i = 0;
                int numberOfRemovedHasBitsObjects = 0;
                while (hasBitsObjectIterator.hasNext()) {
                    hasBitsObjectIterator.next();
                    if (usedHasBitsIndices.contains(i)) {
                        newHasBitsObjectIndices.put(i, i - numberOfRemovedHasBitsObjects);
                    } else {
                        hasBitsObjectIterator.remove();
                        ++numberOfRemovedHasBitsObjects;
                    }
                    ++i;
                }
                for (ProtoFieldObject hasBitsObject : this.hasBitsObjects) {
                    if (!hasBitsObject.isDeadProtoFieldObject()) continue;
                    throw new ProtoMessageInfoBuilderException();
                }
                assert (this.hasBitsObjects.stream().noneMatch(ProtoObject::isDeadProtoFieldObject));
            }
            for (ProtoFieldInfo field : this.fields) {
                if (!field.hasAuxData()) continue;
                if (field.getType().isOneOf()) {
                    field.setAuxData(newOneOfObjectIndices.get(field.getAuxData()));
                    continue;
                }
                int auxData = field.getAuxData();
                int oldHasBitsObjectIndex = auxData / 32;
                int oldHasBitsObjectBitIndex = auxData % 32;
                assert (newHasBitsObjectIndices.containsKey(oldHasBitsObjectIndex));
                field.setAuxData(newHasBitsObjectIndices.get(oldHasBitsObjectIndex) * 32 + oldHasBitsObjectBitIndex);
            }
        }

        public void setFlags(int value) {
            this.flags = value;
        }

        public void addField(ProtoFieldInfo field) {
            if (this.fields == null) {
                this.fields = new LinkedList();
            }
            this.fields.add(field);
        }

        public void addHasBitsObject(ProtoFieldObject hasBitsObject) {
            if (this.hasBitsObjects == null) {
                this.hasBitsObjects = new LinkedList();
            }
            this.hasBitsObjects.add(hasBitsObject);
        }

        public void addOneOfObject(ProtoFieldObject oneOfObject, ProtoFieldObject oneOfCaseObject) {
            if (this.oneOfObjects == null) {
                this.oneOfObjects = new LinkedList();
            }
            this.oneOfObjects.add(new ProtoOneOfObjectPair(oneOfObject, oneOfCaseObject));
        }

        public ProtoMessageInfo build() throws ProtoMessageInfoBuilderException {
            this.removeDeadFields();
            this.removeUnusedSharedData();
            return new ProtoMessageInfo(this.dynamicMethod, this.flags, this.fields, this.hasBitsObjects, this.oneOfObjects);
        }
    }
}

