/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.sideeffect;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.ValueMayDependOnEnvironmentAnalysis;
import com.android.tools.r8.ir.code.ArrayPut;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.StaticPut;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import java.util.Set;

public class ClassInitializerSideEffectAnalysis {
    public static ClassInitializerSideEffect classInitializerCanBePostponed(AppView<AppInfoWithLiveness> appView, IRCode code) {
        ProgramMethod context = code.context();
        boolean controlFlowRequiredToBeIndependentOfControlFlow = false;
        Set<Value> valuesRequiredToBeIndependentOfEnvironment = Sets.newIdentityHashSet();
        for (Instruction instruction : code.instructions()) {
            if (instruction.isArrayPut()) {
                ArrayPut arrayPut = instruction.asArrayPut();
                Value array = arrayPut.array().getAliasedValue();
                if (array.isDefinedByInstructionSatisfying(Instruction::isCreatingArray) && !arrayPut.instructionInstanceCanThrow(appView, context)) continue;
                return ClassInitializerSideEffect.SIDE_EFFECTS_THAT_CANNOT_BE_POSTPONED;
            }
            if (instruction.isInvokeNewArray() || instruction.isNewArrayEmpty() || instruction.isNewArrayFilledData()) {
                if (!instruction.instructionInstanceCanThrow(appView, context)) continue;
                return ClassInitializerSideEffect.SIDE_EFFECTS_THAT_CANNOT_BE_POSTPONED;
            }
            if (instruction.isStaticPut()) {
                StaticPut staticPut = instruction.asStaticPut();
                DexEncodedField field = appView.appInfo().resolveField(staticPut.getField()).getResolvedField();
                if (field == null || field.getHolderType() != context.getHolderType() || instruction.instructionInstanceCanThrow(appView, context)) {
                    return ClassInitializerSideEffect.SIDE_EFFECTS_THAT_CANNOT_BE_POSTPONED;
                }
                controlFlowRequiredToBeIndependentOfControlFlow = true;
                valuesRequiredToBeIndependentOfEnvironment.add(staticPut.value());
                continue;
            }
            if (!(instruction.isInvokeConstructor(appView.dexItemFactory()) ? instruction.instructionMayHaveSideEffects(appView, context, Instruction.SideEffectAssumption.IGNORE_RECEIVER_FIELD_ASSIGNMENTS) : instruction.instructionMayHaveSideEffects(appView, context))) continue;
            return ClassInitializerSideEffect.SIDE_EFFECTS_THAT_CANNOT_BE_POSTPONED;
        }
        if (controlFlowRequiredToBeIndependentOfControlFlow) {
            if (code.controlFlowMayDependOnEnvironment(valuesRequiredToBeIndependentOfEnvironment::add)) {
                return ClassInitializerSideEffect.SIDE_EFFECTS_THAT_CANNOT_BE_POSTPONED;
            }
        }
        if (!valuesRequiredToBeIndependentOfEnvironment.isEmpty()) {
            ValueMayDependOnEnvironmentAnalysis environmentAnalysis = new ValueMayDependOnEnvironmentAnalysis(appView, code);
            if (environmentAnalysis.anyValueMayDependOnEnvironment(valuesRequiredToBeIndependentOfEnvironment)) {
                return ClassInitializerSideEffect.SIDE_EFFECTS_THAT_CANNOT_BE_POSTPONED;
            }
            return ClassInitializerSideEffect.SIDE_EFFECTS_THAT_CAN_BE_POSTPONED;
        }
        return ClassInitializerSideEffect.NONE;
    }

    public static enum ClassInitializerSideEffect {
        SIDE_EFFECTS_THAT_CANNOT_BE_POSTPONED,
        SIDE_EFFECTS_THAT_CAN_BE_POSTPONED,
        NONE;


        public boolean canBePostponed() {
            return this != SIDE_EFFECTS_THAT_CANNOT_BE_POSTPONED;
        }

        public boolean isNone() {
            return this == NONE;
        }
    }
}

