/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.type;

import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.ClassTypeElement;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.NullabilityVariants;
import com.android.tools.r8.ir.analysis.type.ReferenceTypeElement;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;

public class ArrayTypeElement
extends ReferenceTypeElement {
    private final TypeElement memberTypeLattice;
    private final NullabilityVariants<ArrayTypeElement> variants;

    public static ArrayTypeElement create(TypeElement memberTypeLattice, Nullability nullability) {
        return NullabilityVariants.create(nullability, (NullabilityVariants<T> variants) -> new ArrayTypeElement(memberTypeLattice, nullability, (NullabilityVariants<ArrayTypeElement>)variants));
    }

    private ArrayTypeElement(TypeElement memberTypeLattice, Nullability nullability, NullabilityVariants<ArrayTypeElement> variants) {
        super(nullability);
        assert (memberTypeLattice.isPrimitiveType() || memberTypeLattice.nullability().isMaybeNull());
        this.memberTypeLattice = memberTypeLattice;
        this.variants = variants;
    }

    private ArrayTypeElement createVariant(Nullability nullability, NullabilityVariants<ArrayTypeElement> variants) {
        assert (this.nullability != nullability);
        return new ArrayTypeElement(this.memberTypeLattice, nullability, variants);
    }

    private static ReferenceTypeElement joinMember(TypeElement aMember, TypeElement bMember, AppView<?> appView, Nullability nullability) {
        if (aMember.equals(bMember)) {
            return null;
        }
        if (aMember.isArrayType() && bMember.isArrayType()) {
            ReferenceTypeElement join = ArrayTypeElement.joinMember(aMember.asArrayType().memberTypeLattice, bMember.asArrayType().memberTypeLattice, appView, Nullability.maybeNull());
            return join == null ? null : ArrayTypeElement.create(join, nullability);
        }
        if (aMember.isClassType() && bMember.isClassType()) {
            ClassTypeElement join = aMember.asClassType().join(bMember.asClassType(), appView);
            return ArrayTypeElement.create(join, nullability);
        }
        if (aMember.isPrimitiveType() || bMember.isPrimitiveType()) {
            return ArrayTypeElement.objectClassType(appView, nullability);
        }
        return ArrayTypeElement.objectArrayType(appView, nullability);
    }

    public DexType toDexType(DexItemFactory factory) {
        DexType baseType;
        TypeElement baseTypeLattice = this.getBaseType();
        if (baseTypeLattice.isPrimitiveType()) {
            baseType = baseTypeLattice.asPrimitiveType().toDexType(factory);
        } else {
            assert (baseTypeLattice.isClassType());
            baseType = baseTypeLattice.asClassType().getClassType();
        }
        return factory.createArrayType(this.getNesting(), baseType);
    }

    public int getNesting() {
        int nesting = 1;
        TypeElement member = this.getMemberType();
        while (member.isArrayType()) {
            ++nesting;
            member = member.asArrayType().getMemberType();
        }
        return nesting;
    }

    @Override
    public boolean isPrimitiveArrayType() {
        return this.memberTypeLattice.isPrimitiveType();
    }

    public TypeElement getMemberType() {
        return this.memberTypeLattice;
    }

    public TypeElement getMemberTypeAsValueType() {
        return this.memberTypeLattice.isFineGrainedType() ? ArrayTypeElement.getInt() : this.memberTypeLattice;
    }

    public TypeElement getBaseType() {
        TypeElement base = this.getMemberType();
        while (base.isArrayType()) {
            base = base.asArrayType().getMemberType();
        }
        return base;
    }

    @Override
    public ReferenceTypeElement getOrCreateVariant(Nullability nullability) {
        ArrayTypeElement variant = this.variants.get(nullability);
        if (variant != null) {
            return variant;
        }
        return this.variants.getOrCreateElement(nullability, this::createVariant);
    }

    @Override
    public boolean isBasedOnMissingClass(AppView<? extends AppInfoWithClassHierarchy> appView) {
        return this.memberTypeLattice.isBasedOnMissingClass(appView);
    }

    @Override
    public boolean isArrayType() {
        return true;
    }

    @Override
    public ArrayTypeElement asArrayType() {
        return this;
    }

    @Override
    public String toString() {
        return this.nullability.toString() + " (" + this.memberTypeLattice.toString() + "[])";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArrayTypeElement)) {
            return false;
        }
        ArrayTypeElement other = (ArrayTypeElement)o;
        if (this.nullability() != other.nullability()) {
            return false;
        }
        return this.memberTypeLattice.equals(other.memberTypeLattice);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.nullability, this.memberTypeLattice);
    }

    @Override
    public ArrayTypeElement fixupClassTypeReferences(AppView<? extends AppInfoWithClassHierarchy> appView, Function<DexType, DexType> mapping, Set<DexType> prunedTypes) {
        TypeElement substitutedMemberType;
        if (this.memberTypeLattice.isReferenceType() && (substitutedMemberType = this.memberTypeLattice.fixupClassTypeReferences(appView, mapping, prunedTypes)) != this.memberTypeLattice) {
            return ArrayTypeElement.create(substitutedMemberType, this.nullability);
        }
        return this;
    }

    ReferenceTypeElement join(ArrayTypeElement other, AppView<?> appView) {
        Nullability nullability = this.nullability().join(other.nullability());
        ReferenceTypeElement join = ArrayTypeElement.joinMember(this.memberTypeLattice, other.memberTypeLattice, appView, nullability);
        if (join == null) {
            if (other.nullability == nullability) {
                return other;
            }
            return this.getOrCreateVariant(nullability);
        }
        assert (join.nullability == nullability);
        return join;
    }

    ReferenceTypeElement join(ClassTypeElement other, AppView<?> appView) {
        return other.join(this, appView);
    }

    @Override
    public ReferenceTypeElement join(ReferenceTypeElement other, AppView<?> appView) {
        if (other.isArrayType()) {
            return this.join(other.asArrayType(), appView);
        }
        if (other.isClassType()) {
            return this.join(other.asClassType(), appView);
        }
        assert (other.isNullType());
        return this.joinNullability(other.nullability());
    }
}

