/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.type;

import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.ArrayTypeElement;
import com.android.tools.r8.ir.analysis.type.InterfaceCollection;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.NullabilityVariants;
import com.android.tools.r8.ir.analysis.type.PrimitiveTypeElement;
import com.android.tools.r8.ir.analysis.type.ReferenceTypeElement;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.utils.BooleanBox;
import com.android.tools.r8.utils.Box;
import com.android.tools.r8.utils.LRUCacheTable;
import com.android.tools.r8.utils.OptionalBool;
import com.android.tools.r8.utils.Pair;
import com.android.tools.r8.utils.SetUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ClassTypeElement
extends ReferenceTypeElement {
    private InterfaceCollection lazyInterfaces;
    private AppView<? extends AppInfoWithClassHierarchy> appView;
    private final NullabilityVariants<ClassTypeElement> variants;
    private final DexType type;

    public static ClassTypeElement create(DexType classType, Nullability nullability, AppView<? extends AppInfoWithClassHierarchy> appView, InterfaceCollection interfaces) {
        assert (appView != null);
        assert (appView.enableWholeProgramOptimizations());
        assert (interfaces != null);
        return NullabilityVariants.create(nullability, variants -> new ClassTypeElement(classType, nullability, interfaces, (NullabilityVariants<ClassTypeElement>)variants, appView));
    }

    public static ClassTypeElement create(DexType classType, Nullability nullability, AppView<? extends AppInfoWithClassHierarchy> appView) {
        assert (appView != null);
        assert (appView.enableWholeProgramOptimizations());
        return NullabilityVariants.create(nullability, variants -> new ClassTypeElement(classType, nullability, null, (NullabilityVariants<ClassTypeElement>)variants, appView));
    }

    public static ClassTypeElement createForD8(DexType classType, Nullability nullability) {
        return NullabilityVariants.create(nullability, variants -> new ClassTypeElement(classType, nullability, InterfaceCollection.empty(), (NullabilityVariants<ClassTypeElement>)variants, null));
    }

    private ClassTypeElement(DexType classType, Nullability nullability, InterfaceCollection interfaces, NullabilityVariants<ClassTypeElement> variants, AppView<? extends AppInfoWithClassHierarchy> appView) {
        super(nullability);
        assert (appView == null ? interfaces != null && interfaces.isEmpty() : appView.enableWholeProgramOptimizations());
        assert (classType.isClassType());
        this.type = classType;
        this.appView = appView;
        this.lazyInterfaces = interfaces;
        this.variants = variants;
    }

    private ClassTypeElement createVariant(Nullability nullability, NullabilityVariants<ClassTypeElement> variants) {
        assert (this.nullability != nullability);
        return new ClassTypeElement(this.type, nullability, this.lazyInterfaces, variants, this.appView);
    }

    private ClassTypeElement joinWithClassHierarchy(ClassTypeElement other) {
        assert (this.appView != null);
        assert (this.appView.enableWholeProgramOptimizations());
        DexType lubType = ClassTypeElement.computeLeastUpperBoundOfClasses(this.appView.appInfo(), this.getClassType(), other.getClassType());
        return this.joinWithClassHierarchy(lubType, other.getInterfaces(), other.nullability());
    }

    private ClassTypeElement joinWithClassHierarchy(DexType lubType, InterfaceCollection otherInterfaces, Nullability nullability) {
        assert (this.appView != null);
        assert (this.appView.enableWholeProgramOptimizations());
        InterfaceCollection interfaces = this.getInterfaces();
        InterfaceCollection lubInterfaces = interfaces.equals(otherInterfaces) ? interfaces : ClassTypeElement.computeLeastUpperBoundOfInterfaces(this.appView, interfaces, otherInterfaces);
        InterfaceCollection lubInterfacesDefault = this.appView.dexItemFactory().getOrComputeLeastUpperBoundOfImplementedInterfaces(lubType, this.appView);
        Nullability lubNullability = this.nullability().join(nullability);
        return lubInterfaces.equals(lubInterfacesDefault) ? ClassTypeElement.create(lubType, lubNullability, this.appView) : ClassTypeElement.create(lubType, lubNullability, this.appView, lubInterfaces);
    }

    public static DexType computeLeastUpperBoundOfClasses(AppInfoWithClassHierarchy appInfo, DexType type1, DexType type2) {
        DexClass clazz;
        if (type1 == type2) {
            return type1;
        }
        DexType objectType = appInfo.dexItemFactory().objectType;
        if (type1 == objectType || type2 == objectType) {
            return objectType;
        }
        Collection types = new ArrayList<DexType>(10);
        DexType type = type1;
        while (true) {
            if (type == type2) {
                return type;
            }
            types.add(type);
            clazz = appInfo.definitionFor(type);
            if (clazz == null || clazz.superType == null || clazz.superType == objectType) break;
            type = clazz.superType;
        }
        if (types.size() > 20) {
            types = SetUtils.newIdentityHashSet(types);
        }
        type = type2;
        while (true) {
            if (types.contains(type)) {
                return type;
            }
            clazz = appInfo.definitionFor(type);
            if (clazz == null || clazz.superType == null || clazz.superType == objectType) break;
            type = clazz.superType;
        }
        return objectType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InterfaceCollection computeLeastUpperBoundOfInterfaces(AppView<? extends AppInfoWithClassHierarchy> appView, InterfaceCollection s1, InterfaceCollection s2) {
        if (s1.isEmpty() || s2.isEmpty()) {
            return InterfaceCollection.empty();
        }
        InterfaceCollection cached = appView.dexItemFactory().leastUpperBoundOfInterfacesTable.get(s1, s2);
        if (cached != null) {
            return cached;
        }
        cached = appView.dexItemFactory().leastUpperBoundOfInterfacesTable.get(s2, s1);
        if (cached != null) {
            return cached;
        }
        IdentityHashMap<DexType, InterfaceMarker> seen = new IdentityHashMap<DexType, InterfaceMarker>();
        ArrayDeque<InterfaceWithMarker> worklist = new ArrayDeque<InterfaceWithMarker>();
        s1.forEach((itf1, isKnown) -> worklist.add(new InterfaceWithMarker((DexType)itf1, InterfaceMarker.forLeft(isKnown))));
        s2.forEach((itf2, isKnown) -> worklist.add(new InterfaceWithMarker((DexType)itf2, InterfaceMarker.forRight(isKnown))));
        while (!worklist.isEmpty()) {
            DexClass itfClass;
            InterfaceWithMarker item = (InterfaceWithMarker)worklist.poll();
            DexType itf3 = item.itf;
            InterfaceMarker marker = item.marker;
            InterfaceMarker marking2 = seen.computeIfAbsent(itf3, k -> InterfaceMarker.createUnmarked());
            if (!marking2.merge(marker) || (itfClass = appView.definitionFor(itf3)) == null) continue;
            for (DexType superItf : itfClass.interfaces.values) {
                worklist.add(new InterfaceWithMarker(superItf, marker));
            }
        }
        ArrayList commonlyVisited = new ArrayList(seen.size());
        seen.forEach((itf, marking) -> {
            if (marking.isMarkedOnBothSides()) {
                commonlyVisited.add(new Pair<DexType, Boolean>((DexType)itf, marking.knownIfBothAreKnown()));
            }
        });
        InterfaceCollection.Builder lubBuilder = InterfaceCollection.builder();
        for (Pair entry : commonlyVisited) {
            boolean notTheLeast = false;
            for (Pair other : commonlyVisited) {
                if (!appView.appInfo().isStrictSubtypeOf((DexType)other.getFirst(), (DexType)entry.getFirst())) continue;
                notTheLeast = true;
                break;
            }
            if (notTheLeast) continue;
            lubBuilder.addInterface((DexType)entry.getFirst(), (Boolean)entry.getSecond());
        }
        InterfaceCollection lub = lubBuilder.build();
        if (!s1.equals(s2)) {
            LRUCacheTable<InterfaceCollection, InterfaceCollection, InterfaceCollection> lRUCacheTable = appView.dexItemFactory().leastUpperBoundOfInterfacesTable;
            synchronized (lRUCacheTable) {
                appView.dexItemFactory().leastUpperBoundOfInterfacesTable.put(s1, s2, lub);
            }
        }
        return lub;
    }

    public DexType getClassType() {
        return this.type;
    }

    public InterfaceCollection getInterfaces() {
        if (this.lazyInterfaces == null) {
            assert (this.appView != null);
            assert (this.appView.enableWholeProgramOptimizations());
            return this.appView.dexItemFactory().getOrComputeLeastUpperBoundOfImplementedInterfaces(this.type, this.appView);
        }
        return this.lazyInterfaces;
    }

    @Override
    public ClassTypeElement getOrCreateVariant(Nullability nullability) {
        ClassTypeElement variant = this.variants.get(nullability);
        if (variant != null) {
            return variant;
        }
        return this.variants.getOrCreateElement(nullability, this::createVariant);
    }

    @Override
    public boolean isBasedOnMissingClass(AppView<? extends AppInfoWithClassHierarchy> appView) {
        return appView.appInfo().isMissingOrHasMissingSuperType(this.getClassType()) || this.getInterfaces().anyMatch((iface, isKnown) -> ((AppInfoWithClassHierarchy)appView.appInfo()).isMissingOrHasMissingSuperType((DexType)iface));
    }

    @Override
    public boolean isClassType() {
        return true;
    }

    @Override
    public ClassTypeElement asClassType() {
        return this;
    }

    @Override
    public ClassTypeElement asDefinitelyNotNull() {
        return this.getOrCreateVariant(Nullability.definitelyNotNull());
    }

    @Override
    public ClassTypeElement asMeetWithNotNull() {
        return this.getOrCreateVariant(this.nullability.meet(Nullability.definitelyNotNull()));
    }

    @Override
    public ClassTypeElement joinNullability(Nullability nullability) {
        return this.getOrCreateVariant(this.nullability().join(nullability));
    }

    @Override
    public ClassTypeElement meetNullability(Nullability nullability) {
        return this.getOrCreateVariant(this.nullability().meet(nullability));
    }

    public DexType toDexType(DexItemFactory dexItemFactory) {
        DexType singleKnownInterface;
        if (this.type == dexItemFactory.objectType && (singleKnownInterface = this.getInterfaces().getSingleKnownInterface()) != null) {
            return singleKnownInterface;
        }
        return this.type;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.nullability);
        builder.append(" ");
        builder.append(this.type);
        builder.append(" {");
        InterfaceCollection interfaces = this.getInterfaces();
        List<Pair<DexType, Boolean>> sortedInterfaces = interfaces.getInterfaceList();
        sortedInterfaces.sort(Comparator.comparing(Pair::getFirst));
        builder.append(sortedInterfaces.stream().map(pair -> (Boolean)pair.getSecond() != false ? ((DexType)pair.getFirst()).toString() : "maybe(" + pair.getFirst() + ")").collect(Collectors.joining(", ")));
        builder.append("}");
        return builder.toString();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.nullability, this.type);
    }

    @Override
    public TypeElement fixupClassTypeReferences(AppView<? extends AppInfoWithClassHierarchy> ignore, Function<DexType, DexType> mapping, Set<DexType> prunedTypes) {
        assert (this.appView != null);
        assert (this.appView.enableWholeProgramOptimizations());
        DexType mappedType = mapping.apply(this.type);
        if (mappedType.isPrimitiveType()) {
            return PrimitiveTypeElement.fromDexType(mappedType, false);
        }
        if (this.lazyInterfaces == null || this.lazyInterfaces.isEmpty()) {
            return mappedType == this.type ? this : ClassTypeElement.create(mappedType, this.nullability, this.appView);
        }
        BooleanBox hasChangedInterfaces = new BooleanBox();
        Box interfaceToClassChange = new Box();
        this.getInterfaces().forEach((iface, isKnown) -> {
            if (prunedTypes.contains(iface)) {
                return;
            }
            DexType substitutedType = (DexType)mapping.apply((DexType)iface);
            if (iface != substitutedType) {
                hasChangedInterfaces.set();
                DexClass mappedClass = this.appView.definitionFor(substitutedType);
                if (!mappedClass.isInterface()) {
                    if (interfaceToClassChange.isSet() && mappedClass != interfaceToClassChange.get()) {
                        throw new CompilationError("More than one interface has changed to a class: " + interfaceToClassChange.get() + " and " + mappedClass);
                    }
                    interfaceToClassChange.set(mappedClass);
                }
            }
        });
        if (hasChangedInterfaces.get()) {
            if (interfaceToClassChange.isSet()) {
                assert (!((DexClass)interfaceToClassChange.get()).isInterface());
                assert (mappedType == this.appView.dexItemFactory().objectType);
                return ClassTypeElement.create(((DexClass)interfaceToClassChange.get()).type, this.nullability, this.appView);
            }
            InterfaceCollection.Builder builder = InterfaceCollection.builder();
            this.lazyInterfaces.forEach((iface, isKnown) -> {
                DexType rewritten = (DexType)mapping.apply((DexType)iface);
                assert (iface == rewritten || isKnown.booleanValue()) : "Rewritten implies program types thus known.";
                builder.addInterface(rewritten, (boolean)isKnown);
            });
            return ClassTypeElement.create(mappedType, this.nullability, this.appView, builder.build());
        }
        return mappedType == this.type ? this : ClassTypeElement.create(mappedType, this.nullability, this.appView, this.getInterfaces());
    }

    ClassTypeElement join(ClassTypeElement other, AppView<?> appView) {
        if (appView.enableWholeProgramOptimizations()) {
            return this.joinWithClassHierarchy(other);
        }
        return this.joinWithoutClassHierarchy(other.getClassType(), other.nullability(), appView);
    }

    ReferenceTypeElement join(ArrayTypeElement other, AppView<?> appView) {
        DexItemFactory dexItemFactory = appView.dexItemFactory();
        if (appView.enableWholeProgramOptimizations()) {
            DexType lubType = appView.dexItemFactory().objectType;
            return this.joinWithClassHierarchy(lubType, InterfaceCollection.builder().addKnownInterface(dexItemFactory.cloneableType).addKnownInterface(dexItemFactory.serializableType).build(), other.nullability());
        }
        return this.joinWithoutClassHierarchy(dexItemFactory.objectType, other.nullability(), appView);
    }

    @Override
    public ReferenceTypeElement join(ReferenceTypeElement other, AppView<?> appView) {
        if (other.isArrayType()) {
            return this.join(other.asArrayType(), appView);
        }
        if (other.isClassType()) {
            return this.join(other.asClassType(), appView);
        }
        assert (other.isNullType());
        return this.joinNullability(other.nullability());
    }

    ClassTypeElement joinWithoutClassHierarchy(DexType other, Nullability nullability, AppView<?> appView) {
        assert (!appView.enableWholeProgramOptimizations());
        assert (this.lazyInterfaces != null);
        assert (this.lazyInterfaces.isEmpty());
        return ClassTypeElement.createForD8(this.getClassType() == other ? this.getClassType() : appView.dexItemFactory().objectType, this.nullability().join(nullability));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClassTypeElement)) {
            return false;
        }
        ClassTypeElement other = (ClassTypeElement)o;
        if (this.nullability() != other.nullability()) {
            return false;
        }
        if (!this.type.equals(other.type)) {
            return false;
        }
        return this.getInterfaces().equals(other.getInterfaces());
    }

    private static class InterfaceWithMarker {
        final DexType itf;
        final InterfaceMarker marker;

        InterfaceWithMarker(DexType itf, InterfaceMarker marker) {
            this.itf = itf;
            this.marker = marker;
        }
    }

    private static class InterfaceMarker {
        static final InterfaceMarker LEFT_KNOWN = new InterfaceMarker(OptionalBool.TRUE, OptionalBool.FALSE);
        static final InterfaceMarker LEFT_UNKNOWN = new InterfaceMarker(OptionalBool.UNKNOWN, OptionalBool.FALSE);
        static final InterfaceMarker RIGHT_KNOWN = new InterfaceMarker(OptionalBool.FALSE, OptionalBool.TRUE);
        static final InterfaceMarker RIGHT_UNKNOWN = new InterfaceMarker(OptionalBool.FALSE, OptionalBool.UNKNOWN);
        private OptionalBool left;
        private OptionalBool right;

        static InterfaceMarker forLeft(boolean isKnown) {
            return isKnown ? LEFT_KNOWN : LEFT_UNKNOWN;
        }

        static InterfaceMarker forRight(boolean isKnown) {
            return isKnown ? RIGHT_KNOWN : RIGHT_UNKNOWN;
        }

        static InterfaceMarker createUnmarked() {
            return new InterfaceMarker(OptionalBool.FALSE, OptionalBool.FALSE);
        }

        public InterfaceMarker(OptionalBool left, OptionalBool right) {
            this.left = left;
            this.right = right;
            assert (!this.isMarkedOnBothSides());
        }

        static OptionalBool knownIfAnyIsKnown(OptionalBool v1, OptionalBool v2) {
            assert (v1.isPossiblyTrue() || v2.isPossiblyTrue());
            return v1.isTrue() || v2.isTrue() ? OptionalBool.TRUE : OptionalBool.UNKNOWN;
        }

        boolean isMarked() {
            return this.left.isPossiblyTrue() || this.right.isPossiblyTrue();
        }

        boolean isMarkedOnBothSides() {
            return this.left.isPossiblyTrue() && this.right.isPossiblyTrue();
        }

        boolean knownIfBothAreKnown() {
            assert (this.isMarkedOnBothSides());
            return this.left.isTrue() && this.right.isTrue();
        }

        boolean merge(InterfaceMarker marker) {
            assert (marker.isMarked());
            assert (!marker.isMarkedOnBothSides());
            if (marker.left.isPossiblyTrue()) {
                OptionalBool oldLeft = this.left;
                this.left = InterfaceMarker.knownIfAnyIsKnown(this.left, marker.left);
                return this.right.isFalse() && this.left != oldLeft;
            }
            OptionalBool oldRight = this.right;
            this.right = InterfaceMarker.knownIfAnyIsKnown(this.right, marker.right);
            return this.left.isFalse() && this.right != oldRight;
        }
    }
}

