/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.type;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.ir.analysis.type.TypeAnalysis;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.BasicBlockIterator;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.Value;
import java.util.ArrayDeque;
import java.util.Set;
import java.util.function.Function;

public class DestructivePhiTypeUpdater {
    private final AppView<? extends AppInfoWithClassHierarchy> appView;
    private final Function<DexType, DexType> mapping;

    public DestructivePhiTypeUpdater(AppView<? extends AppInfoWithClassHierarchy> appView, GraphLens graphLens, GraphLens codeLens) {
        this(appView, type -> graphLens.lookupType((DexType)type, codeLens));
    }

    public DestructivePhiTypeUpdater(AppView<? extends AppInfoWithClassHierarchy> appView, Function<DexType, DexType> mapping) {
        this.appView = appView;
        this.mapping = mapping;
    }

    private boolean verifyAllPhiOperandsAreBottom(Set<Phi> affectedPhis) {
        for (Phi phi : affectedPhis) {
            for (Value operand : phi.getOperands()) {
                if (!operand.isPhi()) continue;
                Phi operandPhi = operand.asPhi();
                TypeElement operandType = operandPhi.getType();
                assert (!affectedPhis.contains(operandPhi) || operandType.isBottom());
                assert (affectedPhis.contains(operandPhi) || operandType.isPrimitiveType() || operandType.isNullType() || operandType.isReferenceType() && operandType.fixupClassTypeReferences(this.appView, this.mapping) == operandType);
            }
        }
        return true;
    }

    private boolean verifyAllChangedPhisAreScheduled(IRCode code, Set<Phi> affectedPhis) {
        BasicBlockIterator blocks = code.listIterator();
        while (blocks.hasNext()) {
            BasicBlock block = (BasicBlock)blocks.next();
            for (Phi phi : block.getPhis()) {
                TypeElement phiType = phi.getType();
                TypeElement substituted = phiType.fixupClassTypeReferences(this.appView, this.mapping);
                assert (substituted == phiType || affectedPhis.contains(phi));
            }
        }
        return true;
    }

    public void recomputeAndPropagateTypes(IRCode code, Set<Phi> affectedPhis) {
        ArrayDeque<Phi> worklist = new ArrayDeque<Phi>(affectedPhis);
        while (!worklist.isEmpty()) {
            Phi phi = (Phi)worklist.poll();
            phi.setType(TypeElement.getBottom());
            for (Phi affectedPhi : phi.uniquePhiUsers()) {
                if (!affectedPhis.add(affectedPhi)) continue;
                worklist.add(affectedPhi);
            }
        }
        assert (this.verifyAllChangedPhisAreScheduled(code, affectedPhis));
        assert (this.verifyAllPhiOperandsAreBottom(affectedPhis));
        Set<Value> affectedValues = Sets.newIdentityHashSet();
        worklist.addAll(affectedPhis);
        while (!worklist.isEmpty()) {
            Phi phi = (Phi)worklist.poll();
            TypeElement newType = phi.computePhiType(this.appView);
            if (phi.getType().equals(newType)) continue;
            assert (!newType.isBottom());
            phi.setType(newType);
            worklist.addAll(phi.uniquePhiUsers());
            affectedValues.addAll(phi.affectedValues());
        }
        assert (new TypeAnalysis(this.appView).verifyValuesUpToDate(affectedPhis));
        if (!affectedValues.isEmpty()) {
            new TypeAnalysis(this.appView).narrowing(affectedValues);
        }
    }
}

