/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.type;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.ir.analysis.type.ClassTypeElement;
import com.android.tools.r8.ir.analysis.type.DynamicType;
import com.android.tools.r8.ir.analysis.type.DynamicTypeWithLowerBound;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.ReferenceTypeElement;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import java.util.Objects;
import java.util.Set;

public class DynamicTypeWithUpperBound
extends DynamicType {
    static final DynamicTypeWithUpperBound BOTTOM = new DynamicTypeWithUpperBound(TypeElement.getBottom());
    static final DynamicTypeWithUpperBound NULL_TYPE = new DynamicTypeWithUpperBound(TypeElement.getNull());
    static final DynamicTypeWithUpperBound UNKNOWN = new DynamicTypeWithUpperBound(TypeElement.getTop());
    private final TypeElement dynamicUpperBoundType;

    DynamicTypeWithUpperBound(TypeElement dynamicUpperBoundType) {
        assert (dynamicUpperBoundType != null);
        this.dynamicUpperBoundType = dynamicUpperBoundType;
    }

    public static DynamicTypeWithUpperBound create(AppView<AppInfoWithLiveness> appView, TypeElement dynamicUpperBoundType) {
        ClassTypeElement dynamicLowerBoundType = DynamicTypeWithUpperBound.isEffectivelyFinal(appView, dynamicUpperBoundType) ? dynamicUpperBoundType.asClassType() : null;
        return DynamicTypeWithUpperBound.create(appView, dynamicUpperBoundType, dynamicLowerBoundType);
    }

    public static DynamicTypeWithUpperBound create(AppView<AppInfoWithLiveness> appView, TypeElement dynamicUpperBoundType, ClassTypeElement dynamicLowerBoundType) {
        if (dynamicUpperBoundType.isBottom()) {
            return DynamicTypeWithUpperBound.bottom();
        }
        if (dynamicUpperBoundType.isNullType()) {
            return DynamicTypeWithUpperBound.definitelyNull();
        }
        if (dynamicUpperBoundType.isTop()) {
            return DynamicTypeWithUpperBound.unknown();
        }
        if (dynamicLowerBoundType != null) {
            assert (dynamicUpperBoundType.isClassType());
            assert (dynamicUpperBoundType.nullability() == dynamicLowerBoundType.nullability());
            if (dynamicUpperBoundType.equals(dynamicLowerBoundType)) {
                return DynamicTypeWithUpperBound.createExact(dynamicLowerBoundType);
            }
            return DynamicTypeWithLowerBound.create(appView, dynamicUpperBoundType.asClassType(), dynamicLowerBoundType);
        }
        assert (DynamicTypeWithUpperBound.verifyNotEffectivelyFinalClassType(appView, dynamicUpperBoundType));
        return new DynamicTypeWithUpperBound(dynamicUpperBoundType);
    }

    public static DynamicTypeWithUpperBound create(AppView<AppInfoWithLiveness> appView, Value value) {
        assert (value.getType().isReferenceType());
        TypeElement dynamicUpperBoundType = value.getDynamicUpperBoundType(appView);
        ClassTypeElement dynamicLowerBoundType = value.getDynamicLowerBoundType(appView, dynamicUpperBoundType, dynamicUpperBoundType.nullability());
        return DynamicTypeWithUpperBound.create(appView, dynamicUpperBoundType, dynamicLowerBoundType);
    }

    private static boolean isEffectivelyFinal(AppView<?> appView, TypeElement type) {
        if (type.isClassType()) {
            ClassTypeElement classType = type.asClassType();
            DexClass clazz = appView.definitionFor(classType.getClassType());
            return clazz != null && clazz.isEffectivelyFinal(appView);
        }
        return false;
    }

    private ClassTypeElement meetDynamicLowerBound(AppView<AppInfoWithLiveness> appView, DynamicType dynamicType) {
        ClassTypeElement otherLowerBoundType;
        if (this.isNullType()) {
            if (dynamicType.hasDynamicLowerBoundType()) {
                return dynamicType.getDynamicLowerBoundType().joinNullability(Nullability.definitelyNull());
            }
            return null;
        }
        if (dynamicType.isNullType()) {
            if (this.hasDynamicLowerBoundType()) {
                return this.getDynamicLowerBoundType().joinNullability(Nullability.definitelyNull());
            }
            return null;
        }
        if (!this.hasDynamicLowerBoundType() || !dynamicType.hasDynamicLowerBoundType()) {
            return null;
        }
        ClassTypeElement lowerBoundType = this.getDynamicLowerBoundType();
        if (lowerBoundType.lessThanOrEqualUpToNullability(otherLowerBoundType = dynamicType.getDynamicLowerBoundType(), appView)) {
            return lowerBoundType.joinNullability(otherLowerBoundType.nullability());
        }
        if (otherLowerBoundType.lessThanOrEqualUpToNullability(lowerBoundType, appView)) {
            return otherLowerBoundType.joinNullability(lowerBoundType.nullability());
        }
        return null;
    }

    private static boolean verifyNotEffectivelyFinalClassType(AppView<AppInfoWithLiveness> appView, TypeElement type) {
        if (type.isClassType()) {
            ClassTypeElement classType = type.asClassType();
            DexClass clazz = appView.definitionFor(classType.getClassType());
            assert (clazz == null || !clazz.isEffectivelyFinal(appView));
        }
        return true;
    }

    @Override
    public boolean hasDynamicUpperBoundType() {
        return true;
    }

    @Override
    public TypeElement getDynamicUpperBoundType(TypeElement staticType) {
        return this.getDynamicUpperBoundType();
    }

    public TypeElement getDynamicUpperBoundType() {
        return this.dynamicUpperBoundType;
    }

    @Override
    public boolean hasDynamicLowerBoundType() {
        return false;
    }

    @Override
    public ClassTypeElement getDynamicLowerBoundType() {
        return null;
    }

    @Override
    public boolean isExactClassType() {
        return this.getExactClassType() != null;
    }

    @Override
    public ClassTypeElement getExactClassType() {
        return this.hasDynamicLowerBoundType() && this.getDynamicLowerBoundType().equalUpToNullability(this.getDynamicUpperBoundType()) ? this.getDynamicLowerBoundType() : null;
    }

    @Override
    public Nullability getNullability() {
        return this.dynamicUpperBoundType.nullability();
    }

    @Override
    public boolean isBottom() {
        return this.dynamicUpperBoundType.isBottom();
    }

    @Override
    public boolean isDynamicTypeWithUpperBound() {
        return true;
    }

    @Override
    public DynamicTypeWithUpperBound asDynamicTypeWithUpperBound() {
        return this;
    }

    @Override
    public boolean isNullType() {
        return this.dynamicUpperBoundType.isNullType();
    }

    @Override
    public boolean isUnknown() {
        return this.dynamicUpperBoundType.isTop();
    }

    public DynamicType join(AppView<AppInfoWithLiveness> appView, DynamicTypeWithUpperBound dynamicType) {
        ClassTypeElement lowerBoundType;
        TypeElement upperBoundType = this.getDynamicUpperBoundType().join(dynamicType.getDynamicUpperBoundType(), appView);
        ClassTypeElement classTypeElement = lowerBoundType = DynamicTypeWithUpperBound.isEffectivelyFinal(appView, upperBoundType) ? upperBoundType.asClassType() : this.meetDynamicLowerBound(appView, dynamicType);
        if (upperBoundType.equals(this.getDynamicUpperBoundType()) && Objects.equals(lowerBoundType, this.getDynamicLowerBoundType())) {
            return this;
        }
        return DynamicTypeWithUpperBound.create(appView, upperBoundType, lowerBoundType);
    }

    @Override
    public DynamicType rewrittenWithLens(AppView<AppInfoWithLiveness> appView, GraphLens graphLens, Set<DexType> prunedTypes) {
        TypeElement rewrittenDynamicLowerBoundType;
        if (this.isBottom() || this.isNullType() || this.isUnknown()) {
            return this;
        }
        TypeElement rewrittenDynamicUpperBoundType = this.dynamicUpperBoundType.rewrittenWithLens(appView, graphLens, null, prunedTypes);
        ClassTypeElement rewrittenDynamicLowerBoundClassType = null;
        if (this.hasDynamicLowerBoundType() && (rewrittenDynamicLowerBoundType = this.getDynamicLowerBoundType().rewrittenWithLens(appView, graphLens, null, prunedTypes)).isClassType()) {
            rewrittenDynamicLowerBoundClassType = rewrittenDynamicLowerBoundType.asClassType();
        }
        return rewrittenDynamicLowerBoundClassType != null ? DynamicTypeWithUpperBound.create(appView, rewrittenDynamicUpperBoundType, rewrittenDynamicLowerBoundClassType) : DynamicTypeWithUpperBound.create(appView, rewrittenDynamicUpperBoundType);
    }

    public boolean strictlyLessThan(TypeElement type, AppView<AppInfoWithLiveness> appView) {
        DynamicTypeWithUpperBound dynamicType = DynamicTypeWithUpperBound.create(appView, type);
        return this.strictlyLessThan(dynamicType, appView);
    }

    public boolean strictlyLessThan(DynamicTypeWithUpperBound dynamicType, AppView<?> appView) {
        if (this.equals(dynamicType)) {
            return false;
        }
        if (this.getDynamicUpperBoundType().equals(dynamicType.getDynamicUpperBoundType())) {
            if (!dynamicType.hasDynamicLowerBoundType()) {
                return this.hasDynamicLowerBoundType();
            }
            return this.hasDynamicLowerBoundType() && dynamicType.getDynamicLowerBoundType().strictlyLessThan(this.getDynamicLowerBoundType(), appView);
        }
        if (!this.getDynamicUpperBoundType().strictlyLessThan(dynamicType.getDynamicUpperBoundType(), appView)) {
            return false;
        }
        if (!dynamicType.hasDynamicLowerBoundType()) {
            return true;
        }
        return this.hasDynamicLowerBoundType() && dynamicType.getDynamicLowerBoundType().lessThanOrEqualUpToNullability(this.getDynamicUpperBoundType(), appView);
    }

    @Override
    public boolean equals(Object other) {
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DynamicTypeWithUpperBound dynamicType = (DynamicTypeWithUpperBound)other;
        return this.dynamicUpperBoundType.equals(dynamicType.dynamicUpperBoundType);
    }

    @Override
    public int hashCode() {
        return this.dynamicUpperBoundType.hashCode();
    }

    @Override
    public DynamicTypeWithUpperBound withNullability(Nullability nullability) {
        assert (!this.hasDynamicLowerBoundType());
        if (!this.getDynamicUpperBoundType().isReferenceType()) {
            return this;
        }
        ReferenceTypeElement dynamicUpperBoundReferenceType = this.getDynamicUpperBoundType().asReferenceType();
        if (dynamicUpperBoundReferenceType.nullability() == nullability) {
            return this;
        }
        return new DynamicTypeWithUpperBound(dynamicUpperBoundReferenceType.getOrCreateVariant(nullability));
    }
}

