/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.type;

import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2BooleanMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2BooleanMaps;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2BooleanOpenHashMap;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.OptionalBool;
import com.android.tools.r8.utils.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class InterfaceCollection {
    private static final InterfaceCollection EMPTY = new InterfaceCollection(Reference2BooleanMaps.emptyMap());
    private final Reference2BooleanMap<DexType> interfaces;

    public static boolean isKnownToImplement(DexType iface, DexType implementor, InternalOptions options) {
        return !options.canHaveZipFileWithMissingCloseableBug() || implementor != options.dexItemFactory().zipFileType || iface != options.dexItemFactory().closeableType;
    }

    public static InterfaceCollection empty() {
        return EMPTY;
    }

    public static InterfaceCollection singleton(DexType type) {
        return new InterfaceCollection(Reference2BooleanMaps.singleton(type, true));
    }

    public static Builder builder() {
        return new Builder();
    }

    private InterfaceCollection(Reference2BooleanMap<DexType> interfaces) {
        assert (interfaces != null);
        this.interfaces = interfaces;
    }

    public boolean isEmpty() {
        return this.interfaces.isEmpty();
    }

    public int size() {
        return this.interfaces.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InterfaceCollection)) {
            return false;
        }
        InterfaceCollection that = (InterfaceCollection)o;
        return this.interfaces.equals(that.interfaces);
    }

    public int hashCode() {
        return this.interfaces.hashCode();
    }

    public void forEach(BiConsumer<DexType, Boolean> fn) {
        this.interfaces.forEach(fn);
    }

    public void forEachKnownInterface(Consumer<DexType> consumer) {
        this.forEach((type, isKnown) -> {
            if (isKnown.booleanValue()) {
                consumer.accept((DexType)type);
            }
        });
    }

    public boolean allKnownInterfacesMatch(Predicate<DexType> fn) {
        for (Reference2BooleanMap.Entry entry : this.interfaces.reference2BooleanEntrySet()) {
            if (!entry.getBooleanValue() || fn.test((DexType)entry.getKey())) continue;
            return false;
        }
        return true;
    }

    public boolean anyMatch(BiPredicate<DexType, Boolean> fn) {
        for (Reference2BooleanMap.Entry entry : this.interfaces.reference2BooleanEntrySet()) {
            if (!fn.test((DexType)entry.getKey(), entry.getBooleanValue())) continue;
            return true;
        }
        return false;
    }

    public List<Pair<DexType, Boolean>> getInterfaceList() {
        ArrayList<Pair<DexType, Boolean>> list = new ArrayList<Pair<DexType, Boolean>>(this.interfaces.size());
        this.interfaces.forEach((? super K iface, ? super V isKnown) -> list.add(new Pair<DexType, Boolean>((DexType)iface, (Boolean)isKnown)));
        return list;
    }

    public boolean hasSingleKnownInterface() {
        DexType singleKnownInterface = this.getSingleKnownInterface();
        return singleKnownInterface != null;
    }

    public DexType getSingleKnownInterface() {
        if (this.interfaces.size() != 1) {
            return null;
        }
        DexType type = (DexType)this.interfaces.keySet().iterator().next();
        return this.interfaces.getBoolean(type) ? type : null;
    }

    public OptionalBool contains(DexType type) {
        Boolean value = this.interfaces.get(type);
        if (value == null) {
            return OptionalBool.FALSE;
        }
        return value != false ? OptionalBool.TRUE : OptionalBool.unknown();
    }

    public boolean containsKnownInterface(DexType type) {
        return this.contains(type).isTrue();
    }

    public static class Builder {
        private Reference2BooleanMap<DexType> interfaces = new Reference2BooleanOpenHashMap<DexType>();

        private Builder() {
        }

        public Builder addInterface(DexType iface, DexClass implementor, InternalOptions options) {
            return this.addInterface(iface, !implementor.isLibraryClass() || InterfaceCollection.isKnownToImplement(iface, implementor.getType(), options));
        }

        public Builder addInterface(DexType iface, DexType implementor, InternalOptions options) {
            return this.addInterface(iface, InterfaceCollection.isKnownToImplement(iface, implementor, options));
        }

        public Builder addInterface(DexType type, boolean isKnown) {
            this.interfaces.compute(type, (existingType, existingIsKnown) -> (existingIsKnown == null || existingIsKnown != false) && isKnown);
            return this;
        }

        public Builder addKnownInterface(DexType type) {
            return this.addInterface(type, true);
        }

        public InterfaceCollection build() {
            if (this.interfaces.isEmpty()) {
                return InterfaceCollection.empty();
            }
            return new InterfaceCollection(this.interfaces);
        }
    }
}

