/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.type;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.code.Assume;
import com.android.tools.r8.ir.code.InstanceGet;
import com.android.tools.r8.ir.code.InstancePut;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionOrPhi;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.StaticPut;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.WorkList;
import java.util.Objects;

public class TypeUtils {
    public static TypeElement computeUseType(AppView<AppInfoWithLiveness> appView, ProgramMethod method, Value value) {
        TypeElement staticType = value.getType();
        TypeElement useType = TypeElement.getBottom();
        WorkList<UserAndValuePair> users = WorkList.newEqualityWorkList();
        TypeUtils.enqueueUsers(value, users);
        while (users.hasNext()) {
            UserAndValuePair item = users.next();
            InstructionOrPhi user = item.user;
            if (user.isPhi()) {
                TypeUtils.enqueueUsers(user.asPhi(), users);
                continue;
            }
            Instruction instruction = user.asInstruction();
            TypeElement instructionUseType = TypeUtils.computeUseTypeForInstruction(appView, method, instruction, item.value, users);
            if (!(useType = useType.join(instructionUseType, appView)).isTop() && !useType.equalUpToNullability(staticType)) continue;
            return staticType;
        }
        return useType;
    }

    private static void enqueueUsers(Value value, WorkList<UserAndValuePair> users) {
        for (Instruction instruction : value.uniqueUsers()) {
            users.addIfNotSeen(new UserAndValuePair(instruction, value));
        }
        for (Phi phi : value.uniquePhiUsers()) {
            users.addIfNotSeen(new UserAndValuePair(phi, value));
        }
    }

    private static TypeElement computeUseTypeForInstruction(AppView<AppInfoWithLiveness> appView, ProgramMethod method, Instruction instruction, Value value, WorkList<UserAndValuePair> users) {
        switch (instruction.opcode()) {
            case 9: {
                return TypeUtils.computeUseTypeForAssume(instruction.asAssume(), users);
            }
            case 10: 
            case 25: {
                return TypeElement.getBottom();
            }
            case 28: {
                return TypeUtils.computeUseTypeForInstanceGet(appView, instruction.asInstanceGet());
            }
            case 30: {
                return TypeUtils.computeUseTypeForInstancePut(appView, instruction.asInstancePut(), value);
            }
            case 33: 
            case 34: 
            case 38: 
            case 39: 
            case 40: {
                return TypeUtils.computeUseTypeForInvoke(appView, instruction.asInvokeMethod(), value);
            }
            case 56: {
                return TypeUtils.computeUseTypeForReturn(appView, method);
            }
            case 60: {
                return TypeUtils.computeUseTypeForStaticPut(appView, instruction.asStaticPut());
            }
        }
        return TypeElement.getTop();
    }

    private static TypeElement computeUseTypeForAssume(Assume assume, WorkList<UserAndValuePair> users) {
        TypeUtils.enqueueUsers(assume.outValue(), users);
        return TypeElement.getBottom();
    }

    private static TypeElement computeUseTypeForInstanceGet(AppView<AppInfoWithLiveness> appView, InstanceGet instanceGet) {
        return instanceGet.getField().getHolderType().toTypeElement(appView);
    }

    private static TypeElement computeUseTypeForInstancePut(AppView<AppInfoWithLiveness> appView, InstancePut instancePut, Value value) {
        DexField field = instancePut.getField();
        TypeElement useType = TypeElement.getBottom();
        if (instancePut.object() == value) {
            useType = useType.join(field.getHolderType().toTypeElement(appView), appView);
        }
        if (instancePut.value() == value) {
            useType = useType.join(field.getType().toTypeElement(appView), appView);
        }
        return useType;
    }

    private static TypeElement computeUseTypeForInvoke(AppView<AppInfoWithLiveness> appView, InvokeMethod invoke, Value value) {
        TypeElement useType = TypeElement.getBottom();
        for (int argumentIndex = 0; argumentIndex < invoke.arguments().size(); ++argumentIndex) {
            Value argument = invoke.getArgument(argumentIndex);
            if (argument != value) continue;
            TypeElement useTypeForArgument = invoke.getInvokedMethod().getArgumentType(argumentIndex, invoke.isInvokeStatic()).toTypeElement(appView);
            useType = useType.join(useTypeForArgument, appView);
        }
        assert (!((TypeElement)useType).isBottom());
        return useType;
    }

    private static TypeElement computeUseTypeForReturn(AppView<AppInfoWithLiveness> appView, ProgramMethod method) {
        return method.getReturnType().toTypeElement(appView);
    }

    private static TypeElement computeUseTypeForStaticPut(AppView<AppInfoWithLiveness> appView, StaticPut staticPut) {
        return staticPut.getField().getType().toTypeElement(appView);
    }

    public static boolean isNullPointerException(TypeElement type, AppView<?> appView) {
        return type.isClassType() && type.asClassType().getClassType() == appView.dexItemFactory().npeType;
    }

    private static class UserAndValuePair {
        final InstructionOrPhi user;
        final Value value;

        UserAndValuePair(InstructionOrPhi user, Value value) {
            this.user = user;
            this.value = value;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            UserAndValuePair pair = (UserAndValuePair)obj;
            return this.user == pair.user && this.value == pair.value;
        }

        public int hashCode() {
            return Objects.hash(this.user, this.value);
        }
    }
}

