/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.value;

import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.value.SingleConstClassValue;
import com.android.tools.r8.ir.analysis.value.SingleDexItemBasedStringValue;
import com.android.tools.r8.ir.analysis.value.SingleFieldValue;
import com.android.tools.r8.ir.analysis.value.SingleNumberValue;
import com.android.tools.r8.ir.analysis.value.SingleStatefulFieldValue;
import com.android.tools.r8.ir.analysis.value.SingleStatelessFieldValue;
import com.android.tools.r8.ir.analysis.value.SingleStringValue;
import com.android.tools.r8.ir.analysis.value.objectstate.KnownLengthArrayState;
import com.android.tools.r8.ir.analysis.value.objectstate.ObjectState;
import com.android.tools.r8.naming.dexitembasedstring.NameComputationInfo;
import java.util.concurrent.ConcurrentHashMap;

public class AbstractValueFactory {
    private ConcurrentHashMap<DexType, SingleConstClassValue> singleConstClassValues = new ConcurrentHashMap();
    private ConcurrentHashMap<Long, SingleNumberValue> singleNumberValues = new ConcurrentHashMap();
    private ConcurrentHashMap<DexString, SingleStringValue> singleStringValues = new ConcurrentHashMap();
    private ConcurrentHashMap<Integer, KnownLengthArrayState> knownArrayLengthStates = new ConcurrentHashMap();

    public SingleConstClassValue createSingleConstClassValue(DexType type) {
        return this.singleConstClassValues.computeIfAbsent(type, SingleConstClassValue::new);
    }

    public KnownLengthArrayState createKnownLengthArrayState(int length) {
        return this.knownArrayLengthStates.computeIfAbsent(length, KnownLengthArrayState::new);
    }

    public SingleFieldValue createSingleFieldValue(DexField field, ObjectState state) {
        return state.isEmpty() ? new SingleStatelessFieldValue(field) : new SingleStatefulFieldValue(field, state);
    }

    public SingleNumberValue createSingleNumberValue(long value) {
        return this.singleNumberValues.computeIfAbsent(value, SingleNumberValue::new);
    }

    public SingleNumberValue createNullValue() {
        return this.createSingleNumberValue(0L);
    }

    public SingleNumberValue createZeroValue() {
        return this.createSingleNumberValue(0L);
    }

    public SingleStringValue createSingleStringValue(DexString string) {
        return this.singleStringValues.computeIfAbsent(string, SingleStringValue::new);
    }

    public SingleDexItemBasedStringValue createSingleDexItemBasedStringValue(DexReference reference, NameComputationInfo<?> nameComputationInfo) {
        return new SingleDexItemBasedStringValue(reference, nameComputationInfo);
    }
}

