/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.value;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.ir.analysis.value.AbstractValue;
import com.android.tools.r8.ir.analysis.value.AbstractValueFactory;
import com.android.tools.r8.ir.analysis.value.ConstantOrNonConstantNumberValue;
import com.android.tools.r8.ir.analysis.value.NonConstantNumberValue;
import com.android.tools.r8.ir.analysis.value.SingleNumberValue;
import com.android.tools.r8.ir.analysis.value.UnknownValue;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntArraySet;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntIterator;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntSet;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.ArrayUtils;
import com.android.tools.r8.utils.OptionalBool;
import java.util.Arrays;

public class NumberFromSetValue
extends NonConstantNumberValue {
    private static final int MAX_SIZE = 30;
    private final IntSet numbers;

    private NumberFromSetValue(IntSet numbers) {
        this.numbers = numbers;
    }

    static Builder builder() {
        return new Builder();
    }

    static Builder builder(SingleNumberValue singleNumberValue) {
        return new Builder().addInt(singleNumberValue.getIntValue());
    }

    Builder instanceBuilder() {
        return new Builder(this);
    }

    @Override
    public boolean containsInt(int value) {
        return this.numbers.contains(value);
    }

    @Override
    public long getAbstractionSize() {
        return this.numbers.size();
    }

    @Override
    public boolean isNumberFromSetValue() {
        return true;
    }

    @Override
    public NumberFromSetValue asNumberFromSetValue() {
        return this;
    }

    @Override
    public boolean isNonTrivial() {
        return true;
    }

    @Override
    public OptionalBool isSubsetOf(int[] values2) {
        assert (ArrayUtils.isSorted(values2));
        IntIterator intIterator = this.numbers.iterator();
        while (intIterator.hasNext()) {
            int number = (Integer)intIterator.next();
            if (Arrays.binarySearch(values2, number) >= 0) continue;
            return OptionalBool.FALSE;
        }
        return OptionalBool.TRUE;
    }

    @Override
    public boolean mayOverlapWith(ConstantOrNonConstantNumberValue other) {
        if (other.isSingleNumberValue()) {
            return this.containsInt(other.asSingleNumberValue().getIntValue());
        }
        assert (other.isNonConstantNumberValue());
        IntIterator intIterator = this.numbers.iterator();
        while (intIterator.hasNext()) {
            int number = (Integer)intIterator.next();
            if (!other.containsInt(number)) continue;
            return true;
        }
        return false;
    }

    @Override
    public AbstractValue rewrittenWithLens(AppView<AppInfoWithLiveness> appView, GraphLens lens, GraphLens codeLens) {
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        NumberFromSetValue numberFromSetValue = (NumberFromSetValue)o;
        return this.numbers.equals(numberFromSetValue.numbers);
    }

    @Override
    public int hashCode() {
        return this.numbers.hashCode();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("NumberFromSetValue(");
        IntIterator iterator2 = this.numbers.iterator();
        builder.append(iterator2.nextInt());
        while (iterator2.hasNext()) {
            builder.append(", ").append(iterator2.nextInt());
        }
        return builder.append(")").toString();
    }

    static class Builder {
        private IntSet numbers;

        Builder() {
            this.numbers = new IntArraySet();
        }

        Builder(NumberFromSetValue numberFromSetValue) {
            this.numbers = new IntArraySet(numberFromSetValue.numbers);
        }

        Builder addInt(int number) {
            if (this.numbers != null) {
                assert (this.numbers.size() <= 30);
                if (this.numbers.add(number) && this.numbers.size() > 30) {
                    this.numbers = null;
                }
            }
            return this;
        }

        Builder addInts(NumberFromSetValue numberFromSetValue) {
            if (this.numbers != null) {
                assert (this.numbers.size() <= 30);
                if (this.numbers.addAll(numberFromSetValue.numbers) && this.numbers.size() > 30) {
                    this.numbers = null;
                }
            }
            return this;
        }

        AbstractValue build(AbstractValueFactory abstractValueFactory) {
            if (this.numbers != null) {
                assert (!this.numbers.isEmpty());
                assert (this.numbers.size() <= 30);
                if (this.numbers.size() == 1) {
                    return abstractValueFactory.createSingleNumberValue(this.numbers.iterator().nextInt());
                }
                return new NumberFromSetValue(this.numbers);
            }
            return UnknownValue.getInstance();
        }
    }
}

