/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.value;

import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DebugLocalInfo;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.proto.ArgumentInfoCollection;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.analysis.value.SingleConstValue;
import com.android.tools.r8.ir.analysis.value.SingleValue;
import com.android.tools.r8.ir.code.DexItemBasedConstString;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.NumberGenerator;
import com.android.tools.r8.ir.code.TypeAndLocalInfoSupplier;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.info.field.InstanceFieldInitializationInfo;
import com.android.tools.r8.naming.dexitembasedstring.NameComputationInfo;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import java.util.Objects;

public class SingleDexItemBasedStringValue
extends SingleConstValue {
    private final DexReference item;
    private final NameComputationInfo<?> nameComputationInfo;

    SingleDexItemBasedStringValue(DexReference item, NameComputationInfo<?> nameComputationInfo) {
        this.item = item;
        this.nameComputationInfo = nameComputationInfo;
    }

    public DexReference getItem() {
        return this.item;
    }

    public NameComputationInfo<?> getNameComputationInfo() {
        return this.nameComputationInfo;
    }

    @Override
    public boolean isSingleDexItemBasedStringValue() {
        return true;
    }

    @Override
    public SingleDexItemBasedStringValue asSingleDexItemBasedStringValue() {
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingleDexItemBasedStringValue value = (SingleDexItemBasedStringValue)o;
        return this.item == value.item && this.nameComputationInfo == value.nameComputationInfo;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.item, this.nameComputationInfo);
    }

    @Override
    public String toString() {
        return "DexItemBasedConstString(" + this.item.toSourceString() + ")";
    }

    @Override
    public Instruction createMaterializingInstruction(AppView<? extends AppInfoWithClassHierarchy> appView, ProgramMethod context, NumberGenerator valueNumberGenerator, TypeAndLocalInfoSupplier info) {
        TypeElement typeLattice = info.getOutType();
        DebugLocalInfo debugLocalInfo = info.getLocalInfo();
        assert (typeLattice.isClassType());
        assert (appView.isSubtype(appView.dexItemFactory().stringType, typeLattice.asClassType().getClassType()).isTrue());
        Value returnedValue = new Value(valueNumberGenerator.next(), TypeElement.stringClassType(appView, Nullability.definitelyNotNull()), debugLocalInfo);
        DexItemBasedConstString instruction = new DexItemBasedConstString(returnedValue, this.item, this.nameComputationInfo);
        assert (!instruction.instructionInstanceCanThrow());
        return instruction;
    }

    @Override
    public boolean isMaterializableInContext(AppView<AppInfoWithLiveness> appView, ProgramMethod context) {
        return true;
    }

    @Override
    public boolean isMaterializableInAllContexts(AppView<AppInfoWithLiveness> appView) {
        return true;
    }

    @Override
    public InstanceFieldInitializationInfo fixupAfterParametersChanged(ArgumentInfoCollection argumentInfoCollection) {
        return this;
    }

    @Override
    public SingleValue rewrittenWithLens(AppView<AppInfoWithLiveness> appView, GraphLens lens, GraphLens codeLens) {
        return appView.abstractValueFactory().createSingleDexItemBasedStringValue(lens.rewriteReference(this.item, codeLens), this.nameComputationInfo);
    }
}

