/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.value;

import com.android.tools.r8.features.ClassToFeatureSplitMap;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.ProgramDefinition;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.proto.ArgumentInfoCollection;
import com.android.tools.r8.ir.analysis.type.ClassTypeElement;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.analysis.value.AbstractValueFactory;
import com.android.tools.r8.ir.analysis.value.SingleValue;
import com.android.tools.r8.ir.analysis.value.objectstate.ObjectState;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.NumberGenerator;
import com.android.tools.r8.ir.code.StaticGet;
import com.android.tools.r8.ir.code.TypeAndLocalInfoSupplier;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.enums.EnumDataMap;
import com.android.tools.r8.ir.optimize.info.field.InstanceFieldInitializationInfo;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.synthesis.SyntheticItems;
import com.android.tools.r8.utils.ForEachUtils;

public abstract class SingleFieldValue
extends SingleValue {
    final DexField field;

    SingleFieldValue(DexField field) {
        this.field = field;
    }

    public DexField getField() {
        return this.field;
    }

    public DexEncodedField getField(DexDefinitionSupplier definitions) {
        DexClass holder = definitions.definitionFor(this.field.getHolderType());
        return this.field.lookupOnClass(holder);
    }

    @Override
    public abstract ObjectState getObjectState();

    @Override
    public abstract boolean hasObjectState();

    public boolean mayHaveFinalizeMethodDirectlyOrIndirectly(AppView<AppInfoWithLiveness> appView) {
        DexType fieldType = this.field.type;
        if (fieldType.isClassType()) {
            ClassTypeElement fieldClassType = TypeElement.fromDexType(fieldType, Nullability.maybeNull(), appView).asClassType();
            return appView.appInfo().mayHaveFinalizeMethodDirectlyOrIndirectly(fieldClassType);
        }
        assert (fieldType.isArrayType() || fieldType.isPrimitiveType());
        return false;
    }

    @Override
    public boolean isSingleFieldValue() {
        return true;
    }

    @Override
    public SingleFieldValue asSingleFieldValue() {
        return this;
    }

    @Override
    public abstract boolean equals(Object var1);

    @Override
    public abstract int hashCode();

    @Override
    public Instruction createMaterializingInstruction(AppView<? extends AppInfoWithClassHierarchy> appView, ProgramMethod context, NumberGenerator valueNumberGenerator, TypeAndLocalInfoSupplier info) {
        TypeElement type = TypeElement.fromDexType(this.field.type, Nullability.maybeNull(), appView);
        assert (type.lessThanOrEqual(info.getOutType(), appView) || type.isBasedOnMissingClass(appView));
        Value outValue = new Value(valueNumberGenerator.next(), type, info.getLocalInfo());
        return new StaticGet(outValue, this.field);
    }

    @Override
    public boolean isMaterializableInContext(AppView<AppInfoWithLiveness> appView, ProgramMethod context) {
        return ForEachUtils.allMatch(appView.appInfo().resolveField(this.field)::forEachFieldResolutionResult, resolutionResult -> {
            if (resolutionResult.isPossiblyFailedOrUnknownResolution()) {
                return false;
            }
            return resolutionResult.isAccessibleFrom((ProgramDefinition)context, appView).isTrue();
        });
    }

    @Override
    public boolean isMaterializableInAllContexts(AppView<AppInfoWithLiveness> appView) {
        DexEncodedField encodedField = appView.appInfo().resolveField(this.field).getResolvedField();
        if (encodedField == null) {
            assert (false);
            return false;
        }
        if (!encodedField.isPublic()) {
            return false;
        }
        DexClass holder = appView.definitionFor(encodedField.getHolderType());
        if (holder == null) {
            assert (false);
            return false;
        }
        if (!holder.isPublic()) {
            return false;
        }
        ClassToFeatureSplitMap classToFeatureSplitMap = appView.appInfo().getClassToFeatureSplitMap();
        SyntheticItems syntheticItems = appView.getSyntheticItems();
        return !holder.isProgramClass() || !classToFeatureSplitMap.isInFeature(holder.asProgramClass(), syntheticItems);
    }

    @Override
    public InstanceFieldInitializationInfo fixupAfterParametersChanged(ArgumentInfoCollection argumentInfoCollection) {
        return this;
    }

    @Override
    public SingleValue rewrittenWithLens(AppView<AppInfoWithLiveness> appView, GraphLens lens, GraphLens codeLens) {
        EnumDataMap enumDataMap;
        AbstractValueFactory factory = appView.abstractValueFactory();
        if (this.field.holder == this.field.type && (enumDataMap = appView.unboxedEnums()).hasUnboxedValueFor(this.field)) {
            return factory.createSingleNumberValue(enumDataMap.getUnboxedValue(this.field));
        }
        DexField rewrittenField = lens.lookupField(this.field, codeLens);
        ObjectState rewrittenObjectState = this.getObjectState().rewrittenWithLens(appView, lens, codeLens);
        if (rewrittenField != this.field || rewrittenObjectState != this.getObjectState()) {
            return factory.createSingleFieldValue(rewrittenField, rewrittenObjectState);
        }
        return this;
    }
}

