/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.value;

import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DebugLocalInfo;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.proto.ArgumentInfoCollection;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.analysis.value.ConstantOrNonConstantNumberValue;
import com.android.tools.r8.ir.analysis.value.SingleConstValue;
import com.android.tools.r8.ir.analysis.value.SingleValue;
import com.android.tools.r8.ir.code.ConstNumber;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.NumberGenerator;
import com.android.tools.r8.ir.code.TypeAndLocalInfoSupplier;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.info.field.InstanceFieldInitializationInfo;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.ArrayUtils;
import com.android.tools.r8.utils.OptionalBool;

public class SingleNumberValue
extends SingleConstValue
implements ConstantOrNonConstantNumberValue {
    private final long value;

    SingleNumberValue(long value) {
        this.value = value;
    }

    @Override
    public boolean containsInt(int value) {
        return value == this.getIntValue();
    }

    @Override
    public OptionalBool isSubsetOf(int[] values2) {
        return OptionalBool.of(ArrayUtils.containsInt(values2, this.getIntValue()));
    }

    @Override
    public boolean isSingleBoolean() {
        return this.isFalse() || this.isTrue();
    }

    @Override
    public boolean isFalse() {
        return this.value == 0L;
    }

    @Override
    public boolean isTrue() {
        return this.value == 1L;
    }

    @Override
    public boolean isSingleNumberValue() {
        return true;
    }

    @Override
    public SingleNumberValue asSingleNumberValue() {
        return this;
    }

    @Override
    public boolean isConstantOrNonConstantNumberValue() {
        return true;
    }

    @Override
    public ConstantOrNonConstantNumberValue asConstantOrNonConstantNumberValue() {
        return this;
    }

    public boolean getBooleanValue() {
        assert (this.value == 0L || this.value == 1L);
        return this.value != 0L;
    }

    public double getDoubleValue() {
        return Double.longBitsToDouble(this.value);
    }

    public float getFloatValue() {
        return Float.intBitsToFloat((int)this.value);
    }

    public int getIntValue() {
        return (int)this.value;
    }

    public long getLongValue() {
        return this.value;
    }

    public long getValue() {
        return this.value;
    }

    @Override
    public boolean mayOverlapWith(ConstantOrNonConstantNumberValue other) {
        if (other.isSingleNumberValue()) {
            return this.equals(other.asSingleNumberValue());
        }
        assert (other.isNonConstantNumberValue());
        return other.asNonConstantNumberValue().containsInt(this.getIntValue());
    }

    @Override
    public boolean equals(Object o) {
        return this == o;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public String toString() {
        return "SingleNumberValue(" + this.value + ")";
    }

    @Override
    public Instruction createMaterializingInstruction(AppView<? extends AppInfoWithClassHierarchy> appView, ProgramMethod context, NumberGenerator valueNumberGenerator, TypeAndLocalInfoSupplier info) {
        TypeElement typeLattice = info.getOutType();
        DebugLocalInfo debugLocalInfo = info.getLocalInfo();
        assert (!typeLattice.isReferenceType() || this.value == 0L);
        Value returnedValue = new Value(valueNumberGenerator.next(), typeLattice.isReferenceType() ? TypeElement.getNull() : typeLattice, debugLocalInfo);
        return new ConstNumber(returnedValue, this.value);
    }

    @Override
    public boolean isMaterializableInContext(AppView<AppInfoWithLiveness> appView, ProgramMethod context) {
        return true;
    }

    @Override
    public boolean isMaterializableInAllContexts(AppView<AppInfoWithLiveness> appView) {
        return true;
    }

    @Override
    public InstanceFieldInitializationInfo fixupAfterParametersChanged(ArgumentInfoCollection argumentInfoCollection) {
        return this;
    }

    @Override
    public SingleValue rewrittenWithLens(AppView<AppInfoWithLiveness> appView, GraphLens lens, GraphLens codeLens) {
        return this;
    }
}

