/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.value;

import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DebugLocalInfo;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.proto.ArgumentInfoCollection;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.analysis.value.SingleConstValue;
import com.android.tools.r8.ir.analysis.value.SingleValue;
import com.android.tools.r8.ir.code.ConstString;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.NumberGenerator;
import com.android.tools.r8.ir.code.TypeAndLocalInfoSupplier;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.info.field.InstanceFieldInitializationInfo;
import com.android.tools.r8.shaking.AppInfoWithLiveness;

public class SingleStringValue
extends SingleConstValue {
    private final DexString string;

    SingleStringValue(DexString string) {
        this.string = string;
    }

    @Override
    public boolean isSingleStringValue() {
        return true;
    }

    @Override
    public SingleStringValue asSingleStringValue() {
        return this;
    }

    public DexString getDexString() {
        return this.string;
    }

    @Override
    public boolean equals(Object o) {
        return this == o;
    }

    @Override
    public int hashCode() {
        return this.string.hashCode();
    }

    @Override
    public String toString() {
        return "SingleStringValue(" + this.string + ")";
    }

    @Override
    public Instruction createMaterializingInstruction(AppView<? extends AppInfoWithClassHierarchy> appView, ProgramMethod context, NumberGenerator valueNumberGenerator, TypeAndLocalInfoSupplier info) {
        TypeElement typeLattice = info.getOutType();
        DebugLocalInfo debugLocalInfo = info.getLocalInfo();
        assert (typeLattice.isClassType());
        assert (appView.isSubtype(appView.dexItemFactory().stringType, typeLattice.asClassType().getClassType()).isTrue());
        Value returnedValue = new Value(valueNumberGenerator.next(), TypeElement.stringClassType(appView, Nullability.definitelyNotNull()), debugLocalInfo);
        ConstString instruction = new ConstString(returnedValue, this.string);
        assert (!instruction.instructionInstanceCanThrow());
        return instruction;
    }

    @Override
    public boolean isMaterializableInContext(AppView<AppInfoWithLiveness> appView, ProgramMethod context) {
        return true;
    }

    @Override
    public boolean isMaterializableInAllContexts(AppView<AppInfoWithLiveness> appView) {
        return true;
    }

    @Override
    public InstanceFieldInitializationInfo fixupAfterParametersChanged(ArgumentInfoCollection argumentInfoCollection) {
        return this;
    }

    @Override
    public SingleValue rewrittenWithLens(AppView<AppInfoWithLiveness> appView, GraphLens lens, GraphLens codeLens) {
        return this;
    }
}

