/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.value;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.ir.analysis.value.AbstractValue;
import com.android.tools.r8.ir.analysis.value.UnknownValue;
import com.android.tools.r8.ir.analysis.value.objectstate.ObjectState;
import com.android.tools.r8.shaking.AppInfoWithLiveness;

public class StatefulObjectValue
extends AbstractValue {
    private final ObjectState state;

    StatefulObjectValue(ObjectState state) {
        assert (!state.isEmpty());
        this.state = state;
    }

    public static AbstractValue create(ObjectState objectState) {
        return objectState.isEmpty() ? UnknownValue.getInstance() : new StatefulObjectValue(objectState);
    }

    @Override
    public boolean isNonTrivial() {
        return true;
    }

    @Override
    public boolean isStatefulObjectValue() {
        return true;
    }

    @Override
    public StatefulObjectValue asStatefulObjectValue() {
        return this;
    }

    @Override
    public boolean hasKnownArrayLength() {
        return this.getObjectState().hasKnownArrayLength();
    }

    @Override
    public int getKnownArrayLength() {
        return this.getObjectState().getKnownArrayLength();
    }

    @Override
    public AbstractValue rewrittenWithLens(AppView<AppInfoWithLiveness> appView, GraphLens lens, GraphLens codeLens) {
        return StatefulObjectValue.create(this.getObjectState().rewrittenWithLens(appView, lens, codeLens));
    }

    @Override
    public boolean hasObjectState() {
        return true;
    }

    @Override
    public ObjectState getObjectState() {
        return this.state;
    }

    @Override
    public String toString() {
        return "StatefulValue";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatefulObjectValue statefulObjectValue = (StatefulObjectValue)o;
        return this.state.equals(statefulObjectValue.state);
    }

    @Override
    public int hashCode() {
        return this.state.hashCode();
    }
}

