/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.value.objectstate;

import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.value.AbstractValue;
import com.android.tools.r8.ir.analysis.value.SingleValue;
import com.android.tools.r8.ir.analysis.value.objectstate.EmptyObjectState;
import com.android.tools.r8.ir.analysis.value.objectstate.EnumValuesObjectState;
import com.android.tools.r8.ir.analysis.value.objectstate.NonEmptyObjectState;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Predicate;

public abstract class ObjectState {
    public static Builder builder() {
        return new Builder();
    }

    public static ObjectState empty() {
        return EmptyObjectState.getInstance();
    }

    public abstract void forEachAbstractFieldValue(BiConsumer<DexField, AbstractValue> var1);

    public final boolean hasMaterializableFieldValueThatMatches(AppView<AppInfoWithLiveness> appView, DexEncodedField field, ProgramMethod context, Predicate<SingleValue> predicate) {
        AbstractValue abstractValue = this.getAbstractFieldValue(field);
        if (!abstractValue.isSingleValue()) {
            return false;
        }
        SingleValue singleValue = abstractValue.asSingleValue();
        if (!singleValue.isMaterializableInContext(appView, context)) {
            return false;
        }
        return predicate.test(singleValue);
    }

    public abstract AbstractValue getAbstractFieldValue(DexEncodedField var1);

    public abstract boolean isEmpty();

    public abstract ObjectState rewrittenWithLens(AppView<AppInfoWithLiveness> var1, GraphLens var2, GraphLens var3);

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public boolean hasKnownArrayLength() {
        return false;
    }

    public int getKnownArrayLength() {
        throw new Unreachable();
    }

    public boolean isEnumValuesObjectState() {
        return false;
    }

    public EnumValuesObjectState asEnumValuesObjectState() {
        return null;
    }

    public static class Builder {
        private final Map<DexField, AbstractValue> state = new IdentityHashMap<DexField, AbstractValue>();

        public void recordFieldHasValue(DexEncodedField field, AbstractValue abstractValue) {
            if (!abstractValue.isUnknown()) {
                assert (!this.state.containsKey(field.getReference()));
                this.state.put((DexField)field.getReference(), abstractValue);
            }
        }

        public ObjectState build() {
            return this.state.isEmpty() ? ObjectState.empty() : new NonEmptyObjectState(this.state);
        }
    }
}

